/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands;

import java.util.List;
import java.util.Vector;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jst.pagedesigner.dom.EditValidateUtil;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.w3c.dom.Node;

public class CopyNodeCommand
extends Command {
    private IHTMLGraphicalViewer _viewer;

    public CopyNodeCommand(IHTMLGraphicalViewer viewer) {
        super("");
        this._viewer = viewer;
    }

    public void execute() {
        List parts = this._viewer.getSelectedEditParts();
        Vector<Node> result = new Vector<Node>();
        if (parts.size() > 0) {
            int i = 0;
            int n = parts.size();
            while (i < n) {
                EditPart part = (EditPart)parts.get(i);
                Object model = part.getModel();
                if (model instanceof Node) {
                    EditValidateUtil.validNode((Node)model);
                    result.add(((Node)model).cloneNode(true));
                }
                ++i;
            }
            this.setClipboard(result);
        }
    }

    private void setClipboard(Vector result) {
        Node[] nodes = result.toArray(new Node[result.size()]);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int size = nodes.length;
        while (i < size) {
            DOMUtil.nodeToString(nodes[i], sb);
            ++i;
        }
        Clipboard board = new Clipboard(this._viewer.getControl().getDisplay());
        board.setContents(new Object[]{result, sb.toString()}, new Transfer[]{TemplateTransfer.getInstance(), TextTransfer.getInstance()});
    }
}

