/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preview.editors;

import java.util.HashMap;
import org.eclipse.birt.report.designer.internal.ui.dialogs.InputParameterHtmlDialog;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.birt.report.viewer.browsers.BrowserManager;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.part.EditorPart;

public abstract class ReportPreviewEditor
extends EditorPart {
    private Button bParameter;
    private Browser browser;
    private Composite mainPane;
    private ProgressBar progressBar;
    protected InputParameterHtmlDialog parameterDialog;
    private HashMap<String, String> options;
    private boolean suggestShowParameterPage;

    public void doSave(IProgressMonitor monitor) {
        IReportProvider provider = this.getProvider();
        if (provider != null) {
            provider.saveReport(this.getModel(), (Object)this.getEditorInput(), monitor);
            this.firePropertyChange(257);
        }
    }

    protected abstract IReportProvider getProvider();

    public boolean isDirty() {
        return false;
    }

    public void createPartControl(Composite parent) {
        final ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        this.mainPane = new Composite((Composite)sc, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        this.mainPane.setLayout((Layout)layout);
        this.mainPane.setLayoutData((Object)new GridData(1808));
        final Composite buttonTray = new Composite(this.mainPane, 0);
        GridData gData = new GridData(1808);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = false;
        buttonTray.setLayoutData((Object)gData);
        layout = new GridLayout(2, false);
        layout.marginWidth = 5;
        layout.horizontalSpacing = 0;
        buttonTray.setLayout((Layout)layout);
        this.bParameter = new Button(buttonTray, 8);
        this.bParameter.setToolTipText(Messages.getString((String)"PreviewEditor.parameter.hint"));
        this.bParameter.setText(Messages.getString((String)"PreviewEditor.parameter.hint"));
        GridData gd = new GridData();
        this.bParameter.setLayoutData((Object)gd);
        final FormText note = new FormText(buttonTray, 0);
        note.setText(this.getDisplayInfoText(ViewerPlugin.getDefault().getPluginPreferences().getString("preview_maxrow")), true, true);
        note.setSize(-11, -1);
        gd = new GridData();
        gd.horizontalIndent = 20;
        note.setLayoutData((Object)gd);
        note.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                boolean ret;
                if (PreferencesUtil.createPreferenceDialogOn((Shell)UIUtil.getDefaultShell(), (String)"org.eclipse.birt.report.designer.ui.preferences.PreviewDataPreferencePage", (String[])new String[]{"org.eclipse.birt.report.designer.ui.preferences.PreviewDataPreferencePage"}, null).open() == 0 && (ret = MessageDialog.openQuestion((Shell)UIUtil.getDefaultShell(), (String)Messages.getString((String)"PreviewEditor.ConfirmRefresh.Title"), (String)Messages.getString((String)"PreviewEditor.ConfirmRefresh.Message")))) {
                    ReportPreviewEditor.this.refresh();
                }
            }
        });
        final Preferences.IPropertyChangeListener prefListener = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                if (note != null && !note.isDisposed() && "preview_maxrow".equals(event.getProperty())) {
                    note.setText(ReportPreviewEditor.this.getDisplayInfoText(ViewerPlugin.getDefault().getPluginPreferences().getString("preview_maxrow")), true, true);
                    buttonTray.layout();
                }
            }
        };
        note.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ViewerPlugin.getDefault().getPluginPreferences().removePropertyChangeListener(prefListener);
            }
        });
        ViewerPlugin.getDefault().getPluginPreferences().addPropertyChangeListener(prefListener);
        this.progressBar = new ProgressBar(this.mainPane, 2);
        gd = new GridData(3, 2, false, false);
        gd.heightHint = 10;
        gd.widthHint = 100;
        this.progressBar.setLayoutData((Object)gd);
        this.progressBar.setVisible(false);
        this.createMainBrowser();
        if (BrowserManager.getInstance().isEmbeddedBrowserPresent()) {
            this.parameterDialog = new InputParameterHtmlDialog(Display.getCurrent().getActiveShell(), InputParameterHtmlDialog.TITLE, this.getFileUri(), this.browser);
        }
        if (this.bParameter != null) {
            this.bParameter.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReportPreviewEditor.this.refresh();
                }
            });
        }
        sc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                sc.setMinSize(buttonTray.computeSize(-1, -1));
                ReportPreviewEditor.this.mainPane.layout();
            }
        });
        sc.setContent((Control)this.mainPane);
    }

    private String getDisplayInfoText(String maxRow) {
        return "<form><p><b>" + Messages.getString((String)"PreviewEditor.parameter.note") + "</b> " + Messages.getFormattedString((String)"PreviewEditor.parameter.info", (Object[])new String[]{maxRow}) + " (<a>" + Messages.getString((String)"PreviewEditor.parameter.change") + "</a>)</p></form>";
    }

    private void createMainBrowser() {
        if (BrowserManager.getInstance().isEmbeddedBrowserPresent()) {
            if (this.browser != null && !this.browser.isDisposed()) {
                this.browser.dispose();
            }
            this.browser = "linux".equalsIgnoreCase(Platform.getOS()) ? new Browser(this.mainPane, 32768) : new Browser(this.mainPane, 0);
            GridData gd = new GridData(1808);
            gd.horizontalSpan = 1;
            this.browser.setLayoutData((Object)gd);
            this.browser.addProgressListener(new ProgressListener(){

                public void changed(ProgressEvent event) {
                }

                public void completed(ProgressEvent event) {
                    ReportPreviewEditor.this.progressBar.setVisible(false);
                }
            });
            this.browser.addOpenWindowListener(new OpenWindowListener(){

                public void open(WindowEvent event) {
                    Shell shell = UIUtil.createDefaultShell();
                    shell.setLayout((Layout)new FillLayout());
                    Browser browser = "linux".equalsIgnoreCase(Platform.getOS()) ? new Browser((Composite)shell, 32768) : new Browser((Composite)shell, 0);
                    ReportPreviewEditor.initialize(Display.getCurrent(), browser);
                    event.browser = browser;
                    shell.open();
                }
            });
            this.browser.addCloseWindowListener(new CloseWindowListener(){

                public void close(WindowEvent event) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            ReportPreviewEditor.this.createMainBrowser();
                            ReportPreviewEditor.this.mainPane.layout(true);
                        }
                    });
                }
            });
        } else {
            Composite control = new Composite(this.mainPane, 0);
            GridData gd = new GridData(1808);
            gd.horizontalSpan = 1;
            control.setLayoutData((Object)gd);
            this.bParameter.setEnabled(false);
            this.progressBar.setVisible(false);
            control.setBackground(Display.getDefault().getSystemColor(1));
            control.setLayout((Layout)new GridLayout());
            Label message = new Label(control, 0);
            message.setText(Messages.getString((String)"PreviewEditor.browser.notfound"));
            message.setBackground(Display.getDefault().getSystemColor(1));
        }
    }

    protected boolean refresh() {
        return true;
    }

    protected void enableParameterControl(boolean value) {
        if (this.bParameter != null && !this.bParameter.isDisposed()) {
            this.bParameter.setEnabled(value);
        }
    }

    protected void showProgress() {
        if (this.progressBar != null && !this.progressBar.isDisposed()) {
            this.progressBar.setVisible(true);
        }
    }

    protected void hideProgress() {
        if (this.progressBar != null && !this.progressBar.isDisposed()) {
            this.progressBar.setVisible(false);
        }
    }

    private static void initialize(final Display display, Browser browser) {
        browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                Shell shell = UIUtil.createDefaultShell();
                shell.setLayout((Layout)new FillLayout());
                Browser browser = "linux".equalsIgnoreCase(Platform.getOS()) ? new Browser((Composite)shell, 32768) : new Browser((Composite)shell, 0);
                ReportPreviewEditor.initialize(display, browser);
                event.browser = browser;
                shell.open();
            }
        });
        browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                if (event.title != null && event.title.length() > 0) {
                    Browser browser = (Browser)event.widget;
                    Shell shell = browser.getShell();
                    shell.setText(event.title);
                }
            }
        });
    }

    public ModuleHandle getModel() {
        IReportProvider provider = this.getProvider();
        if (provider != null) {
            return provider.queryReportModuleHandle();
        }
        return null;
    }

    protected void createActions() {
    }

    public String getFileUri() {
        IReportProvider provider;
        IEditorInput input = this.getEditorInput();
        if (input != null && (provider = this.getProvider()) != null) {
            return provider.getInputPath(input).toOSString();
        }
        return null;
    }

    public void display() {
        String uri = this.getFileUri();
        if (uri != null && uri.length() > 0) {
            if (this.options == null) {
                this.options = new HashMap();
                this.options.put("SERVLET_NAME_KEY", "run");
                this.options.put("FORMAT_KEY", "html");
            }
            this.options.put("RESOURCE_FOLDER_KEY", ReportPlugin.getDefault().getResourceFolder());
            this.options.put("MAX_ROWS_KEY", ViewerPlugin.getDefault().getPluginPreferences().getString("preview_maxrow"));
            String extKey = ViewerPlugin.getDefault().getPluginPreferences().getString("APPCONTEXT_EXTENSION_KEY");
            if (extKey != null && extKey.length() > 0) {
                this.options.put("APPCONTEXT_EXTENSION_KEY", extKey);
            } else {
                this.options.remove("APPCONTEXT_EXTENSION_KEY");
            }
            if (this.suggestShowParameterPage) {
                this.options.put("SHOW_PARAMETER_PAGE", "true");
            } else {
                this.options.remove("SHOW_PARAMETER_PAGE");
            }
            System.clearProperty("TransientSecurityID");
            System.clearProperty("TransientDataSecurityID");
            System.setProperty("MaxDataSetRows", ViewerPlugin.getDefault().getPluginPreferences().getString("preview_maxrow"));
            if (this.browser != null && !this.browser.isDisposed()) {
                WebViewer.display((String)uri, (Browser)this.browser, this.options);
            } else {
                WebViewer.display((String)uri, this.options);
            }
        }
    }

    public void handleLeaveThePage() {
        if (this.browser != null && !this.browser.isDisposed()) {
            WebViewer.cancel((Browser)this.browser);
            this.browser.stop();
            this.browser.setUrl("about:blank");
        }
    }

    public void dispose() {
        super.dispose();
        if (this.browser != null && !this.browser.isDisposed()) {
            WebViewer.cancel((Browser)this.browser);
            this.browser.stop();
        }
        this.bParameter = null;
        this.browser = null;
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(ActionRegistry.class)) {
            new ActionRegistry();
        }
        return super.getAdapter(adapter);
    }
}

