/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.core.preferences;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.tools.forge.core.furnace.FurnaceRuntime;
import org.jboss.tools.forge.core.internal.ForgeCorePlugin;
import org.jboss.tools.forge.core.internal.runtime.ForgeEmbeddedRuntime;
import org.jboss.tools.forge.core.internal.runtime.ForgeExternalRuntime;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.core.runtime.ForgeRuntimeType;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ForgeCorePreferences {
    public static final String PREF_FORGE_RUNTIMES = "org.jboss.tools.forge.core.runtimes";
    public static final String PREF_FORGE_STARTUP = "org.jboss.tools.forge.core.startup";
    public static final String PREF_FORGE_START_IN_DEBUG = "org.jboss.tools.forge.core.startInDebug";
    public static final String PREF_FORGE_VM_ARGS = "org.jboss.tools.forge.core.vmArgs";
    private static final String PREF_FORGE_ADDON_DIR = "org.jboss.tools.forge.ext.core.addon_dir";
    public static final ForgeCorePreferences INSTANCE = new ForgeCorePreferences();
    private List<ForgeRuntime> runtimes = null;
    private ForgeRuntime defaultRuntime = null;
    private String defaultRuntimeName = null;

    private ForgeCorePreferences() {
    }

    public ForgeRuntime[] getRuntimes() {
        if (this.runtimes == null) {
            this.initializeRuntimes();
        }
        return this.runtimes.toArray(new ForgeRuntime[this.runtimes.size()]);
    }

    public ForgeRuntime getDefaultRuntime() {
        if (this.defaultRuntime == null) {
            this.initializeRuntimes();
        }
        return this.defaultRuntime;
    }

    public boolean getStartup() {
        return this.getForgeCorePreferences().getBoolean(PREF_FORGE_STARTUP, false);
    }

    public boolean getStartInDebug() {
        return this.getForgeCorePreferences().getBoolean(PREF_FORGE_START_IN_DEBUG, false);
    }

    public String getVmArgs() {
        return this.getForgeCorePreferences().get(PREF_FORGE_VM_ARGS, "");
    }

    private IEclipsePreferences getForgeCorePreferences() {
        return InstanceScope.INSTANCE.getNode("org.jboss.tools.forge.core");
    }

    private String getForgeRuntimesPreference() {
        return this.getForgeCorePreferences().get(PREF_FORGE_RUNTIMES, "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<forgeRuntimes/>");
    }

    private void initializeRuntimes() {
        this.runtimes = new ArrayList<ForgeRuntime>();
        this.runtimes.add(FurnaceRuntime.INSTANCE);
        this.runtimes.add(ForgeEmbeddedRuntime.INSTANCE);
        this.addFromXml(this.getForgeRuntimesPreference());
        this.initializeDefaultRuntime();
    }

    private void initializeDefaultRuntime() {
        for (ForgeRuntime runtime : this.runtimes) {
            if (!runtime.getName().equals(this.defaultRuntimeName)) continue;
            this.defaultRuntime = runtime;
            break;
        }
        if (this.defaultRuntime == null) {
            this.defaultRuntime = "embedded".equals(this.defaultRuntimeName) ? ForgeEmbeddedRuntime.INSTANCE : FurnaceRuntime.INSTANCE;
            this.defaultRuntimeName = this.defaultRuntime.getName();
        }
    }

    private void addFromXml(String xml) {
        DocumentBuilder documentBuilder = this.newDocumentBuilder();
        if (documentBuilder == null) {
            return;
        }
        InputStream inputStream = this.createInputStream(xml);
        if (inputStream == null) {
            return;
        }
        Document document = this.parseRuntimes(documentBuilder, inputStream);
        Element runtimeElement = document.getDocumentElement();
        this.defaultRuntimeName = runtimeElement.getAttribute("default");
        NodeList nodeList = runtimeElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Element element;
            String type;
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1 && ForgeRuntimeType.valueOf(type = (element = (Element)node).getAttribute("type").toUpperCase()).equals((Object)ForgeRuntimeType.EXTERNAL)) {
                String name = element.getAttribute("name");
                String location = element.getAttribute("location");
                this.runtimes.add(new ForgeExternalRuntime(name, location));
            }
            ++i;
        }
    }

    private Document parseRuntimes(DocumentBuilder documentBuilder, InputStream inputStream) {
        Document result = null;
        try {
            result = documentBuilder.parse(inputStream);
        }
        catch (SAXException e) {
            ForgeCorePlugin.log(e);
        }
        catch (IOException e) {
            ForgeCorePlugin.log(e);
        }
        return result;
    }

    private InputStream createInputStream(String string) {
        BufferedInputStream result = null;
        try {
            result = new BufferedInputStream(new ByteArrayInputStream(string.getBytes("UTF8")));
        }
        catch (UnsupportedEncodingException e) {
            ForgeCorePlugin.log(e);
        }
        return result;
    }

    private DocumentBuilder newDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            ForgeCorePlugin.log(e);
            return null;
        }
    }

    public void setRuntimes(ForgeRuntime[] runtimes, ForgeRuntime defaultRuntime) {
        this.runtimes.clear();
        ForgeRuntime[] forgeRuntimeArray = runtimes;
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            ForgeRuntime runtime = forgeRuntimeArray[n2];
            this.runtimes.add(runtime);
            ++n2;
        }
        this.defaultRuntime = defaultRuntime;
        this.saveRuntimes();
    }

    public void setStartup(boolean startup) {
        try {
            this.setBoolean(PREF_FORGE_STARTUP, startup);
        }
        catch (BackingStoreException e) {
            ForgeCorePlugin.log(e);
        }
    }

    public void setStartInDebug(boolean startup) {
        try {
            this.setBoolean(PREF_FORGE_START_IN_DEBUG, startup);
        }
        catch (BackingStoreException e) {
            ForgeCorePlugin.log(e);
        }
    }

    public void setVmArgs(String vmArgsText) {
        try {
            IEclipsePreferences eclipsePreferences = this.getForgeCorePreferences();
            if (vmArgsText == null) {
                eclipsePreferences.remove(PREF_FORGE_VM_ARGS);
            } else {
                eclipsePreferences.put(PREF_FORGE_VM_ARGS, vmArgsText);
            }
            eclipsePreferences.flush();
        }
        catch (BackingStoreException e) {
            ForgeCorePlugin.log(e);
        }
    }

    private void setBoolean(String prefKey, boolean startup) throws BackingStoreException {
        IEclipsePreferences eclipsePreferences = this.getForgeCorePreferences();
        eclipsePreferences.putBoolean(prefKey, startup);
        eclipsePreferences.flush();
    }

    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        this.getForgeCorePreferences().addPreferenceChangeListener(listener);
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        this.getForgeCorePreferences().removePreferenceChangeListener(listener);
    }

    private void saveRuntimes() {
        try {
            IEclipsePreferences eclipsePreferences = this.getForgeCorePreferences();
            String xml = ForgeCorePreferences.serializeDocument(this.createRuntimesDocument());
            eclipsePreferences.put(PREF_FORGE_RUNTIMES, xml);
            eclipsePreferences.flush();
        }
        catch (IOException e) {
            ForgeCorePlugin.log(e);
        }
        catch (TransformerException e) {
            ForgeCorePlugin.log(e);
        }
        catch (BackingStoreException e) {
            ForgeCorePlugin.log(e);
        }
    }

    private Document createRuntimesDocument() {
        Document document = this.createEmptyDocument();
        if (document == null) {
            return null;
        }
        Element main = document.createElement("forgeRuntimes");
        document.appendChild(main);
        for (ForgeRuntime runtime : this.runtimes) {
            Element element = document.createElement("runtime");
            element.setAttribute("name", runtime.getName());
            if (!(runtime instanceof ForgeEmbeddedRuntime)) {
                element.setAttribute("location", runtime.getLocation());
            }
            element.setAttribute("type", runtime.getType().name().toLowerCase());
            main.appendChild(element);
        }
        if (this.defaultRuntime != null) {
            main.setAttribute("default", this.defaultRuntime.getName());
        }
        return document;
    }

    private Document createEmptyDocument() {
        DocumentBuilder documentBuilder = this.newDocumentBuilder();
        if (documentBuilder == null) {
            return null;
        }
        return documentBuilder.newDocument();
    }

    private static String serializeDocument(Document doc) throws TransformerException, IOException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(s);
        transformer.transform(source, outputTarget);
        return s.toString("UTF8");
    }

    public String getAddonDir() {
        IEclipsePreferences prefs = this.getForgeCorePreferences();
        return prefs.get(PREF_FORGE_ADDON_DIR, new File(OperatingSystemUtils.getUserForgeDir(), "addons").getAbsolutePath());
    }

    public void setAddonDir(String addonDir) {
        IEclipsePreferences prefs = this.getForgeCorePreferences();
        prefs.put(PREF_FORGE_ADDON_DIR, addonDir);
        try {
            prefs.flush();
            this.restartForge();
        }
        catch (BackingStoreException bse) {
            ForgeCorePlugin.log(bse);
        }
        catch (BundleException e) {
            ForgeCorePlugin.log(e);
        }
    }

    private void restartForge() throws BundleException {
        Bundle bundle = Platform.getBundle((String)"org.jboss.tools.forge.core");
        bundle.stop();
        bundle.start();
    }
}

