/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.core.io;

import org.jboss.tools.forge.core.io.ForgeOutputFilter;
import org.jboss.tools.forge.core.io.ForgeOutputListener;

public abstract class ForgeHiddenOutputFilter
implements ForgeOutputFilter {
    private ForgeOutputListener target = null;
    private boolean hidden = false;
    private StringBuffer hiddenBuffer = new StringBuffer();
    private StringBuffer targetBuffer = new StringBuffer();
    private StringBuffer escapeSequence = new StringBuffer();

    public ForgeHiddenOutputFilter() {
    }

    public ForgeHiddenOutputFilter(ForgeOutputListener target) {
        this.target = target;
    }

    protected ForgeOutputListener getTarget() {
        return this.target;
    }

    @Override
    public void outputAvailable(String output) {
        int i = 0;
        while (i < output.length()) {
            char c = output.charAt(i);
            if (c == '\u001b') {
                if (this.escapeSequence.length() == 0) {
                    this.escapeSequence.append(c);
                } else {
                    this.escapeSequence.append(c);
                    if (this.hidden) {
                        this.hiddenBuffer.append(this.escapeSequence);
                    } else {
                        this.targetBuffer.append(this.escapeSequence);
                    }
                    this.escapeSequence.setLength(0);
                }
            } else if (c == '%') {
                if (this.escapeSequence.length() == 1) {
                    if (this.hidden) {
                        String toHandle = this.hiddenBuffer.toString();
                        this.hiddenBuffer.setLength(0);
                        this.handleFilteredString(toHandle);
                    } else {
                        String out = this.targetBuffer.toString();
                        this.targetBuffer.setLength(0);
                        if (this.target != null) {
                            this.target.outputAvailable(out);
                        }
                    }
                    this.escapeSequence.setLength(0);
                    this.hidden = !this.hidden;
                } else {
                    this.escapeSequence.append(c);
                    if (this.hidden) {
                        this.hiddenBuffer.append(this.escapeSequence);
                    } else {
                        this.targetBuffer.append(this.escapeSequence);
                    }
                    this.escapeSequence.setLength(0);
                }
            } else {
                this.escapeSequence.append(c);
                if (this.hidden) {
                    this.hiddenBuffer.append(this.escapeSequence);
                } else {
                    this.targetBuffer.append(this.escapeSequence);
                }
                this.escapeSequence.setLength(0);
            }
            ++i;
        }
        if (this.hiddenBuffer.length() == 0 && this.targetBuffer.length() != 0) {
            String out = this.targetBuffer.toString();
            this.targetBuffer.setLength(0);
            if (this.target != null) {
                this.target.outputAvailable(out);
            }
        }
    }
}

