/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IClasspathEntryDescriptor;
import org.eclipse.m2e.wtp.AbstractDependencyConfigurator;
import org.eclipse.m2e.wtp.AbstractProjectConfiguratorDelegate;
import org.eclipse.m2e.wtp.ArtifactHelper;
import org.eclipse.m2e.wtp.MarkedException;
import org.eclipse.m2e.wtp.MavenWtpPlugin;
import org.eclipse.m2e.wtp.PackagingConfiguration;
import org.eclipse.m2e.wtp.ResourceCleaner;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.WarPluginConfiguration;
import org.eclipse.m2e.wtp.internal.ExtensionReader;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.m2e.wtp.internal.filtering.WebResourceFilteringConfiguration;
import org.eclipse.m2e.wtp.internal.utilities.DebugUtilities;
import org.eclipse.m2e.wtp.namemapping.FileNameMapping;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebProjectConfiguratorDelegate
extends AbstractProjectConfiguratorDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(WebProjectConfiguratorDelegate.class);
    static final IClasspathAttribute DEPENDENCY_ATTRIBUTE = JavaCore.newClasspathAttribute((String)"org.eclipse.jst.component.dependency", (String)"/WEB-INF/lib");
    private static final String CLASSPATH_ARCHIVENAME_ATTRIBUTE;
    private static final String M2ECLIPSE_WTP_CONTEXT_ROOT = "m2eclipse.wtp.contextRoot";

    static {
        String archiveNameAttribute = null;
        try {
            Field classpathArchiveNameField = IClasspathDependencyConstants.class.getField("CLASSPATH_ARCHIVENAME_ATTRIBUTE");
            archiveNameAttribute = (String)classpathArchiveNameField.get(null);
        }
        catch (Exception exception) {
            LOG.warn(Messages.WebProjectConfiguratorDelegate_Renamed_Dependencies_Will_Be_Copied);
        }
        CLASSPATH_ARCHIVENAME_ATTRIBUTE = archiveNameAttribute;
    }

    WebProjectConfiguratorDelegate() {
    }

    @Override
    protected void configure(IProject project, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(project.getFile("pom.xml"), true, monitor);
        WarPluginConfiguration config = new WarPluginConfiguration(mavenProject, project);
        String warSourceDirectory = config.getWarSourceDirectory();
        IFolder contentFolder = project.getFolder(warSourceDirectory);
        LinkedHashSet<IFacetedProject.Action> actions = new LinkedHashSet<IFacetedProject.Action>();
        this.installJavaFacet(actions, project, facetedProject);
        IVirtualComponent component = ComponentCore.createComponent((IProject)project, (boolean)true);
        String contextRoot = this.getContextRoot(mavenProject, config.getWarName());
        IProjectFacetVersion webFv = config.getWebFacetVersion(project);
        IDataModel webModelCfg = this.getWebModelConfig(warSourceDirectory, contextRoot);
        if (!facetedProject.hasProjectFacet(WebFacetUtils.WEB_FACET)) {
            WTPProjectsUtil.removeConflictingFacets(facetedProject, webFv, actions);
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, webFv, (Object)webModelCfg));
        } else {
            IProjectFacetVersion projectFacetVersion = facetedProject.getProjectFacetVersion(WebFacetUtils.WEB_FACET);
            if (webFv.getVersionString() != null && !webFv.getVersionString().equals(projectFacetVersion.getVersionString())) {
                actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, webFv, (Object)webModelCfg));
            }
        }
        String customWebXml = config.getCustomWebXml(project);
        if (!actions.isEmpty()) {
            ResourceCleaner fileCleaner = new ResourceCleaner(project, contentFolder);
            try {
                this.addFoldersToClean(fileCleaner, facade);
                fileCleaner.addFiles(contentFolder.getFile("META-INF/MANIFEST.MF").getProjectRelativePath());
                fileCleaner.addFolder(contentFolder.getFolder("WEB-INF/lib"));
                if (customWebXml != null) {
                    fileCleaner.addFiles(contentFolder.getFile("WEB-INF/web.xml").getProjectRelativePath());
                }
                facetedProject.modify(actions, monitor);
            }
            finally {
                fileCleaner.cleanUp();
            }
        }
        this.fixMissingModuleCoreNature(project, monitor);
        this.removeTestFolderLinks(project, mavenProject, monitor, "/WEB-INF/classes");
        this.addContainerAttribute(project, DEPENDENCY_ATTRIBUTE, monitor);
        if (!contextRoot.equals(J2EEProjectUtilities.getServerContextRoot((IProject)project))) {
            J2EEProjectUtilities.setServerContextRoot((IProject)project, (String)contextRoot);
        }
        if (customWebXml != null) {
            this.linkFileFirst(project, customWebXml, "/WEB-INF/web.xml", monitor);
        }
        if ((component = ComponentCore.createComponent((IProject)project, (boolean)true)) != null) {
            boolean useWebresourcefiltering;
            IPath warPath = new Path("/").append(contentFolder.getProjectRelativePath());
            ArrayList<IPath> sourcePaths = new ArrayList<IPath>();
            sourcePaths.add(warPath);
            if (!WTPProjectsUtil.hasLink(project, ROOT_PATH, warPath, monitor)) {
                component.getRootFolder().createLink(warPath, 0, monitor);
            }
            IPath filteredFolder = new Path("/").append(WebResourceFilteringConfiguration.getTargetFolder(mavenProject, project));
            boolean useBuildDir = MavenWtpPlugin.getDefault().getMavenWtpPreferencesManager().getPreferences(project).isWebMavenArchiverUsesBuildDirectory();
            boolean bl = useWebresourcefiltering = config.getWebResources() != null && config.getWebResources().length > 0 || config.isFilteringDeploymentDescriptorsEnabled();
            if (useBuildDir || useWebresourcefiltering) {
                if (!useBuildDir && useWebresourcefiltering) {
                    this.mavenMarkerManager.addMarker((IResource)project, "org.eclipse.m2e.core.maven2Problem.wtp.configuration", Messages.markers_mavenarchiver_output_settings_ignored_warning, -1, 1);
                }
                sourcePaths.add(filteredFolder);
                WTPProjectsUtil.insertLinkBefore(project, filteredFolder, warPath, (IPath)new Path("/"), monitor);
            } else {
                component.getRootFolder().removeLink(filteredFolder, 0, monitor);
            }
            WTPProjectsUtil.deleteLinks(project, ROOT_PATH, sourcePaths, monitor);
            WTPProjectsUtil.setDefaultDeploymentDescriptorFolder(component.getRootFolder(), warPath, monitor);
            this.addComponentExclusionPatterns(component, config);
        }
        WTPProjectsUtil.removeWTPClasspathContainer(project);
    }

    private IDataModel getWebModelConfig(String warSourceDirectory, String contextRoot) {
        IDataModel webModelCfg = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetInstallDataModelProvider());
        webModelCfg.setProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", (Object)warSourceDirectory);
        webModelCfg.setProperty("IWebFacetInstallDataModelProperties.CONTEXT_ROOT", (Object)contextRoot);
        webModelCfg.setProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", (Object)false);
        webModelCfg.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
        return webModelCfg;
    }

    @Override
    public void setModuleDependencies(IProject project, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        IVirtualReference[] newRefs;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            return;
        }
        this.fixMissingModuleCoreNature(project, monitor);
        DebugUtilities.debug("==============Processing " + project.getName() + " dependencies ===============");
        WarPluginConfiguration config = new WarPluginConfiguration(mavenProject, project);
        PackagingConfiguration opts = new PackagingConfiguration(config.getPackagingIncludes(), config.getPackagingExcludes());
        FileNameMapping fileNameMapping = config.getFileNameMapping();
        List<AbstractDependencyConfigurator> depConfigurators = ExtensionReader.readDependencyConfiguratorExtensions(this.projectManager, MavenPlugin.getMavenRuntimeManager(), this.mavenMarkerManager);
        LinkedHashSet<IVirtualReference> references = new LinkedHashSet<IVirtualReference>();
        List<IMavenProjectFacade> exportedDependencies = this.getWorkspaceDependencies(project, mavenProject);
        HashSet<String> dups = new HashSet<String>();
        HashSet<String> names = new HashSet<String>();
        HashMap<IVirtualReference, Artifact> referenceMapping = new HashMap<IVirtualReference, Artifact>(exportedDependencies.size());
        for (IMavenProjectFacade dependency : exportedDependencies) {
            String depPackaging = dependency.getPackaging();
            if ("pom".equals(depPackaging) || "war".equals(depPackaging) || "zip".equals(depPackaging)) continue;
            try {
                boolean isDeployed;
                this.preConfigureDependencyProject(dependency, monitor);
                if (!ModuleCoreNature.isFlexibleProject((IProject)dependency.getProject())) continue;
                MavenProject depMavenProject = dependency.getMavenProject(monitor);
                IVirtualComponent depComponent = ComponentCore.createComponent((IProject)dependency.getProject());
                ArtifactKey artifactKey = ArtifactHelper.toArtifactKey(depMavenProject.getArtifact());
                Artifact artifact = ArtifactHelper.getArtifact(mavenProject.getArtifacts(), artifactKey);
                if (artifact == null) {
                    artifact = depMavenProject.getArtifact();
                }
                ArtifactHelper.fixArtifactHandler(artifact.getArtifactHandler());
                String deployedName = fileNameMapping.mapFileName(artifact);
                boolean bl = isDeployed = !artifact.isOptional() && opts.isPackaged("WEB-INF/lib/" + deployedName);
                if (!isDeployed) continue;
                IVirtualReference reference = ComponentCore.createReference((IVirtualComponent)component, (IVirtualComponent)depComponent);
                Path path = new Path("/WEB-INF/lib");
                reference.setArchiveName(deployedName);
                reference.setRuntimePath((IPath)path);
                references.add(reference);
                referenceMapping.put(reference, artifact);
                if (names.add(deployedName)) continue;
                dups.add(deployedName);
            }
            catch (RuntimeException ex) {
                String dump = DebugUtilities.dumpProjectState("An error occured while configuring a dependency of  " + project.getName() + DebugUtilities.SEP, dependency.getProject());
                LOG.error(dump);
                throw ex;
            }
        }
        for (IVirtualReference reference : references) {
            if (!dups.contains(reference.getArchiveName())) continue;
            Artifact a = (Artifact)referenceMapping.get(reference);
            String newName = String.valueOf(a.getGroupId()) + "-" + reference.getArchiveName();
            reference.setArchiveName(newName);
        }
        IVirtualReference[] oldRefs = WTPProjectsUtil.extractHardReferences(component, false);
        if (WTPProjectsUtil.hasChanged(oldRefs, newRefs = references.toArray(new IVirtualReference[references.size()]))) {
            IVirtualReference[] overlayRefs = WTPProjectsUtil.extractHardReferences(component, true);
            IVirtualReference[] allRefs = new IVirtualReference[overlayRefs.length + newRefs.length];
            System.arraycopy(newRefs, 0, allRefs, 0, newRefs.length);
            System.arraycopy(overlayRefs, 0, allRefs, newRefs.length, overlayRefs.length);
            component.setReferences(allRefs);
        }
        for (IMavenProjectFacade dependency : exportedDependencies) {
            MavenProject depMavenProject = dependency.getMavenProject(monitor);
            Iterator<AbstractDependencyConfigurator> configurators = depConfigurators.iterator();
            while (configurators.hasNext()) {
                try {
                    configurators.next().configureDependency(mavenProject, project, depMavenProject, dependency.getProject(), monitor);
                }
                catch (MarkedException markedException) {}
            }
        }
    }

    protected String getContextRoot(MavenProject mavenProject, String warName) {
        String finalName;
        String property = mavenProject.getProperties().getProperty(M2ECLIPSE_WTP_CONTEXT_ROOT);
        String contextRoot = StringUtils.isBlank((String)property) ? (StringUtils.isBlank((String)(finalName = warName)) || finalName.equals(String.valueOf(mavenProject.getArtifactId()) + "-" + mavenProject.getVersion()) ? mavenProject.getArtifactId() : finalName) : property;
        return contextRoot.trim().replace(" ", "_");
    }

    @Override
    public void configureClasspath(IProject project, MavenProject mavenProject, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
        WarPluginConfiguration config = new WarPluginConfiguration(mavenProject, project);
        PackagingConfiguration opts = new PackagingConfiguration(config.getPackagingIncludes(), config.getPackagingExcludes());
        LinkedHashSet<String> dups = new LinkedHashSet<String>();
        HashSet<String> names = new HashSet<String>();
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            IVirtualReference[] iVirtualReferenceArray = component.getReferences();
            int n = iVirtualReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVirtualReference vr = iVirtualReferenceArray[n2];
                if (!vr.getReferencedComponent().isBinary()) {
                    names.add(vr.getArchiveName());
                }
                ++n2;
            }
        }
        FileNameMapping fileNameMapping = config.getFileNameMapping();
        String targetDir = mavenProject.getBuild().getDirectory();
        for (IClasspathEntryDescriptor descriptor : classpath.getEntryDescriptors()) {
            boolean isDeployed;
            String scope = descriptor.getScope();
            Artifact artifact = ArtifactHelper.getArtifact(mavenProject.getArtifacts(), descriptor.getArtifactKey());
            ArtifactHelper.fixArtifactHandler(artifact.getArtifactHandler());
            String deployedName = fileNameMapping.mapFileName(artifact);
            boolean bl = isDeployed = ("compile".equals(scope) || "runtime".equals(scope)) && !descriptor.isOptionalDependency() && opts.isPackaged("WEB-INF/lib/" + deployedName) && !this.isWorkspaceProject(artifact);
            if (!isDeployed) {
                descriptor.setClasspathAttribute(NONDEPENDENCY_ATTRIBUTE.getName(), NONDEPENDENCY_ATTRIBUTE.getValue());
                continue;
            }
            String fileName = descriptor.getPath().lastSegment();
            if (!deployedName.equals(fileName)) {
                if (CLASSPATH_ARCHIVENAME_ATTRIBUTE == null) {
                    IPath newPath = descriptor.getPath().removeLastSegments(1).append(deployedName);
                    if (!new File(newPath.toOSString()).exists()) {
                        newPath = this.renameArtifact(targetDir, descriptor.getPath(), deployedName);
                    }
                    if (newPath != null) {
                        descriptor.setPath(newPath);
                    }
                } else {
                    descriptor.getClasspathAttributes().put(CLASSPATH_ARCHIVENAME_ATTRIBUTE, deployedName);
                }
            }
            if (names.add(deployedName)) continue;
            dups.add(deployedName);
        }
        for (IClasspathEntryDescriptor descriptor : classpath.getEntryDescriptors()) {
            if (descriptor.getClasspathAttributes().containsKey(NONDEPENDENCY_ATTRIBUTE.getName()) || !dups.contains(descriptor.getPath().lastSegment())) continue;
            String newName = String.valueOf(descriptor.getGroupId()) + "-" + descriptor.getPath().lastSegment();
            if (CLASSPATH_ARCHIVENAME_ATTRIBUTE == null) {
                IPath newPath = this.renameArtifact(targetDir, descriptor.getPath(), newName);
                if (newPath == null) continue;
                descriptor.setPath(newPath);
                continue;
            }
            descriptor.getClasspathAttributes().put(CLASSPATH_ARCHIVENAME_ATTRIBUTE, newName);
        }
    }

    @Deprecated
    private IPath renameArtifact(String targetDir, IPath source, String newName) {
        File src = new File(source.toOSString());
        File dst = new File(targetDir, newName);
        try {
            if (src.isFile() && src.canRead()) {
                if (WebProjectConfiguratorDelegate.isDifferent(src, dst)) {
                    FileUtils.copyFile((File)src, (File)dst);
                    dst.setLastModified(src.lastModified());
                }
                return Path.fromOSString((String)dst.getCanonicalPath());
            }
        }
        catch (IOException ex) {
            LOG.error(Messages.WebProjectConfiguratorDelegate_File_Copy_Failed, (Throwable)ex);
        }
        return null;
    }

    private boolean isWorkspaceProject(Artifact artifact) {
        IMavenProjectFacade facade = this.projectManager.getMavenProject(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        return facade != null && facade.getFullPath(artifact.getFile()) != null;
    }

    @Deprecated
    private static boolean isDifferent(File src, File dst) {
        if (!dst.exists()) {
            return true;
        }
        return src.length() != dst.length() || src.lastModified() != dst.lastModified();
    }
}

