/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.ui.ca;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.ui.internal.contentassist.IRelevanceCompletionProposal;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.AbstractContentAssistProcessor;
import org.eclipse.wst.xml.ui.internal.util.SharedXMLEditorPluginImageHelper;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.el.core.ca.AbstractELCompletionEngine;
import org.jboss.tools.common.el.core.ca.ELTextProposal;
import org.jboss.tools.common.el.core.ca.MessagesELTextProposal;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.ELResolverFactoryManager;
import org.jboss.tools.common.el.ui.ElUiPlugin;
import org.jboss.tools.common.el.ui.internal.info.ELInfoHover;
import org.jboss.tools.common.el.ui.internal.info.Messages;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.common.ui.CommonUIPlugin;
import org.jboss.tools.common.util.EclipseUIUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class ELProposalProcessor
extends AbstractContentAssistProcessor {
    private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];
    private static final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    public static final Comparator<IJavaElement> CASE_INSENSITIVE_ORDER = new Comparator<IJavaElement>(){

        @Override
        public int compare(IJavaElement o1, IJavaElement o2) {
            return String.CASE_INSENSITIVE_ORDER.compare(o1.getElementName(), o2.getElementName());
        }
    };
    private char[] autoActivChars;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        int start = 0;
        int end = document.getLength();
        int[] region = this.getRegion(document, offset);
        if (region != null) {
            start = region[0];
            end = region[1];
        }
        return this.computeCompletionProposals(viewer, offset, start, end);
    }

    private int[] getRegion(IDocument document, int offset) {
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
        try {
            IDOMDocument xmlDocument;
            IDOMDocument iDOMDocument = xmlDocument = model instanceof IDOMModel ? ((IDOMModel)model).getDocument() : null;
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr) && !(n instanceof Text)) {
                return null;
            }
            int start = 0;
            int end = document.getLength();
            if (n instanceof IDOMNode) {
                start = ((IDOMNode)n).getStartOffset();
                end = ((IDOMNode)n).getEndOffset();
            }
            int[] nArray = new int[]{start, end};
            return nArray;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
                model = null;
            }
        }
    }

    protected abstract boolean isEnabled(IFile var1);

    protected abstract Image getImage();

    protected abstract ELContext getELContext(IFile var1);

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset, int start, int end) {
        String restOfEL;
        ITextEditor part = EclipseUIUtil.getActiveEditor();
        if (part == null) {
            return NO_PROPOSALS;
        }
        IEditorInput editorInput = part.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            return NO_PROPOSALS;
        }
        IFile file = ((IFileEditorInput)editorInput).getFile();
        if (!this.isEnabled(file)) {
            return NO_PROPOSALS;
        }
        ELContext context = this.getELContext(file);
        if (context == null) {
            return NO_PROPOSALS;
        }
        ELReference ref = context.getELReference(offset);
        if (ref == null) {
            return NO_PROPOSALS;
        }
        ELResolver[] resolvers = ELResolverFactoryManager.getInstance().getResolvers((IResource)file);
        ArrayList<Proposal> resultList = new ArrayList<Proposal>();
        String prefix = this.getPrefix(viewer, offset, start, end);
        prefix = prefix == null ? "" : prefix;
        String proposalPrefix = "";
        String proposalSufix = "";
        String elStartChar = "#";
        String documentContent = ref.getELModel().getSource();
        int elEndPosition = documentContent.indexOf("#{", offset - ref.getStartPosition());
        int limit = documentContent.indexOf("${", offset - ref.getStartPosition());
        if (limit != -1 && elEndPosition != -1 && limit < elEndPosition) {
            elEndPosition = limit;
        }
        if ((limit = documentContent.indexOf(125, offset - ref.getStartPosition())) != -1 && (elEndPosition == -1 || elEndPosition != -1 && limit < elEndPosition)) {
            elEndPosition = limit + 1;
        }
        String string = restOfEL = elEndPosition == -1 ? "" : documentContent.substring(offset - ref.getStartPosition(), elEndPosition);
        if (restOfEL.indexOf(125) == -1) {
            proposalSufix = "}";
        }
        int i = 0;
        while (i < resolvers.length) {
            List suggestions = resolvers[i].getProposals(context, offset);
            List uniqueSuggestions = AbstractELCompletionEngine.makeProposalsUnique((List)suggestions);
            for (TextProposal kbProposal : uniqueSuggestions) {
                Image image;
                String string2 = kbProposal.getReplacementString();
                Image image2 = image = kbProposal.hasImage() ? CommonUIPlugin.getImageDescriptorRegistry().get(kbProposal.getImageDescriptor()) : this.getImage();
                if (string2.length() < 0) continue;
                string2 = String.valueOf(proposalPrefix) + string2;
                if (string2.length() > 0 && ('#' == string2.charAt(0) || '$' == string2.charAt(0))) {
                    string2 = String.valueOf(elStartChar) + string2.substring(1);
                }
                String additionalProposalInfo = kbProposal.getContextInfo();
                IJavaElement[] javaElements = null;
                MessagesELTextProposal source = null;
                if (kbProposal instanceof ELTextProposal) {
                    javaElements = ((ELTextProposal)kbProposal).getAllJavaElements();
                } else if (kbProposal instanceof MessagesELTextProposal) {
                    source = (MessagesELTextProposal)kbProposal;
                }
                if (string2.startsWith("[") && prefix != null && prefix.indexOf(46) != -1) {
                    String newPrefix = prefix.substring(0, prefix.lastIndexOf(46));
                    if (string2.indexOf(39) != -1 && restOfEL.indexOf(39) != -1) {
                        string2 = string2.substring(0, string2.lastIndexOf(39));
                    }
                    if (string2.indexOf(93) == -1 && restOfEL.indexOf(93) == -1) {
                        string2 = String.valueOf(string2) + ']';
                    }
                    string2 = String.valueOf(string2) + proposalSufix;
                    resultList.add(new Proposal(string2, prefix, newPrefix, offset, offset - (prefix.length() - newPrefix.length()) + string2.length() - proposalSufix.length(), image, kbProposal.getLabel(), kbProposal.getAlternateMatch(), additionalProposalInfo, javaElements, source));
                    continue;
                }
                if (string2.indexOf(39) != -1 && restOfEL.indexOf(39) != -1) {
                    string2 = string2.substring(0, string2.lastIndexOf(39));
                }
                if ((string2.indexOf(91) != -1 || prefix.indexOf(91) != -1 && prefix.indexOf(93, prefix.lastIndexOf(91)) == -1) && string2.indexOf(93) == -1 && restOfEL.indexOf(93) == -1) {
                    string2 = String.valueOf(string2) + ']';
                }
                string2 = String.valueOf(string2) + proposalSufix;
                resultList.add(new Proposal(string2, prefix, offset, offset + string2.length() - proposalSufix.length(), image, kbProposal.getLabel(), kbProposal.getAlternateMatch(), additionalProposalInfo, javaElements, source));
            }
            ++i;
        }
        if (resultList.isEmpty()) {
            return NO_PROPOSALS;
        }
        ICompletionProposal[] resultArray = new ICompletionProposal[resultList.size()];
        resultArray = resultList.toArray(resultArray);
        Arrays.sort(resultArray, new Comparator<ICompletionProposal>(){

            @Override
            public int compare(ICompletionProposal arg0, ICompletionProposal arg1) {
                return arg0.getDisplayString().compareTo(arg1.getDisplayString());
            }
        });
        return resultArray;
    }

    private char getPreceedingQuoteChar(int initialOffset, String restOfCurrentValue) {
        int offset = initialOffset;
        char inQuotesChar = '\u0000';
        while (--offset >= 0) {
            if ('\"' == restOfCurrentValue.charAt(offset) || '\'' == restOfCurrentValue.charAt(offset) && (inQuotesChar == '\u0000' || inQuotesChar == restOfCurrentValue.charAt(offset))) {
                if (initialOffset + offset > 0 && restOfCurrentValue.charAt(offset - 1) == '\\') {
                    int backslashCount = 1;
                    while (offset - backslashCount >= 0 && restOfCurrentValue.charAt(offset - backslashCount) == '\\') {
                        ++backslashCount;
                    }
                    if (backslashCount % 2 != 1) continue;
                    inQuotesChar = inQuotesChar == '\u0000' ? restOfCurrentValue.charAt(offset) : (char)'\u0000';
                    offset -= backslashCount;
                    continue;
                }
                inQuotesChar = inQuotesChar == '\u0000' ? restOfCurrentValue.charAt(offset) : (char)'\u0000';
                continue;
            }
            if ('{' != restOfCurrentValue.charAt(offset) || offset <= 0 || '#' != restOfCurrentValue.charAt(offset - 1) && '$' != restOfCurrentValue.charAt(offset - 1)) continue;
            return inQuotesChar;
        }
        return inQuotesChar;
    }

    private int getELEndPosition(int initialOffset, String restOfCurrentValue) {
        int offset = -1;
        char inQuotesChar = this.getPreceedingQuoteChar(initialOffset, restOfCurrentValue);
        while (++offset < restOfCurrentValue.length() - initialOffset) {
            int backslashCount;
            if (inQuotesChar == '\u0000') {
                if ('}' == restOfCurrentValue.charAt(initialOffset + offset)) {
                    return offset;
                }
                if ('#' == restOfCurrentValue.charAt(initialOffset + offset)) {
                    return -1;
                }
                if ('<' == restOfCurrentValue.charAt(initialOffset + offset)) {
                    return -1;
                }
                if ('>' == restOfCurrentValue.charAt(initialOffset + offset)) {
                    return -1;
                }
                if ('/' == restOfCurrentValue.charAt(initialOffset + offset) && initialOffset + offset + 1 < restOfCurrentValue.length() && '>' == restOfCurrentValue.charAt(initialOffset + offset + 1)) {
                    return -1;
                }
                if ('\"' == restOfCurrentValue.charAt(initialOffset + offset) || '\'' == restOfCurrentValue.charAt(initialOffset + offset)) {
                    inQuotesChar = restOfCurrentValue.charAt(initialOffset + offset);
                }
                if ('\\' != restOfCurrentValue.charAt(initialOffset + offset)) continue;
                backslashCount = 1;
                while (initialOffset + offset + backslashCount < restOfCurrentValue.length() && restOfCurrentValue.charAt(initialOffset + offset + backslashCount) == '\\') {
                    ++backslashCount;
                }
                if (initialOffset + offset + backslashCount >= restOfCurrentValue.length()) {
                    return -1;
                }
                if (backslashCount % 2 != 1 || '\"' != restOfCurrentValue.charAt(initialOffset + offset + backslashCount) && '\'' != restOfCurrentValue.charAt(initialOffset + offset + backslashCount)) continue;
                inQuotesChar = restOfCurrentValue.charAt(initialOffset + offset + backslashCount);
                offset += backslashCount;
                continue;
            }
            if ('\"' == restOfCurrentValue.charAt(initialOffset + offset) || '\'' == restOfCurrentValue.charAt(initialOffset + offset)) {
                inQuotesChar = '\u0000';
            }
            if ('\\' != restOfCurrentValue.charAt(initialOffset + offset)) continue;
            backslashCount = 1;
            while (initialOffset + offset + backslashCount < restOfCurrentValue.length() && restOfCurrentValue.charAt(initialOffset + offset + backslashCount) == '\\') {
                ++backslashCount;
            }
            if (initialOffset + offset + backslashCount >= restOfCurrentValue.length()) {
                return -1;
            }
            if (backslashCount % 2 != 1 || '\"' != restOfCurrentValue.charAt(initialOffset + offset + backslashCount) && '\'' != restOfCurrentValue.charAt(initialOffset + offset + backslashCount)) continue;
            inQuotesChar = '\u0000';
            offset += backslashCount;
        }
        return -1;
    }

    public String getPrefix(ITextViewer viewer, int offset, int start, int end) throws StringIndexOutOfBoundsException {
        IDocument doc = viewer.getDocument();
        if (doc == null || offset > doc.getLength()) {
            return null;
        }
        return this.getPrefix(doc, offset, start, end);
    }

    public String getPrefix(IDocument document, int offset, int start, int end) throws StringIndexOutOfBoundsException {
        if (document == null || document.get() == null || offset > document.get().length()) {
            return null;
        }
        ELInvocationExpression expr = AbstractELCompletionEngine.findExpressionAtOffset((IDocument)document, (int)offset, (int)start, (int)end);
        if (expr == null) {
            return null;
        }
        return document.get().substring(expr.getStartPosition(), offset);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        if (this.autoActivChars == null) {
            IPreferenceStore store = EditorsUI.getPreferenceStore();
            String superDefaultChars = store.getDefaultString("content_assist_autoactivation_triggers_java");
            StringBuffer redhatDefaultChars = new StringBuffer(superDefaultChars);
            if (superDefaultChars.indexOf("{") < 0) {
                redhatDefaultChars.append('{');
            }
            if (superDefaultChars.indexOf(".") < 0) {
                redhatDefaultChars.append('.');
            }
            if (superDefaultChars.indexOf("[") < 0) {
                redhatDefaultChars.append('[');
            }
            this.autoActivChars = new char[redhatDefaultChars.length()];
            redhatDefaultChars.getChars(0, redhatDefaultChars.length(), this.autoActivChars, 0);
            store.setDefault("content_assist_autoactivation_triggers_java", redhatDefaultChars.toString());
            store.setValue("content_assist_autoactivation_triggers_java", redhatDefaultChars.toString());
        }
        return this.autoActivChars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public static final class Proposal
    implements ICompletionProposal,
    ICompletionProposalExtension,
    ICompletionProposalExtension2,
    ICompletionProposalExtension3,
    ICompletionProposalExtension4,
    ICompletionProposalExtension5,
    IRelevanceCompletionProposal {
        private final String fString;
        private final String fPrefix;
        private final String fNewPrefix;
        private final int fOffset;
        private int fNewPosition;
        private String fDisplayString;
        private String fAlternateMatch;
        private Object fAdditionalProposalInfo;
        private IJavaElement[] fJavaElements;
        private MessagesELTextProposal fPropertySource;
        private IInformationControlCreator fCreator;
        private Image fImage;
        private static final String EMPTY_ADDITIONAL_INFO = new String();

        public Proposal(String string, String prefix, int offset) {
            this(string, prefix, offset, offset + string.length());
        }

        public Proposal(String string, String prefix, int offset, int newPosition) {
            this(string, prefix, prefix, offset, offset + string.length(), null, null, null, null, null, null);
        }

        public Proposal(String string, String prefix, int offset, int newPosition, Image image, String displayString, String alternateMatch, String additionalProposalInfo, IJavaElement[] javaElements, MessagesELTextProposal propertySource) {
            this(string, prefix, prefix, offset, offset + string.length(), image, displayString, alternateMatch, additionalProposalInfo, javaElements, propertySource);
        }

        public Proposal(String string, String prefix, String newPrefix, int offset, int newPosition) {
            this(string, prefix, newPrefix, offset, newPosition, null, null, null, null, null, null);
        }

        public Proposal(String string, String prefix, String newPrefix, int offset, int newPosition, Image image, String displayString, String alternateMatch, String additionalProposalInfo, IJavaElement[] javaElements, MessagesELTextProposal propertySource) {
            this.fString = string;
            this.fPrefix = prefix;
            this.fNewPrefix = newPrefix;
            this.fOffset = offset;
            this.fNewPosition = newPosition;
            this.fImage = image;
            this.fDisplayString = displayString;
            this.fAlternateMatch = alternateMatch;
            this.fAdditionalProposalInfo = additionalProposalInfo;
            this.fJavaElements = javaElements;
            if (this.fJavaElements != null && this.fJavaElements.length > 0) {
                this.fAdditionalProposalInfo = null;
            }
            this.fPropertySource = propertySource;
        }

        public void apply(IDocument document) {
            this.apply(null, '\u0000', 0, this.fOffset);
        }

        public Point getSelection(IDocument document) {
            return new Point(this.getCursorPosition(), 0);
        }

        public String getAdditionalProposalInfo() {
            Object info = this.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
            return info == null ? null : info.toString();
        }

        public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
            if (this.fAdditionalProposalInfo == null) {
                if (this.fJavaElements != null && this.fJavaElements.length > 0) {
                    this.fAdditionalProposalInfo = ELInfoHover.getHoverInfo(this.fJavaElements, monitor);
                } else if (this.fPropertySource != null) {
                    this.fAdditionalProposalInfo = ELInfoHover.getHoverInfo(this.fPropertySource.getBaseName(), this.fPropertySource.getPropertyName(), this.fPropertySource.getAllObjects(), monitor);
                }
            }
            if (this.fAdditionalProposalInfo == null) {
                this.fAdditionalProposalInfo = EMPTY_ADDITIONAL_INFO;
            }
            return this.fAdditionalProposalInfo;
        }

        public String getDisplayString() {
            if (this.fDisplayString != null) {
                return this.fDisplayString;
            }
            String dispString = String.valueOf(this.fNewPrefix == null ? this.fPrefix : this.fNewPrefix) + this.fString;
            if (dispString != null) {
                if (dispString.indexOf(123) == -1 && dispString.indexOf(125) != -1) {
                    dispString = dispString.substring(0, dispString.indexOf(125));
                }
                if (dispString.indexOf(123) != -1 && dispString.indexOf(125) == -1) {
                    dispString = String.valueOf(dispString) + "}";
                }
            }
            return dispString;
        }

        public Image getImage() {
            return this.fImage == null ? SharedXMLEditorPluginImageHelper.getImage((String)"icons/full/obj16/attribute_obj.gif") : this.fImage;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public void apply(IDocument document, char trigger, int offset) {
            try {
                int docCharsToReplace = this.fNewPrefix == null || this.fPrefix == null ? 0 : this.fPrefix.length() - this.fNewPrefix.length();
                String replacement = this.fString.substring(offset - this.fOffset);
                document.replace(offset - docCharsToReplace, docCharsToReplace, replacement);
            }
            catch (BadLocationException x) {
                ElUiPlugin.getDefault().logError(x);
            }
        }

        public boolean isValidFor(IDocument document, int offset) {
            return this.validate(document, offset, null);
        }

        public char[] getTriggerCharacters() {
            return null;
        }

        public int getContextInformationPosition() {
            return 0;
        }

        public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
            this.apply(viewer.getDocument(), trigger, offset);
            if (this.fString != null && this.fString.endsWith("}")) {
                --this.fNewPosition;
            }
        }

        public void selected(ITextViewer viewer, boolean smartToggle) {
        }

        public void unselected(ITextViewer viewer) {
        }

        public boolean validate(IDocument document, int offset, DocumentEvent event) {
            try {
                int prefixStart = this.fOffset - this.fPrefix.length();
                return offset >= this.fOffset && (offset < this.fOffset + this.fString.length() && document.get(prefixStart, offset - prefixStart).equals((String.valueOf(this.fPrefix) + this.fString).substring(0, offset - prefixStart)) || this.fAlternateMatch != null && offset < this.fOffset + this.fAlternateMatch.length() && document.get(prefixStart, offset - prefixStart).equals((String.valueOf(this.fPrefix) + this.fAlternateMatch).substring(0, offset - prefixStart)));
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }

        public IInformationControlCreator getInformationControlCreator() {
            final boolean[] browserInformationControlAvailable = new boolean[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = JavaPlugin.getActiveWorkbenchShell();
                    browserInformationControlAvailable[0] = shell != null && BrowserInformationControl.isAvailable((Composite)shell);
                }
            });
            if (!browserInformationControlAvailable[0]) {
                return null;
            }
            if (this.fCreator == null) {
                ELInfoHover.PresenterControlCreator presenterControlCreator = new ELInfoHover.PresenterControlCreator(ELInfoHover.getSite());
                this.fCreator = new ELInfoHover.HoverControlCreator((IInformationControlCreator)presenterControlCreator, Messages.additionalInfo_affordance);
            }
            return this.fCreator;
        }

        public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
            return String.valueOf(this.fPrefix) + this.fString;
        }

        public int getPrefixCompletionStart(IDocument document, int completionOffset) {
            return this.fOffset - this.fPrefix.length();
        }

        public boolean isAutoInsertable() {
            return false;
        }

        public int getCursorPosition() {
            int cursorPosition = -1;
            int openingQuoteInReplacement = this.fString.lastIndexOf(40);
            int closingQuoteInReplacement = this.fString.lastIndexOf(41);
            int openingQuoteInDisplay = this.fDisplayString.lastIndexOf(40);
            int closingQuoteInDisplay = this.fDisplayString.lastIndexOf(41);
            if (openingQuoteInReplacement != -1 && closingQuoteInReplacement != -1 && openingQuoteInDisplay != -1 && closingQuoteInDisplay != -1 && closingQuoteInReplacement - openingQuoteInReplacement != closingQuoteInDisplay - openingQuoteInDisplay) {
                cursorPosition = openingQuoteInReplacement + 1;
            }
            return cursorPosition > -1 ? this.fOffset + cursorPosition : this.fNewPosition;
        }

        public int getRelevance() {
            return 820;
        }

        public String getfAlternateMatch() {
            return this.fAlternateMatch;
        }

        public void setfAlternateMatch(String fAlternateMatch) {
            this.fAlternateMatch = fAlternateMatch;
        }
    }
}

