/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.jvmmonitor.internal.tools;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.jmx.jvmmonitor.core.JvmCoreException;
import org.jboss.tools.jmx.jvmmonitor.internal.tools.IConstants;
import org.jboss.tools.jmx.jvmmonitor.internal.tools.Messages;
import org.jboss.tools.jmx.jvmmonitor.tools.Activator;

public class Tools
implements IPropertyChangeListener,
IConstants {
    private static Tools tools;
    private boolean isReady = this.validateClassPathAndLibraryPath();

    private Tools() {
        if (!this.isReady) {
            Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
            this.configureClassPathAndLibraryPath();
            this.isReady = this.validateClassPathAndLibraryPath();
        }
    }

    public static synchronized Tools getInstance() {
        if (tools == null) {
            tools = new Tools();
        }
        return tools;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("org.jboss.tools.jmx.jvmmonitor.tools.jdkRootDirectory".equals(event.getProperty())) {
            this.configureClassPathAndLibraryPath();
        }
    }

    public boolean isReady() {
        return this.isReady;
    }

    protected Properties invokeGetAgentProperties(Object virtualMachine) throws JvmCoreException {
        try {
            Class<?> clazz = Class.forName("com.sun.tools.attach.VirtualMachine");
            Method method = clazz.getDeclaredMethod("getAgentProperties", new Class[0]);
            return (Properties)method.invoke(virtualMachine, new Object[0]);
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getMessage(), t);
        }
    }

    protected synchronized Object invokeGetMonitoredHost(String name) throws JvmCoreException {
        try {
            Class<?> clazz = Class.forName("sun.jvmstat.monitor.MonitoredHost");
            Method method = clazz.getDeclaredMethod("getMonitoredHost", String.class);
            return method.invoke(null, name);
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getMessage(), t);
        }
    }

    protected Set<Integer> invokeActiveVms(Object monitoredHost) throws JvmCoreException {
        try {
            Class<?> clazz = Class.forName("sun.jvmstat.monitor.MonitoredHost");
            Method method = clazz.getDeclaredMethod("activeVms", new Class[0]);
            return (Set)method.invoke(monitoredHost, new Object[0]);
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getMessage(), t);
        }
    }

    protected Object invokeVmIdentifier(String vmId) throws JvmCoreException {
        try {
            Constructor<?> clazz = Class.forName("sun.jvmstat.monitor.VmIdentifier").getConstructor(String.class);
            return clazz.newInstance(vmId);
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getMessage(), t);
        }
    }

    protected synchronized Object invokeGetMonitoredVm(Object monitoredHost, Object vmIdentifier) throws JvmCoreException {
        try {
            Class<?> clazz = Class.forName("sun.jvmstat.monitor.MonitoredHost");
            Class<?> clazz2 = Class.forName("sun.jvmstat.monitor.VmIdentifier");
            Method method = clazz.getDeclaredMethod("getMonitoredVm", clazz2);
            return method.invoke(monitoredHost, vmIdentifier);
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getMessage(), t);
        }
    }

    protected Object invokeFindByName(Object monitoredVm, String name) throws JvmCoreException {
        try {
            Class<?> clazz = Class.forName("sun.jvmstat.monitor.MonitoredVm");
            Method method = clazz.getDeclaredMethod("findByName", String.class);
            return method.invoke(monitoredVm, name);
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getMessage(), t);
        }
    }

    protected Object invokeGetValue(Object monitor) throws JvmCoreException {
        try {
            Class<?> clazz = Class.forName("sun.jvmstat.monitor.Monitor");
            Method method = clazz.getDeclaredMethod("getValue", new Class[0]);
            return method.invoke(monitor, new Object[0]);
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getMessage(), t);
        }
    }

    protected Object invokeAttach(int pid) throws JvmCoreException {
        try {
            Class<?> clazz = Class.forName("com.sun.tools.attach.VirtualMachine");
            Method method = clazz.getDeclaredMethod("attach", String.class);
            return method.invoke(null, String.valueOf(pid));
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getCause().getMessage(), t);
        }
    }

    protected void invokeDetach(Object vm) throws JvmCoreException {
        try {
            Class<?> clazz = Class.forName("com.sun.tools.attach.VirtualMachine");
            Method method = clazz.getDeclaredMethod("detach", new Class[0]);
            method.invoke(vm, new Object[0]);
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getMessage(), t);
        }
    }

    protected Object invokeGetSystemProperties(Object vm) throws JvmCoreException {
        try {
            Class<?> clazz = Class.forName("com.sun.tools.attach.VirtualMachine");
            Method method = clazz.getDeclaredMethod("getSystemProperties", new Class[0]);
            return method.invoke(vm, new Object[0]);
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getMessage(), t);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void invokeLoadAgent(Object virtualMachine, String path, String options) throws JvmCoreException {
        block3: {
            block4: {
                try {
                    clazz = Class.forName("com.sun.tools.attach.VirtualMachine");
                    method = clazz.getDeclaredMethod("loadAgent", new Class[]{String.class, String.class});
                    method.invoke(virtualMachine, new Object[]{path, options});
                    break block3;
                }
                catch (Throwable t) {
                    message = t.getMessage();
                    if (message != null) break block4;
                    cause = t.getCause();
                    ** while (cause != null)
                }
lbl-1000:
                // 1 sources

                {
                    message = cause.getMessage();
                    if (message != null) break;
                    cause = cause.getCause();
                    continue;
                }
            }
            throw new JvmCoreException(4, message, t);
        }
    }

    protected InputStream invokeHeapHisto(Object virtualMachine, boolean isLive) throws JvmCoreException {
        try {
            Class<?> clazz = Class.forName("sun.tools.attach.HotSpotVirtualMachine");
            Method method = clazz.getDeclaredMethod("heapHisto", Object[].class);
            Object[] arg = new Object[]{isLive ? "-live" : "-all"};
            return (InputStream)method.invoke(virtualMachine, new Object[]{arg});
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getMessage(), t);
        }
    }

    protected String validateJdkRootDirectory(String jdkRootDirectory) {
        File directory = new File(jdkRootDirectory);
        if (!directory.exists() || !directory.isDirectory()) {
            return Messages.directoryNotExistMsg;
        }
        File toolsJarFile = new File(String.valueOf(jdkRootDirectory) + TOOLS_JAR);
        if (!toolsJarFile.exists()) {
            return Messages.notJdkRootDirectoryMsg;
        }
        String libraryPath = Tools.getJreLibraryPath(jdkRootDirectory);
        if (libraryPath != null) {
            return null;
        }
        return Messages.notJdkRootDirectoryMsg;
    }

    private String searchJdkRootDirectory() {
        IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
        int n = iVMInstallTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstallType type = iVMInstallTypeArray[n2];
            IVMInstall[] iVMInstallArray = type.getVMInstalls();
            int n3 = iVMInstallArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IVMInstall install = iVMInstallArray[n4];
                String jdkRootDirectory = install.getInstallLocation().getPath();
                if (this.validateJdkRootDirectory(jdkRootDirectory) == null) {
                    Activator.log(1, NLS.bind((String)Messages.jdkRootDirectoryFoundMsg, (Object)jdkRootDirectory), new Exception());
                    return jdkRootDirectory;
                }
                ++n4;
            }
            ++n2;
        }
        String javaHome = System.getProperty("java.home");
        for (File directory : Tools.getPossibleJdkRootDirectory(javaHome)) {
            String path = directory.getPath();
            if (this.validateJdkRootDirectory(path) != null) continue;
            Activator.log(1, NLS.bind((String)Messages.jdkRootDirectoryFoundMsg, (Object)path), new Exception());
            return path;
        }
        Activator.log(2, Messages.jdkRootDirectoryNotFoundMsg, new Exception());
        return "";
    }

    private static List<File> getPossibleJdkRootDirectory(String javaHome) {
        ArrayList<File> dirs = new ArrayList<File>();
        if (Util.isMac()) {
            int index = javaHome.indexOf("JavaVirtualMachines");
            if (index == -1) {
                return dirs;
            }
            String javaVirtualMachinesPath = javaHome.substring(0, index + "JavaVirtualMachines".length());
            File dir = new File(javaVirtualMachinesPath);
            Tools.collectDirs(dirs, dir, 3);
            return dirs;
        }
        File parentDir = new File(String.valueOf(javaHome) + File.separator + "..");
        if (parentDir.exists()) {
            File[] fileArray = parentDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    dirs.add(file);
                }
                ++n2;
            }
        }
        return dirs;
    }

    private static void collectDirs(List<File> dirs, File dir, int depth) {
        if (depth > 0) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    dirs.add(file);
                    Tools.collectDirs(dirs, file, depth - 1);
                }
                ++n2;
            }
        }
    }

    private boolean validateClassPathAndLibraryPath() {
        try {
            this.invokeGetMonitoredHost("localhost");
        }
        catch (JvmCoreException jvmCoreException) {
            return false;
        }
        return true;
    }

    private void configureClassPathAndLibraryPath() {
        String jdkRootDirectory = Activator.getDefault().getPreferenceStore().getString("org.jboss.tools.jmx.jvmmonitor.tools.jdkRootDirectory");
        if (jdkRootDirectory.isEmpty()) {
            jdkRootDirectory = this.searchJdkRootDirectory();
            Activator.getDefault().getPreferenceStore().setValue("org.jboss.tools.jmx.jvmmonitor.tools.jdkRootDirectory", jdkRootDirectory);
        }
        if (this.validateJdkRootDirectory(jdkRootDirectory) != null) {
            return;
        }
        try {
            Tools.addClassPath(jdkRootDirectory);
        }
        catch (Throwable t) {
            Activator.log(4, Messages.addingClassPathFailedMsg, t);
            return;
        }
        try {
            Tools.addLibraryPath(jdkRootDirectory);
        }
        catch (Throwable t) {
            Activator.log(4, Messages.addingLibraryPathFailedMsg, t);
            return;
        }
    }

    private static String getJreLibraryPath(String jdkRootDirectory) {
        String[] stringArray = LIBRARY_PATHS;
        int n = LIBRARY_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File attachLibraryFile = new File(String.valueOf(jdkRootDirectory) + path + File.separator + System.mapLibraryName("attach"));
            if (attachLibraryFile.exists()) {
                return String.valueOf(jdkRootDirectory) + path;
            }
            ++n2;
        }
        return null;
    }

    private static void addClassPath(String jdkRootDirectory) throws Throwable {
        File file = new File(String.valueOf(jdkRootDirectory) + TOOLS_JAR);
        URL toolsJarUrl = file.toURI().toURL();
        Class<URLClassLoader> clazz = URLClassLoader.class;
        Method method = clazz.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)ClassLoader.getSystemClassLoader(), toolsJarUrl);
        Activator.log(1, NLS.bind((String)Messages.classPathAddedMsg, (Object)file.getPath()), new Exception());
    }

    private static void addLibraryPath(String jdkRootDirectory) throws Throwable {
        String libraryPath = System.getProperty("java.library.path");
        String jreLibraryPath = Tools.getJreLibraryPath(jdkRootDirectory);
        System.setProperty("java.library.path", String.valueOf(libraryPath) + File.pathSeparator + jreLibraryPath);
        Class<ClassLoader> clazz = ClassLoader.class;
        Field field = clazz.getDeclaredField("sys_paths");
        field.setAccessible(true);
        field.set(clazz, null);
    }
}

