/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.viewer;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.aesh.core.console.Console;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.ui.internal.document.ForgeDocument;
import org.jboss.tools.forge.ui.internal.viewer.ForgeTextViewer;

public class F1TextViewer
extends TextViewer
implements ForgeTextViewer {
    private static String START_LINE = new Character('\u0001').toString();
    private static String PREV_CHAR = new Character('\u0002').toString();
    private static String CTRL_C = new Character('\u0003').toString();
    private static String CTRL_D = new Character('\u0004').toString();
    private static String END_LINE = new Character('\u0005').toString();
    private static String NEXT_CHAR = new Character('\u0006').toString();
    private static String DELETE_PREV_CHAR = new Character('\b').toString();
    private static String PREV_HISTORY = new Character('\u0010').toString();
    private static String NEXT_HISTORY = new Character('\u000e').toString();
    private static String DELETE_NEXT_CHAR = new Character('\u007f').toString();
    private static final String FORGE_CONSOLE_FONT = "org.jboss.tools.forge.console.font";
    private ForgeDocument forgeDocument = new ForgeDocument();
    private ForgeRuntime runtime = null;
    private DocumentListener documentListener = new DocumentListener();
    private IPropertyChangeListener fontListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (F1TextViewer.FORGE_CONSOLE_FONT.equals(event.getProperty())) {
                F1TextViewer.this.getTextWidget().setFont(JFaceResources.getFont((String)F1TextViewer.FORGE_CONSOLE_FONT));
            }
        }
    };

    public F1TextViewer(Composite parent, ForgeRuntime runtime) {
        super(parent, 832);
        this.runtime = runtime;
        this.initialize();
    }

    private void initialize() {
        this.initDocument();
        this.initViewer();
        this.initFontListener();
    }

    private void initFontListener() {
        JFaceResources.getFontRegistry().addListener(this.fontListener);
    }

    private void initDocument() {
        this.forgeDocument.addDocumentListener(this.documentListener);
        this.forgeDocument.addCursorListener(this.documentListener);
        this.setDocument((IDocument)this.forgeDocument);
    }

    private void initViewer() {
        this.getTextWidget().setStyleRanges(this.forgeDocument.getStyleRanges());
        this.getTextWidget().setFont(JFaceResources.getFont((String)FORGE_CONSOLE_FONT));
        this.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if ((event.stateMask & 0x40000) == 262144) {
                    if (event.keyCode == 100) {
                        F1TextViewer.this.getRuntime().sendInput(CTRL_D);
                    } else if (event.keyCode == 99) {
                        F1TextViewer.this.getRuntime().sendInput(CTRL_C);
                    }
                }
            }
        });
    }

    protected void handleDispose() {
        this.forgeDocument.removeCursorListener(this.documentListener);
        this.forgeDocument.removeDocumentListener(this.documentListener);
        JFaceResources.getFontRegistry().removeListener(this.fontListener);
        super.handleDispose();
    }

    protected StyledText createTextWidget(Composite parent, int styles) {
        StyledText styledText = new StyledText(parent, styles){

            public void invokeAction(int action) {
                switch (action) {
                    case 0x1000008: {
                        F1TextViewer.this.getRuntime().sendInput(END_LINE);
                        break;
                    }
                    case 0x1000007: {
                        F1TextViewer.this.getRuntime().sendInput(START_LINE);
                        break;
                    }
                    case 0x1000001: {
                        F1TextViewer.this.getRuntime().sendInput(PREV_HISTORY);
                        break;
                    }
                    case 0x1000002: {
                        F1TextViewer.this.getRuntime().sendInput(NEXT_HISTORY);
                        break;
                    }
                    case 0x1000003: {
                        F1TextViewer.this.getRuntime().sendInput(PREV_CHAR);
                        break;
                    }
                    case 0x1000004: {
                        F1TextViewer.this.getRuntime().sendInput(NEXT_CHAR);
                        break;
                    }
                    case 8: {
                        F1TextViewer.this.getRuntime().sendInput(DELETE_PREV_CHAR);
                        break;
                    }
                    case 127: {
                        F1TextViewer.this.getRuntime().sendInput(DELETE_NEXT_CHAR);
                        break;
                    }
                    default: {
                        super.invokeAction(action);
                    }
                }
            }
        };
        styledText.setLeftMargin(Math.max(styledText.getLeftMargin(), 2));
        return styledText;
    }

    protected void handleVerifyEvent(VerifyEvent e) {
        this.getRuntime().sendInput(e.text);
        e.doit = false;
    }

    private ForgeRuntime getRuntime() {
        return this.runtime;
    }

    @Override
    public void stopConsole() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (F1TextViewer.this.forgeDocument != null) {
                    F1TextViewer.this.forgeDocument.reset();
                }
            }
        });
    }

    @Override
    public void startConsole() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                F1TextViewer.this.forgeDocument.connect(F1TextViewer.this.getRuntime());
                F1TextViewer.this.setDocument((IDocument)F1TextViewer.this.forgeDocument);
            }
        });
    }

    @Override
    public Console getConsole() {
        throw new UnsupportedOperationException("getConsole() is not supported on this class");
    }

    private class DocumentListener
    implements IDocumentListener,
    ForgeDocument.CursorListener {
        private DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            StyledText textWidget = F1TextViewer.this.getTextWidget();
            if (textWidget != null && !textWidget.isDisposed()) {
                int lineCount = textWidget.getLineCount();
                textWidget.setTopIndex(lineCount - 1);
                StyleRange styleRange = F1TextViewer.this.forgeDocument.getCurrentStyleRange();
                if (styleRange != null) {
                    textWidget.setStyleRange(styleRange);
                }
            }
        }

        @Override
        public void cursorMoved() {
            StyledText textWidget = F1TextViewer.this.getTextWidget();
            if (textWidget != null && !textWidget.isDisposed()) {
                textWidget.setCaretOffset(F1TextViewer.this.forgeDocument.getCursorOffset());
            }
        }
    }
}

