/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.preferences;

import java.util.ArrayList;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.forge.core.preferences.ForgeCorePreferences;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.core.runtime.ForgeRuntimeFactory;
import org.jboss.tools.forge.core.runtime.ForgeRuntimeType;
import org.jboss.tools.forge.ui.internal.preferences.ForgeInstallationDialog;
import org.jboss.tools.forge.ui.internal.preferences.ForgeInstallationLabelProvider;

public class ForgeInstallationsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final int DEFAULT_COLUMN_WIDTH = 117;
    private CheckboxTableViewer runtimesTableViewer;
    private Button removeButton;
    private Button editButton;
    private ArrayList<ForgeRuntime> runtimes = null;
    private ForgeRuntime defaultRuntime = null;
    private boolean refreshNeeded = false;

    public ForgeInstallationsPreferencePage() {
        super("Installed Forge Runtimes");
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        this.createLayout(parent);
        this.createWrapLabel(parent);
        this.createVerticalSpacer(parent);
        this.createPageBody(parent);
        this.initializeForgeInstallations();
        this.enableButtons();
        return parent;
    }

    private void createPageBody(Composite parent) {
        Composite pageBody = this.createPageBodyControl(parent);
        this.createTitleLabel(pageBody);
        this.createRuntimesArea(pageBody);
        this.createButtonsArea(pageBody);
    }

    private void createButtonsArea(Composite parent) {
        Composite buttons = this.createButtonsComposite(parent);
        this.createAddButton(buttons);
        this.createEditButton(buttons);
        this.createRemoveButton(buttons);
    }

    private void createRemoveButton(Composite parent) {
        this.removeButton = new Button(parent, 8);
        this.removeButton.setText("&Remove");
        this.removeButton.setLayoutData((Object)new GridData(768));
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                Object object;
                ISelection selection = ForgeInstallationsPreferencePage.this.runtimesTableViewer.getSelection();
                if (selection != null && selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) != null && object instanceof ForgeRuntime) {
                    ForgeInstallationsPreferencePage.this.runtimes.remove(object);
                    ForgeInstallationsPreferencePage.this.refreshForgeInstallations();
                }
            }
        });
    }

    private void createAddButton(Composite parent) {
        Button addButton = new Button(parent, 8);
        addButton.setText("&Add...");
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                ForgeInstallationDialog dialog = new ForgeInstallationDialog(null);
                dialog.initialize("Add Forge Runtime", "", "");
                if (dialog.open() != 1) {
                    ForgeInstallationsPreferencePage.this.runtimes.add(ForgeRuntimeFactory.INSTANCE.createForgeRuntime(dialog.getName(), dialog.getLocation()));
                    ForgeInstallationsPreferencePage.this.refreshForgeInstallations();
                    ForgeInstallationsPreferencePage.this.refreshNeeded = true;
                }
            }
        });
    }

    private void createEditButton(Composite parent) {
        this.editButton = new Button(parent, 8);
        this.editButton.setText("&Edit...");
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                Object object;
                ISelection selection = ForgeInstallationsPreferencePage.this.runtimesTableViewer.getSelection();
                if (selection != null && selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) != null && object instanceof ForgeRuntime && ForgeRuntimeType.EXTERNAL.equals((Object)((ForgeRuntime)object).getType())) {
                    ForgeRuntime installation = (ForgeRuntime)object;
                    int index = ForgeInstallationsPreferencePage.this.runtimes.indexOf(installation);
                    ForgeInstallationDialog dialog = new ForgeInstallationDialog(null);
                    dialog.initialize("Edit Forge Runtime", installation.getName(), installation.getLocation());
                    if (dialog.open() != 1) {
                        if (dialog.getName() != null && !dialog.getName().equals(installation.getName())) {
                            ForgeInstallationsPreferencePage.this.refreshNeeded = true;
                        }
                        if (dialog.getLocation() != null && !dialog.getLocation().equals(installation.getLocation())) {
                            ForgeInstallationsPreferencePage.this.refreshNeeded = true;
                        }
                        if (ForgeInstallationsPreferencePage.this.refreshNeeded) {
                            ForgeInstallationsPreferencePage.this.runtimes.remove(index);
                            ForgeInstallationsPreferencePage.this.runtimes.add(index, ForgeRuntimeFactory.INSTANCE.createForgeRuntime(dialog.getName(), dialog.getLocation()));
                            ForgeInstallationsPreferencePage.this.refreshForgeInstallations();
                        }
                    }
                }
            }
        });
    }

    private Composite createButtonsComposite(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        GridData gd = new GridData(2);
        gd.horizontalSpan = 1;
        buttons.setLayoutData((Object)gd);
        return buttons;
    }

    private void createTitleLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Installed Forge Runtimes:");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = false;
        label.setLayoutData((Object)gd);
    }

    private void createRuntimesArea(Composite parent) {
        Table runtimesTable = this.createRuntimesTable(parent);
        this.createNameColumn(runtimesTable);
        this.createLocationColumn(runtimesTable);
        this.createRuntimesTableViewer(runtimesTable);
    }

    private void createRuntimesTableViewer(Table table) {
        this.runtimesTableViewer = new CheckboxTableViewer(table);
        this.runtimesTableViewer.setLabelProvider((IBaseLabelProvider)new ForgeInstallationLabelProvider());
        this.runtimesTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.runtimesTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                ForgeInstallationsPreferencePage.this.enableButtons();
            }
        });
        this.runtimesTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (ForgeInstallationsPreferencePage.this.runtimesTableViewer.getCheckedElements().length == 0) {
                    ForgeInstallationsPreferencePage.this.runtimesTableViewer.setChecked((Object)ForgeInstallationsPreferencePage.this.defaultRuntime, true);
                } else {
                    Object object = event.getElement();
                    if (object != null && object instanceof ForgeRuntime && !object.equals(ForgeInstallationsPreferencePage.this.defaultRuntime)) {
                        ForgeInstallationsPreferencePage.this.defaultRuntime = (ForgeRuntime)object;
                        ForgeInstallationsPreferencePage.this.refreshForgeInstallations();
                        ForgeInstallationsPreferencePage.this.refreshNeeded = true;
                    }
                }
            }
        });
    }

    private void createLocationColumn(Table table) {
        TableColumn column = new TableColumn(table, 0);
        column.setText("Location");
        column.setWidth(117);
    }

    private void createNameColumn(Table table) {
        TableColumn column = new TableColumn(table, 0);
        column.setText("Name");
        column.setWidth(117);
    }

    private Table createRuntimesTable(Composite parent) {
        Table runtimesTable = new Table(parent, 67620);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        gd.widthHint = 350;
        runtimesTable.setLayoutData((Object)gd);
        runtimesTable.setHeaderVisible(true);
        runtimesTable.setLinesVisible(true);
        return runtimesTable;
    }

    private Composite createPageBodyControl(Composite ancestor) {
        Composite result = new Composite(ancestor, 0);
        result.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        result.setLayoutData((Object)gd);
        return result;
    }

    private void createLayout(Composite ancestor) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ancestor.setLayout((Layout)layout);
    }

    private Label createWrapLabel(Composite parent) {
        Label l = new Label(parent, 64);
        l.setFont(parent.getFont());
        l.setText("Add, remove or edit Forge runtimes. By default, the checked Forge runtime is used when launching Forge.");
        GridData gd = new GridData(768);
        gd.widthHint = 250;
        l.setLayoutData((Object)gd);
        return l;
    }

    private void createVerticalSpacer(Composite parent) {
        Label lbl = new Label(parent, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        lbl.setLayoutData((Object)gd);
    }

    private void initializeForgeInstallations() {
        this.runtimes = new ArrayList();
        ForgeRuntime[] forgeRuntimeArray = ForgeCorePreferences.INSTANCE.getRuntimes();
        int n = forgeRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ForgeRuntime runtime = forgeRuntimeArray[n2];
            ForgeRuntime copy = null;
            if (ForgeRuntimeType.EMBEDDED.equals((Object)runtime.getType())) {
                copy = runtime;
            } else if (ForgeRuntimeType.EXTERNAL.equals((Object)runtime.getType())) {
                copy = ForgeRuntimeFactory.INSTANCE.createForgeRuntime(runtime.getName(), runtime.getLocation());
            }
            if (runtime == ForgeCorePreferences.INSTANCE.getDefaultRuntime()) {
                this.defaultRuntime = copy;
            }
            this.runtimes.add(copy);
            ++n2;
        }
        this.refreshForgeInstallations();
    }

    private void refreshForgeInstallations() {
        this.runtimesTableViewer.setInput((Object)this.runtimes.toArray(new ForgeRuntime[this.runtimes.size()]));
        this.runtimesTableViewer.setCheckedElements(new Object[]{this.defaultRuntime});
        this.runtimesTableViewer.refresh();
    }

    private void enableButtons() {
        Object selectedObject = null;
        IStructuredSelection selection = (IStructuredSelection)this.runtimesTableViewer.getSelection();
        if (selection != null) {
            selectedObject = selection.getFirstElement();
        }
        if (selectedObject == null || selectedObject instanceof ForgeRuntime && ForgeRuntimeType.EMBEDDED.equals((Object)((ForgeRuntime)selectedObject).getType())) {
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(selectedObject != this.runtimesTableViewer.getCheckedElements()[0]);
            this.editButton.setEnabled(true);
        }
    }

    public boolean performOk() {
        if (this.refreshNeeded) {
            boolean[] canceled = new boolean[1];
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    ForgeRuntime[] runtimes = (ForgeRuntime[])ForgeInstallationsPreferencePage.this.runtimesTableViewer.getInput();
                    ForgeRuntime defaultRuntime = (ForgeRuntime)ForgeInstallationsPreferencePage.this.runtimesTableViewer.getCheckedElements()[0];
                    ForgeCorePreferences.INSTANCE.setRuntimes(runtimes, defaultRuntime);
                    ForgeInstallationsPreferencePage.this.refreshNeeded = false;
                }
            });
            if (canceled[0]) {
                return false;
            }
        }
        return super.performOk();
    }
}

