/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ForgeInstallationDialog
extends Dialog {
    String title;
    Text nameText;
    Text locationText;
    Button locationButton;
    String name;
    String location;

    public ForgeInstallationDialog(Shell parentShell) {
        super(parentShell);
    }

    public void initialize(String t, String n, String l) {
        this.title = t;
        this.name = n;
        this.location = l;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.getShell().setText(this.title);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        area.setLayout((Layout)gridLayout);
        this.createMessageLabel(area);
        this.createNameLabel(area);
        this.createNameText(area);
        this.createFillLabel(area);
        this.createLocationLabel(area);
        this.createLocationText(area);
        this.createLocationButton(area);
        this.createSeparator(area);
        this.getShell().setText(this.title);
        return area;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.updateOkButton();
        return result;
    }

    private void createSeparator(Composite area) {
        Label separator = new Label(area, 258);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.verticalIndent = 15;
        separator.setLayoutData((Object)gridData);
    }

    private void createLocationText(Composite area) {
        this.locationText = new Text(area, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        this.locationText.setLayoutData((Object)gridData);
        this.locationText.setText(this.location == null ? "" : this.location);
        this.locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ForgeInstallationDialog.this.location = ForgeInstallationDialog.this.locationText.getText();
                ForgeInstallationDialog.this.updateOkButton();
            }
        });
    }

    private void createLocationButton(Composite area) {
        this.locationButton = new Button(area, 8);
        this.locationButton.setText("Browse...");
        this.locationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ForgeInstallationDialog.this.searchLocation();
            }
        });
    }

    private void searchLocation() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        String result = dialog.open();
        if (result != null) {
            this.locationText.setText(result);
        }
    }

    private void createLocationLabel(Composite area) {
        Label label = new Label(area, 0);
        GridData gridData = new GridData(32);
        label.setLayoutData((Object)gridData);
        label.setText("Location :");
    }

    private void createFillLabel(Composite area) {
        new Label(area, 0);
    }

    private void createNameText(Composite area) {
        this.nameText = new Text(area, 2048);
        GridData gridData = new GridData();
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        this.nameText.setLayoutData((Object)gridData);
        this.nameText.setText(this.name == null ? "" : this.name);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ForgeInstallationDialog.this.name = ForgeInstallationDialog.this.nameText.getText();
                ForgeInstallationDialog.this.updateOkButton();
            }
        });
    }

    private void updateOkButton() {
        this.getButton(0).setEnabled(this.isValid());
    }

    private boolean isValid() {
        if (this.name == null || this.location == null) {
            return false;
        }
        return !"".equals(this.name) && !"".equals(this.location);
    }

    private void createNameLabel(Composite area) {
        Label label = new Label(area, 0);
        GridData gridData = new GridData(32);
        label.setLayoutData((Object)gridData);
        label.setText("Name :");
    }

    private void createMessageLabel(Composite area) {
        Label label = new Label(area, 0);
        GridData gridData = new GridData(800);
        gridData.horizontalSpan = 3;
        gridData.verticalIndent = 10;
        label.setLayoutData((Object)gridData);
        label.setText("Enter a name and choose the location : ");
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }
}

