/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.part;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.core.runtime.ForgeRuntimeState;

public class SelectionSynchronizer
implements ISelectionListener {
    private ForgeRuntime runtime;
    private IEditorPart selectedPart;
    private IPartListener partListener = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            if (!(part instanceof IEditorPart) || part == SelectionSynchronizer.this.selectedPart) {
                return;
            }
            SelectionSynchronizer.this.selectedPart = (IEditorPart)part;
            IEditorInput editorInput = SelectionSynchronizer.this.selectedPart.getEditorInput();
            if (!(editorInput instanceof IFileEditorInput)) {
                return;
            }
            IFile file = ((IFileEditorInput)editorInput).getFile();
            if (file == null) {
                return;
            }
            String path = file.getLocation().toOSString();
            if (path.indexOf(32) != -1) {
                path = String.valueOf('\"') + path + '\"';
            }
            if (ForgeRuntimeState.RUNNING.equals((Object)SelectionSynchronizer.this.getRuntime().getState())) {
                SelectionSynchronizer.this.getRuntime().sendInput("pick-up " + path + "\n");
            }
        }
    };

    public SelectionSynchronizer(ForgeRuntime runtime) {
        this.runtime = runtime;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.getPartService().addPartListener(this.partListener);
        } else {
            this.getPartService().removePartListener(this.partListener);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(part instanceof IEditorPart) || part == this.selectedPart) {
            return;
        }
        this.selectedPart = (IEditorPart)part;
        if (this.getPartService().getActivePart() == part) {
            return;
        }
        IEditorInput editorInput = this.selectedPart.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            return;
        }
        IFile file = ((IFileEditorInput)editorInput).getFile();
        if (file == null) {
            return;
        }
        String path = file.getLocation().toOSString();
        if (path.indexOf(32) != -1) {
            path = String.valueOf('\"') + path + '\"';
        }
        if (ForgeRuntimeState.RUNNING.equals((Object)this.getRuntime().getState())) {
            this.getRuntime().sendInput("pick-up " + path + "\n");
        }
    }

    private IWorkbenchWindow getWorkbenchWidow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    private IPartService getPartService() {
        return this.getWorkbenchWidow().getPartService();
    }

    private ForgeRuntime getRuntime() {
        return this.runtime;
    }
}

