/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.controller.WizardCommandController;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.output.UIMessage;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;
import org.jboss.tools.forge.ui.internal.ext.control.ControlBuilder;
import org.jboss.tools.forge.ui.internal.ext.control.ControlBuilderRegistry;
import org.jboss.tools.forge.ui.internal.ext.wizards.ForgeWizard;
import org.jboss.tools.forge.ui.notifications.NotificationType;

public class ForgeWizardPage
extends WizardPage
implements Listener {
    private CommandController controller;
    private boolean changed;
    private List<ComponentControlEntry> componentControlEntries = new ArrayList<ComponentControlEntry>();

    public ForgeWizardPage(ForgeWizard wizard, CommandController controller) {
        super(controller.getMetadata().getName());
        this.setWizard((IWizard)wizard);
        this.setPageComplete(false);
        this.controller = controller;
        UICommandMetadata id = controller.getMetadata();
        this.setTitle(id.getName());
        this.setDescription(id.getDescription());
        this.setImageDescriptor(ForgeUIPlugin.getForgeLogo());
    }

    public CommandController getController() {
        return this.controller;
    }

    public ForgeWizard getWizard() {
        return (ForgeWizard)super.getWizard();
    }

    public void createControl(Composite parent) {
        try {
            this.controller.initialize();
        }
        catch (Exception e) {
            ForgeUIPlugin.log(e);
            ForgeUIPlugin.displayMessage("Error has occurred!", "See Error Log for details", NotificationType.ERROR);
            return;
        }
        Map inputs = this.controller.getInputs();
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        for (Map.Entry entry : inputs.entrySet()) {
            Control[] modifiableControls;
            String inputName = (String)entry.getKey();
            InputComponent input = (InputComponent)entry.getValue();
            ControlBuilder<Control> controlBuilder = ControlBuilderRegistry.getBuilderFor(input);
            Object control = controlBuilder.build(this, input, inputName, container);
            if (input.isRequired()) {
                this.decorateRequiredField((InputComponent<?, ?>)input, (Control)control);
            }
            Control[] controlArray = modifiableControls = controlBuilder.getModifiableControlsFor((Control)control);
            int n = modifiableControls.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.registerListeners(child);
                ++n2;
            }
            this.componentControlEntries.add(new ComponentControlEntry((InputComponent<?, ?>)input, controlBuilder, (Control)control));
        }
        this.initValidatePage();
        this.setControl((Control)container);
    }

    private void clearMessages() {
        this.setErrorMessage(null);
        this.setMessage(null);
    }

    private void registerListeners(Control control) {
        control.addListener(24, (Listener)this);
        control.addListener(14, (Listener)this);
        control.addListener(13, (Listener)this);
        ChangeListener cl = new ChangeListener();
        control.addListener(24, (Listener)cl);
        control.addListener(13, (Listener)cl);
    }

    private void decorateRequiredField(InputComponent<?, ?> input, Control control) {
        FieldDecoration completerIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED");
        ControlDecoration dec = new ControlDecoration(control, 0x1004000);
        dec.setImage(completerIndicator.getImage());
        dec.setDescriptionText(completerIndicator.getDescription());
    }

    public void handleEvent(final Event event) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ForgeWizardPage.this.isCurrentPage()) {
                    ForgeWizardPage.this.setPageComplete(ForgeWizardPage.this.validatePage());
                    ForgeWizardPage.this.getContainer().updateButtons();
                }
                event.doit = true;
            }
        });
    }

    private void updatePageState() {
        if (this.componentControlEntries != null) {
            for (ComponentControlEntry entry : this.componentControlEntries) {
                InputComponent<?, ?> component = entry.getComponent();
                ControlBuilder<Control> controlBuilder = entry.getControlBuilder();
                Control control = entry.getControl();
                controlBuilder.updateState(control, component);
            }
        }
    }

    private void initValidatePage() {
        this.updatePageState();
        for (ComponentControlEntry entry : this.componentControlEntries) {
            if (InputComponents.validateRequired(entry.getComponent()) == null) continue;
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(this.validatePage());
    }

    private boolean validatePage() {
        this.clearMessages();
        this.updatePageState();
        for (UIMessage message : this.controller.validate()) {
            switch (message.getSeverity()) {
                case ERROR: {
                    this.setErrorMessage(message.getDescription());
                    return false;
                }
                case WARN: {
                    this.setWarningMessage(message.getDescription());
                    return true;
                }
                case INFO: {
                    this.setInfoMessage(message.getDescription());
                    return true;
                }
            }
        }
        return true;
    }

    public void setInfoMessage(String warningMessage) {
        this.setMessage(warningMessage, 1);
        if (this.isCurrentPage()) {
            this.getContainer().updateMessage();
        }
    }

    public void setWarningMessage(String warningMessage) {
        this.setMessage(warningMessage, 2);
        if (this.isCurrentPage()) {
            this.getContainer().updateMessage();
        }
    }

    public void dispose() {
        super.dispose();
        this.componentControlEntries.clear();
    }

    public boolean canFlipToNextPage() {
        boolean result = this.isWizard() ? ((WizardCommandController)this.controller).canMoveToNextStep() : false;
        return this.isPageComplete() && result;
    }

    private boolean isWizard() {
        return this.controller instanceof WizardCommandController;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean isChanged() {
        return this.changed;
    }

    private class ChangeListener
    implements Listener {
        private ChangeListener() {
        }

        public void handleEvent(Event evt) {
            if (ForgeWizardPage.this.isCurrentPage()) {
                ForgeWizardPage.this.setChanged(true);
            }
        }
    }

    class ComponentControlEntry {
        private InputComponent<?, ?> component;
        private ControlBuilder<Control> controlBuilder;
        private Control control;

        public ComponentControlEntry(InputComponent<?, ?> component, ControlBuilder<Control> controlBuilder, Control control) {
            this.component = component;
            this.controlBuilder = controlBuilder;
            this.control = control;
        }

        public ControlBuilder<Control> getControlBuilder() {
            return this.controlBuilder;
        }

        public InputComponent<?, ?> getComponent() {
            return this.component;
        }

        public Control getControl() {
            return this.control;
        }
    }
}

