/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.wizards;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.ui.view.IRSEViewPart;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.tools.forge.core.util.ProjectTools;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;
import org.jboss.tools.forge.ui.internal.ext.context.UIContextImpl;
import org.jboss.tools.forge.ui.internal.ext.importer.ImportEclipseProjectListener;

public class ForgeWizardHelper {
    private IFile pomFile = null;
    private long pomFileModificationStamp = -1L;

    public void onFinish(final UIContextImpl context) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ForgeWizardHelper.this.importNewProjects();
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ForgeWizardHelper.this.refreshInitialSelection(context);
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ForgeWizardHelper.this.updateProjectConfiguration();
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ForgeWizardHelper.this.showFinalSelection(context);
            }
        });
    }

    public void onCancel(UIContextImpl context) {
        this.pomFile = null;
        this.pomFileModificationStamp = -1L;
    }

    public void onCreate(UIContextImpl context) {
        IResource resource;
        UISelection selection = context.getInitialSelection();
        if (selection != null && (resource = selection.getResource()) != null) {
            this.pomFile = this.determinePomFile(selection.getResource());
            if (this.pomFile != null) {
                this.pomFileModificationStamp = this.pomFile.getModificationStamp();
            }
        }
    }

    private void importNewProjects() {
        if (ImportEclipseProjectListener.INSTANCE.projectsAvailableForImport()) {
            ImportEclipseProjectListener.INSTANCE.doImport();
        }
    }

    private void refreshInitialSelection(UIContextImpl context) {
        try {
            IResource resource;
            UISelection selection = context.getInitialSelection();
            if (selection != null && (resource = selection.getResource()) != null) {
                if (resource.isPhantom()) {
                    resource = resource.getParent();
                }
                if (resource != null) {
                    resource.refreshLocal(2, null);
                }
            }
        }
        catch (CoreException e) {
            ForgeUIPlugin.log(e);
        }
    }

    private void updateProjectConfiguration() {
        if (this.pomFileModificationStamp != -1L && this.pomFile != null && this.pomFile.getModificationStamp() > this.pomFileModificationStamp) {
            ProjectTools.updateProjectConfiguration((IProject)this.pomFile.getProject());
        }
        this.pomFile = null;
        this.pomFileModificationStamp = -1L;
    }

    private void showFinalSelection(UIContextImpl context) {
        Object object = context.getSelection();
        if (object != null) {
            this.selectResourceFor(object);
        }
    }

    private void selectResourceFor(Object object) {
        try {
            Object resource;
            Method method = object.getClass().getMethod("getUnderlyingResourceObject", new Class[0]);
            if (method != null && (resource = method.invoke(object, new Object[0])) != null && resource instanceof File) {
                this.selectFile((File)resource);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            ForgeUIPlugin.log(e);
        }
    }

    private void selectFile(File file) {
        try {
            Path path = new Path(file.getCanonicalPath());
            IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)path);
            IFileInfo fileInfo = fileStore.fetchInfo();
            if (!fileInfo.exists()) {
                return;
            }
            IContainer resource = null;
            if (fileInfo.isDirectory()) {
                resource = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)path);
            } else {
                resource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                this.openFileInEditor(fileStore);
            }
            if (resource != null) {
                this.expandWorkspaceResource((IResource)resource);
            } else {
                this.expandSystemDirectory(fileStore);
            }
        }
        catch (IOException e) {
            ForgeUIPlugin.log(e);
        }
    }

    private void expandWorkspaceResource(IResource container) {
        IWorkbenchPage workbenchPage = this.getActiveWorkbenchPage();
        if (workbenchPage != null) {
            IViewPart packageExplorer;
            IViewPart projectExplorer = workbenchPage.findView("org.eclipse.ui.navigator.ProjectExplorer");
            if (projectExplorer != null && projectExplorer instanceof CommonNavigator) {
                this.expandInProjectExplorer((CommonNavigator)projectExplorer, container);
            }
            if ((packageExplorer = workbenchPage.findView("org.eclipse.jdt.ui.PackageExplorer")) != null) {
                this.expandInPackageExplorer(packageExplorer, container);
            }
        }
    }

    private void expandSystemDirectory(IFileStore fileStore) {
        IWorkbenchPage workbenchPage = this.getActiveWorkbenchPage();
        IViewPart remoteSystemView = workbenchPage.findView("org.eclipse.rse.ui.view.systemView");
        if (remoteSystemView != null) {
            this.expandInRemoteSystemView(remoteSystemView, fileStore);
        }
    }

    private void expandInRemoteSystemView(IViewPart remoteSystemView, IFileStore fileStore) {
        Viewer viewer = this.getViewer(remoteSystemView);
        Object input = viewer.getInput();
        ArrayList<String> names = this.createSegmentNames(fileStore);
        ArrayList<Object> treeSegments = new ArrayList<Object>();
        block0: for (String name : names) {
            if (input != null && input instanceof IAdaptable) {
                ISystemViewElementAdapter adapter = SystemAdapterHelpers.getViewAdapter((Object)input);
                if (adapter == null) continue;
                Object[] objectArray = adapter.getChildren((IAdaptable)input, null);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof IAdaptable && (adapter = SystemAdapterHelpers.getViewAdapter((Object)object)) != null && name.equals(adapter.getText(object))) {
                        input = object;
                        treeSegments.add(input);
                        continue block0;
                    }
                    ++n2;
                }
                continue;
            }
            treeSegments.clear();
            break;
        }
        TreePath treePath = new TreePath(treeSegments.toArray());
        viewer.setSelection((ISelection)new StructuredSelection((Object)treePath));
        if (viewer instanceof TreeViewer) {
            ((TreeViewer)viewer).expandToLevel((Object)treePath, 1);
        }
    }

    private Viewer getViewer(IViewPart remoteSystemView) {
        if (remoteSystemView instanceof IRSEViewPart) {
            return ((IRSEViewPart)remoteSystemView).getRSEViewer();
        }
        return null;
    }

    private ArrayList<String> createSegmentNames(IFileStore fileStore) {
        ArrayList<String> result = new ArrayList<String>();
        while (fileStore.getParent() != null) {
            result.add(0, fileStore.getName());
            fileStore = fileStore.getParent();
        }
        result.add(0, "/");
        result.add(0, "Root");
        result.add(0, "Local Files");
        result.add(0, "Local");
        return result;
    }

    private IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbenchPage result = null;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null) {
            result = workbenchWindow.getActivePage();
        }
        return result;
    }

    private void expandInProjectExplorer(CommonNavigator projectExplorer, IResource container) {
        projectExplorer.selectReveal((ISelection)new StructuredSelection((Object)container));
        CommonViewer treeViewer = projectExplorer.getCommonViewer();
        treeViewer.expandToLevel((Object)container, 1);
    }

    private void expandInPackageExplorer(IViewPart packageExplorer, IResource container) {
        Object treeViewer;
        if (packageExplorer instanceof ISetSelectionTarget) {
            ((ISetSelectionTarget)packageExplorer).selectReveal((ISelection)new StructuredSelection((Object)container));
        }
        if ((treeViewer = packageExplorer.getAdapter(ISelectionProvider.class)) != null && treeViewer instanceof TreeViewer) {
            ((TreeViewer)treeViewer).expandToLevel((Object)JavaCore.create((IResource)container), 1);
        }
    }

    private void openFileInEditor(IFileStore fileStore) {
        try {
            IWorkbenchPage workbenchPage = this.getActiveWorkbenchPage();
            if (workbenchPage != null) {
                IDE.openEditorOnFileStore((IWorkbenchPage)workbenchPage, (IFileStore)fileStore);
            }
        }
        catch (PartInitException e) {
            ForgeUIPlugin.log(e);
        }
    }

    private IFile determinePomFile(IResource resource) {
        IFile result = null;
        IProject project = resource.getProject();
        if (project != null) {
            result = project.getFile((IPath)new Path("pom.xml"));
        }
        return result;
    }
}

