/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.control.many;

import java.util.LinkedHashSet;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.SelectComponent;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.tools.forge.core.furnace.FurnaceService;
import org.jboss.tools.forge.ui.internal.ext.control.ControlBuilder;
import org.jboss.tools.forge.ui.internal.ext.wizards.ForgeWizardPage;

public class CheckboxTableControlBuilder
extends ControlBuilder<Table> {
    @Override
    public Table build(final ForgeWizardPage page, InputComponent<?, ?> input, final String inputName, Composite container) {
        Group group = new Group(container, 32);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 3;
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)layoutData);
        group.setText(InputComponents.getLabelFor(input, (boolean)false));
        Composite groupPanel = new Composite((Composite)group, 0);
        groupPanel.setLayoutData((Object)new GridData(768));
        groupPanel.setLayout((Layout)new GridLayout(2, false));
        final Table table = new Table(groupPanel, 2848);
        GridData tableLayoutData = new GridData(4, 4, true, true);
        tableLayoutData.widthHint = 300;
        tableLayoutData.heightHint = 300;
        table.setLayoutData((Object)tableLayoutData);
        table.setToolTipText(input.getDescription());
        UISelectMany selectMany = (UISelectMany)input;
        ConverterFactory converterFactory = FurnaceService.INSTANCE.getConverterFactory();
        final LinkedHashSet data = new LinkedHashSet();
        Iterable valueChoices = selectMany.getValueChoices();
        Iterable defaultValues = selectMany.getValue();
        if (defaultValues != null) {
            for (Object object : defaultValues) {
                data.add(object);
            }
        }
        if (valueChoices != null) {
            Converter itemLabelConverter = InputComponents.getItemLabelConverter((ConverterFactory)converterFactory, (SelectComponent)selectMany);
            for (Object next : valueChoices) {
                TableItem item = new TableItem(table, 0);
                item.setData(Proxies.unwrap(next));
                item.setText((String)itemLabelConverter.convert(next));
                item.setChecked(data.contains(next));
            }
        }
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof TableItem && e.detail == 32) {
                    TableItem source = (TableItem)e.item;
                    if (source.getChecked()) {
                        data.add(source.getData());
                    } else {
                        data.remove(source.getData());
                    }
                    CommandController controller = page.getController();
                    controller.setValueFor(inputName, (Object)data);
                }
            }
        });
        Composite buttons = new Composite(groupPanel, 0);
        buttons.setLayout((Layout)new GridLayout(1, true));
        buttons.setLayoutData((Object)new GridData(66));
        Button selectAllButton = new Button(buttons, 8);
        selectAllButton.setLayoutData((Object)new GridData(768));
        selectAllButton.setText("Select All");
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (!item.getChecked()) {
                        item.setChecked(true);
                        CheckboxTableControlBuilder.this.notifySelectionChange(table, item);
                    }
                    ++n2;
                }
            }
        });
        Button selectNoneButton = new Button(buttons, 8);
        selectNoneButton.setLayoutData((Object)new GridData(768));
        selectNoneButton.setText("Select None");
        selectNoneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getChecked()) {
                        item.setChecked(false);
                        CheckboxTableControlBuilder.this.notifySelectionChange(table, item);
                    }
                    ++n2;
                }
            }
        });
        return table;
    }

    @Override
    public Control[] getModifiableControlsFor(Table control) {
        return new Control[]{control};
    }

    private void notifySelectionChange(Table table, TableItem item) {
        Event event = new Event();
        event.item = item;
        event.detail = 32;
        table.notifyListeners(13, event);
    }

    @Override
    protected Class<?> getProducedType() {
        return Object.class;
    }

    @Override
    protected String getSupportedInputType() {
        return "org.jboss.forge.inputType.CHECKBOX";
    }

    @Override
    protected Class<?>[] getSupportedInputComponentTypes() {
        return new Class[]{UISelectMany.class};
    }
}

