/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.console;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.forge.core.preferences.ForgeCorePreferences;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.ui.internal.console.AbstractForgeConsole;
import org.jboss.tools.forge.ui.internal.console.F1Console;
import org.jboss.tools.forge.ui.internal.console.F2Console;
import org.jboss.tools.forge.ui.internal.console.ForgeConsole;

public class ForgeConsoleManager {
    public static final ForgeConsoleManager INSTANCE = new ForgeConsoleManager();
    private List<ForgeConsole> consoles = new ArrayList<ForgeConsole>();

    private ForgeConsoleManager() {
        this.createConsoles();
    }

    private void createConsoles() {
        this.consoles = new ArrayList<ForgeConsole>();
        ForgeRuntime[] forgeRuntimeArray = ForgeCorePreferences.INSTANCE.getRuntimes();
        int n = forgeRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ForgeRuntime runtime = forgeRuntimeArray[n2];
            AbstractForgeConsole console = null;
            console = runtime.getVersion().startsWith("1.") ? new F1Console(runtime) : new F2Console(runtime);
            int index = this.calculateIndex(console);
            this.consoles.add(index, console);
            ++n2;
        }
    }

    public ForgeConsole[] getConsoles() {
        return this.consoles.toArray(new ForgeConsole[this.consoles.size()]);
    }

    public ForgeConsole getDefaultConsole() {
        return this.getConsole(ForgeCorePreferences.INSTANCE.getDefaultRuntime());
    }

    private ForgeConsole getConsole(ForgeRuntime runtime) {
        ForgeConsole[] forgeConsoleArray = this.getConsoles();
        int n = forgeConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ForgeConsole console = forgeConsoleArray[n2];
            if (console.getRuntime() == runtime) {
                return console;
            }
            ++n2;
        }
        return null;
    }

    private int calculateIndex(ForgeConsole forgeConsole) {
        ForgeRuntime runtime = forgeConsole.getRuntime();
        String newVersion = runtime.getVersion();
        int i = 0;
        while (i < this.consoles.size()) {
            String version = this.consoles.get(i).getRuntime().getVersion();
            if (this.isNewer(newVersion, version)) {
                return i;
            }
            ++i;
        }
        return this.consoles.size();
    }

    private boolean isNewer(String first, String second) {
        String[] firstValues = first.split("\\.|-");
        String[] secondValues = second.split("\\.|-");
        int i = 0;
        while (i < 2) {
            if (Integer.valueOf(firstValues[i]) < Integer.valueOf(secondValues[i])) {
                return false;
            }
            ++i;
        }
        return "Final".equals(firstValues[3]);
    }
}

