/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.commands;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;
import org.jboss.tools.forge.ui.internal.commands.ForgeCommandPostProcessor;
import org.jboss.tools.forge.ui.internal.commands.ForgeCommandPostProcessorHelper;

public class FieldPostProcessor
implements ForgeCommandPostProcessor {
    @Override
    public void postProcess(Map<String, String> commandDetails) {
        block10: {
            try {
                String crn = commandDetails.get("crn");
                String par = commandDetails.get("par");
                IFile file = ForgeCommandPostProcessorHelper.getFile(crn);
                if (file == null) {
                    return;
                }
                IJavaElement javaElement = JavaCore.create((IFile)file);
                if (javaElement == null || javaElement.getElementType() != 5) break block10;
                try {
                    IViewPart packageExplorer;
                    IViewPart projectExplorer;
                    IType type = ((ICompilationUnit)javaElement).getTypes()[0];
                    IField field = this.getFieldToPostProcess(par, type);
                    IWorkbenchPage workbenchPage = ForgeCommandPostProcessorHelper.getActiveWorkbenchPage();
                    if (field != null) {
                        ISourceRange sourceRange = field.getSourceRange();
                        IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)workbenchPage, (IFile)file);
                        if (sourceRange != null && editorPart != null && editorPart instanceof ITextEditor) {
                            ((ITextEditor)editorPart).selectAndReveal(sourceRange.getOffset(), sourceRange.getLength());
                        }
                    }
                    if ((projectExplorer = workbenchPage.findView("org.eclipse.ui.navigator.ProjectExplorer")) != null && projectExplorer instanceof ISetSelectionTarget) {
                        ((ISetSelectionTarget)projectExplorer).selectReveal((ISelection)new StructuredSelection((Object)file));
                    }
                    if ((packageExplorer = workbenchPage.findView("org.eclipse.jdt.ui.PackageExplorer")) == null && projectExplorer == null) {
                        packageExplorer = workbenchPage.showView("org.eclipse.jdt.ui.PackageExplorer");
                    }
                    if (packageExplorer != null && packageExplorer instanceof ISetSelectionTarget) {
                        ((ISetSelectionTarget)packageExplorer).selectReveal((ISelection)new StructuredSelection((Object)file));
                    }
                }
                catch (JavaModelException e) {
                    ForgeUIPlugin.log(e);
                }
            }
            catch (PartInitException e) {
                ForgeUIPlugin.log(e);
            }
        }
    }

    private IField getFieldToPostProcess(String par, IType type) {
        String[] candidates;
        String[] stringArray = candidates = par.trim().split(" ");
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            String candidate = stringArray[n2];
            IField field = type.getField(candidate);
            if (field != null && field.exists()) {
                return field;
            }
            ++n2;
        }
        return null;
    }
}

