/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.cli;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.ui.view.IRSEViewPart;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectListener;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.ui.command.CommandExecutionListener;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.tools.forge.core.util.ProjectTools;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;
import org.jboss.tools.forge.ui.internal.util.IDEUtils;

public class CommandLineListener
implements ProjectListener,
CommandExecutionListener {
    private List<Project> projects = new ArrayList<Project>();
    private IFile pomFile = null;
    private long pomFileModificationStamp = -1L;

    public void postCommandExecuted(UICommand command, final UIExecutionContext uiExecutionContext, Result result) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Object object2;
                if (!CommandLineListener.this.projects.isEmpty()) {
                    CommandLineListener.this.importProjects();
                    CommandLineListener.this.projects.clear();
                }
                UISelection selection = uiExecutionContext.getUIContext().getInitialSelection();
                for (Object object2 : selection) {
                    if (!(object2 instanceof Resource)) continue;
                    CommandLineListener.this.refresh((Resource)object2);
                }
                if (CommandLineListener.this.pomFileModificationStamp != -1L && CommandLineListener.this.pomFile != null && CommandLineListener.this.pomFile.getModificationStamp() > CommandLineListener.this.pomFileModificationStamp) {
                    ProjectTools.updateProjectConfiguration((IProject)CommandLineListener.this.pomFile.getProject());
                }
                if ((object2 = uiExecutionContext.getUIContext().getSelection()) != null && object2 instanceof Resource) {
                    CommandLineListener.this.selectResource((Resource)object2);
                }
                CommandLineListener.this.activateForgeView();
                CommandLineListener.this.pomFile = null;
                CommandLineListener.this.pomFileModificationStamp = -1L;
            }
        });
    }

    private void activateForgeView() {
        try {
            IWorkbenchPage activePage = this.getActivePage();
            if (activePage != null) {
                IViewPart part = activePage.showView("org.jboss.tools.forge.ui.console");
                activePage.activate((IWorkbenchPart)part);
            }
        }
        catch (PartInitException e) {
            ForgeUIPlugin.log(e);
        }
    }

    private IWorkbenchPage getActivePage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    private void refresh(Resource<?> resource) {
        Object object = resource.getUnderlyingResourceObject();
        if (object instanceof File) {
            this.refreshResource((File)object);
        }
    }

    private void selectResource(Resource<?> resource) {
        Object object = resource.getUnderlyingResourceObject();
        if (object instanceof File) {
            this.selectFile((File)object);
        }
    }

    public void projectCreated(Project project) {
        this.projects.add(project);
    }

    private void importProjects() {
        for (Project project : this.projects) {
            Resource projectRoot = project.getRoot();
            String baseDirPath = projectRoot.getParent().getFullyQualifiedName();
            String projectName = ((MetadataFacet)project.getFacet(MetadataFacet.class)).getProjectName();
            ProjectTools.importProject((String)baseDirPath, (String)projectName);
        }
    }

    private void selectFile(File file) {
        try {
            Path path = new Path(file.getCanonicalPath());
            IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)path);
            IFileInfo fileInfo = fileStore.fetchInfo();
            if (!fileInfo.exists()) {
                return;
            }
            IContainer resource = null;
            if (fileInfo.isDirectory()) {
                resource = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)path);
            } else {
                resource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                IDEUtils.openFileInEditor(fileStore, false);
            }
            if (resource != null) {
                this.expandWorkspaceResource((IResource)resource);
            } else {
                this.expandSystemDirectory(fileStore);
            }
        }
        catch (IOException e) {
            ForgeUIPlugin.log(e);
        }
    }

    private void expandWorkspaceResource(IResource container) {
        IWorkbenchPage workbenchPage = this.getActiveWorkbenchPage();
        if (workbenchPage != null) {
            IViewPart packageExplorer;
            IViewPart projectExplorer = workbenchPage.findView("org.eclipse.ui.navigator.ProjectExplorer");
            if (projectExplorer != null && projectExplorer instanceof CommonNavigator) {
                this.expandInProjectExplorer((CommonNavigator)projectExplorer, container);
            }
            if ((packageExplorer = workbenchPage.findView("org.eclipse.jdt.ui.PackageExplorer")) != null) {
                this.expandInPackageExplorer(packageExplorer, container);
            }
        }
    }

    private IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbenchPage result = null;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null) {
            result = workbenchWindow.getActivePage();
        }
        return result;
    }

    private void expandInProjectExplorer(CommonNavigator projectExplorer, IResource container) {
        projectExplorer.selectReveal((ISelection)new StructuredSelection((Object)container));
        CommonViewer treeViewer = projectExplorer.getCommonViewer();
        treeViewer.expandToLevel((Object)container, 1);
    }

    private void expandInPackageExplorer(IViewPart packageExplorer, IResource container) {
        Object treeViewer;
        if (packageExplorer instanceof ISetSelectionTarget) {
            ((ISetSelectionTarget)packageExplorer).selectReveal((ISelection)new StructuredSelection((Object)container));
        }
        if ((treeViewer = packageExplorer.getAdapter(ISelectionProvider.class)) != null && treeViewer instanceof TreeViewer) {
            ((TreeViewer)treeViewer).expandToLevel((Object)JavaCore.create((IResource)container), 1);
        }
    }

    private void expandSystemDirectory(IFileStore fileStore) {
        IWorkbenchPage workbenchPage = this.getActiveWorkbenchPage();
        IViewPart remoteSystemView = workbenchPage.findView("org.eclipse.rse.ui.view.systemView");
        if (remoteSystemView != null) {
            this.expandInRemoteSystemView(remoteSystemView, fileStore);
        }
    }

    private void expandInRemoteSystemView(IViewPart remoteSystemView, IFileStore fileStore) {
        Viewer viewer = this.getViewer(remoteSystemView);
        Object input = viewer.getInput();
        ArrayList<String> names = this.createSegmentNames(fileStore);
        ArrayList<Object> treeSegments = new ArrayList<Object>();
        block0: for (String name : names) {
            if (input != null && input instanceof IAdaptable) {
                ISystemViewElementAdapter adapter = SystemAdapterHelpers.getViewAdapter((Object)input);
                if (adapter == null) continue;
                Object[] objectArray = adapter.getChildren((IAdaptable)input, null);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof IAdaptable && (adapter = SystemAdapterHelpers.getViewAdapter((Object)object)) != null && name.equals(adapter.getText(object))) {
                        input = object;
                        treeSegments.add(input);
                        continue block0;
                    }
                    ++n2;
                }
                continue;
            }
            treeSegments.clear();
            break;
        }
        TreePath treePath = new TreePath(treeSegments.toArray());
        viewer.setSelection((ISelection)new StructuredSelection((Object)treePath));
        if (viewer instanceof TreeViewer) {
            ((TreeViewer)viewer).expandToLevel((Object)treePath, 1);
        }
    }

    private Viewer getViewer(IViewPart remoteSystemView) {
        if (remoteSystemView instanceof IRSEViewPart) {
            return ((IRSEViewPart)remoteSystemView).getRSEViewer();
        }
        return null;
    }

    private ArrayList<String> createSegmentNames(IFileStore fileStore) {
        ArrayList<String> result = new ArrayList<String>();
        while (fileStore.getParent() != null) {
            result.add(0, fileStore.getName());
            fileStore = fileStore.getParent();
        }
        result.add(0, "/");
        result.add(0, "Root");
        result.add(0, "Local Files");
        result.add(0, "Local");
        return result;
    }

    private void refreshResource(File file) {
        try {
            Path path = new Path(file.getCanonicalPath());
            IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)path);
            IFileInfo fileInfo = fileStore.fetchInfo();
            if (!fileInfo.exists()) {
                return;
            }
            if (fileInfo.isDirectory()) {
                IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)path);
                if (container != null) {
                    container.refreshLocal(2, null);
                }
            } else {
                IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                if (resource != null) {
                    resource.refreshLocal(2, null);
                }
            }
        }
        catch (IOException e) {
            ForgeUIPlugin.log(e);
        }
        catch (CoreException e) {
            ForgeUIPlugin.log(e);
        }
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
        }
        catch (CoreException e) {
            ForgeUIPlugin.log(e);
        }
    }

    public void postCommandFailure(UICommand arg0, UIExecutionContext arg1, Throwable arg2) {
        this.pomFile = null;
        this.pomFileModificationStamp = -1L;
    }

    public void preCommandExecuted(UICommand command, UIExecutionContext executionContext) {
        UISelection selection = executionContext.getUIContext().getInitialSelection();
        for (Object object : selection) {
            if (!(object instanceof Resource)) continue;
            this.pomFile = this.determinePomFile((Resource)object);
            if (this.pomFile == null) continue;
            this.pomFileModificationStamp = this.pomFile.getModificationStamp();
        }
    }

    private IFile determinePomFile(Resource<?> resource) {
        IFile result = null;
        try {
            Object object = resource.getUnderlyingResourceObject();
            if (object != null && object instanceof File) {
                Path path = new Path(((File)object).getCanonicalPath());
                IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)path);
                IFileInfo fileInfo = fileStore.fetchInfo();
                if (fileInfo.exists()) {
                    IProject project;
                    Object res = null;
                    res = fileInfo.isDirectory() ? ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)path) : ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                    if (res != null && (project = res.getProject()) != null) {
                        result = project.getFile((IPath)new Path("pom.xml"));
                    }
                }
            }
        }
        catch (IOException e) {
            ForgeUIPlugin.log(e);
        }
        return result;
    }
}

