/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.actions;

import java.net.URL;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.core.runtime.ForgeRuntimeState;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;

public class GoToAction
extends Action
implements ISelectionListener {
    private ISelection selection;
    private ForgeRuntime runtime;

    public GoToAction(ForgeRuntime runtime) {
        this.runtime = runtime;
        this.setImageDescriptor(this.createImageDescriptor());
        this.setToolTipText("Go To Selection");
        this.getSelectionService().addPostSelectionListener((ISelectionListener)this);
    }

    public void run() {
        this.goToSelection();
    }

    protected void finalize() {
        this.getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection newSelection) {
        this.selection = newSelection;
    }

    public boolean isEnabled() {
        return ForgeRuntimeState.RUNNING.equals((Object)this.runtime.getState());
    }

    private ImageDescriptor createImageDescriptor() {
        URL url = ForgeUIPlugin.getDefault().getBundle().getEntry("icons/goto_obj.gif");
        return ImageDescriptor.createFromURL((URL)url);
    }

    public boolean goToSelection() {
        if (this.selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)this.selection;
            Object first = ss.getFirstElement();
            if (first instanceof IResource) {
                this.goToPath(((IResource)first).getLocation().toOSString());
            } else {
                if (first instanceof IJavaElement) {
                    IResource resource;
                    block8: {
                        try {
                            resource = ((IJavaElement)first).getCorrespondingResource();
                            if (resource != null) break block8;
                            return false;
                        }
                        catch (JavaModelException e) {
                            ForgeUIPlugin.log(e);
                            return false;
                        }
                    }
                    this.goToPath(resource.getLocation().toOSString());
                }
                if (first instanceof IRemoteFile) {
                    this.goToPath(((IRemoteFile)first).getAbsolutePath());
                }
            }
            return true;
        }
        return false;
    }

    private void goToPath(String str) {
        if (str.indexOf(32) != -1) {
            str = String.valueOf('\"') + str + '\"';
        }
        this.runtime.sendInput("pick-up " + str + "\n");
    }

    private ISelectionService getSelectionService() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
    }
}

