/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.validation.java;

import java.util.Map;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.jboss.tools.common.validation.ValidationMessage;

public class TempJavaProblem
extends CategorizedProblem {
    public static final String MARKER_TYPE = "org.jboss.tools.common.validation.temp";
    private int fSourceEnd = 0;
    private int fLineNumber = 1;
    private int fSourceStart = 0;
    private String fMessage;
    private boolean fIsError;
    private String fOrigin;
    private ValidationMessage vMessage;
    public static final int TEMP_PROBLEM_ID = -2013265920;

    public TempJavaProblem(ValidationMessage message, String origin) {
        this.fSourceStart = message.getOffset();
        this.fSourceEnd = message.getOffset() + message.getLength() - 1;
        this.fLineNumber = message.getLineNumber();
        this.fMessage = message.getText();
        this.fOrigin = origin;
        this.fIsError = 2 != message.getSeverity();
        this.vMessage = message;
    }

    public String[] getArguments() {
        return new String[0];
    }

    public int getID() {
        Integer messageId = (Integer)this.vMessage.getAttribute("Message_id");
        if (messageId != null) {
            return -2013265920 + messageId;
        }
        return -2013265920;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public char[] getOriginatingFileName() {
        return this.fOrigin.toCharArray();
    }

    public int getSourceEnd() {
        return this.fSourceEnd;
    }

    public int getSourceLineNumber() {
        return this.fLineNumber;
    }

    public int getSourceStart() {
        return this.fSourceStart;
    }

    public boolean isError() {
        return this.fIsError;
    }

    public boolean isWarning() {
        return !this.fIsError;
    }

    public void setSourceStart(int sourceStart) {
        this.fSourceStart = sourceStart;
    }

    public void setSourceEnd(int sourceEnd) {
        this.fSourceEnd = sourceEnd;
    }

    public void setSourceLineNumber(int lineNumber) {
        this.fLineNumber = lineNumber;
    }

    public int getCategoryID() {
        return 20;
    }

    public String getMarkerType() {
        return MARKER_TYPE;
    }

    public Map getAttributes() {
        return this.vMessage.getAttributes();
    }
}

