/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.validation.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DocumentRewriteSessionEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentRewriteSessionListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.ui.internal.reconcile.DirtyRegionProcessor;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.log.LogHelper;
import org.jboss.tools.common.validation.AsYouTypeValidatorManager;
import org.jboss.tools.common.validation.CommonValidationPlugin;
import org.jboss.tools.common.validation.ITypedReporter;
import org.jboss.tools.common.validation.ValidationMessage;
import org.jboss.tools.common.validation.java.TempJavaProblem;
import org.jboss.tools.common.validation.java.TempJavaProblemAnnotation;

public final class JavaDirtyRegionProcessor
extends DirtyRegionProcessor {
    private ITextEditor fEditor;
    private IDocument fDocument;
    private IValidationContext fHelper;
    private JavaProblemReporter fReporter;
    private AsYouTypeValidatorManager fValidatorManager;
    private boolean fDocumentJustSetup = false;
    private boolean fIsCanceled = false;
    private boolean fInRewriteSession = false;
    private IDocumentRewriteSessionListener fDocumentRewriteSessionListener = new DocumentRewriteSessionListener();
    private List<ITypedRegion> fPartitionsToProcess = new ArrayList<ITypedRegion>();
    private int fStartPartitionsToProcess = -1;
    private int fEndPartitionsToProcess = -1;
    private int fStartRegionToProcess = -1;
    private int fEndRegionToProcess = -1;

    public JavaDirtyRegionProcessor(ITextEditor editor) {
        this.fEditor = editor;
        this.fHelper = this.createValidationContext();
        this.fReporter = this.createProblemReporter();
    }

    private IValidationContext createValidationContext() {
        return new IValidationContext(){

            public Object loadModel(String arg0, Object[] arg1) {
                return null;
            }

            public Object loadModel(String arg0) {
                return null;
            }

            public String[] getURIs() {
                String[] stringArray;
                String URI;
                IFile file = JavaDirtyRegionProcessor.this.fEditor != null && JavaDirtyRegionProcessor.this.fEditor.getEditorInput() instanceof IFileEditorInput ? ((IFileEditorInput)JavaDirtyRegionProcessor.this.fEditor.getEditorInput()).getFile() : null;
                String string = URI = file == null ? null : file.getFullPath().toPortableString();
                if (URI == null) {
                    stringArray = new String[]{};
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = URI;
                }
                return stringArray;
            }
        };
    }

    private JavaProblemReporter createProblemReporter() {
        JavaProblemReporter reporter = new JavaProblemReporter();
        reporter.update();
        return reporter;
    }

    public synchronized void startReconciling() {
        super.startReconciling();
    }

    private boolean isInRewrite() {
        return this.fInRewriteSession;
    }

    public void setDocument(IDocument doc) {
        if (this.fDocument != null) {
            if (this.fDocument instanceof IDocumentExtension4) {
                ((IDocumentExtension4)this.fDocument).removeDocumentRewriteSessionListener(this.fDocumentRewriteSessionListener);
            }
            if (this.fValidatorManager != null && this.fDocument != null) {
                this.fValidatorManager.disconnect(this.fDocument);
            }
        }
        this.fDocument = doc;
        super.setDocument(doc);
        if (this.fDocument != null) {
            if (this.fDocument instanceof IDocumentExtension4) {
                ((IDocumentExtension4)this.fDocument).addDocumentRewriteSessionListener(this.fDocumentRewriteSessionListener);
            }
            if (this.fValidatorManager == null) {
                this.fValidatorManager = new AsYouTypeValidatorManager();
            }
            this.fValidatorManager.connect(this.fDocument);
            if (this.fReporter != null) {
                this.fReporter.update();
            }
        }
        this.fDocumentJustSetup = true;
    }

    public void install(ITextViewer textViewer) {
        super.install(textViewer);
    }

    public void uninstall() {
        this.fIsCanceled = true;
        if (this.fReporter != null) {
            this.fReporter.clearAllAnnotations();
            this.fReporter.setCanceled(true);
        }
        super.uninstall();
    }

    protected void beginProcessing() {
        this.fPartitionsToProcess.clear();
        this.fStartRegionToProcess = -1;
        this.fEndRegionToProcess = -1;
        this.fStartPartitionsToProcess = -1;
        this.fEndPartitionsToProcess = -1;
    }

    private boolean isEditorDirty() {
        if (this.fDocumentJustSetup && this.fEditor.isDirty()) {
            this.fDocumentJustSetup = false;
        }
        return !this.fDocumentJustSetup;
    }

    protected void process(DirtyRegion dirtyRegion) {
        ITypedRegion[] partitions;
        IDocument doc = this.getDocument();
        if (!this.isEditorDirty() || !this.isInstalled() || this.isInRewrite() || dirtyRegion == null || doc == null || this.fIsCanceled) {
            return;
        }
        int start = dirtyRegion.getOffset();
        int end = "__remove".equals(dirtyRegion.getType()) ? dirtyRegion.getOffset() : dirtyRegion.getOffset() + dirtyRegion.getLength();
        int docLen = doc.getLength();
        if (docLen == 0) {
            return;
        }
        if (start > docLen) {
            start = docLen;
        }
        if (end >= docLen) {
            end = docLen - 1;
        }
        this.fStartRegionToProcess = this.fStartRegionToProcess == -1 || this.fStartRegionToProcess > start ? start : this.fStartRegionToProcess;
        this.fEndRegionToProcess = this.fEndRegionToProcess == -1 || this.fEndRegionToProcess < end ? end : this.fEndRegionToProcess;
        try {
            ITypedRegion endPartition;
            ITypedRegion startPartition;
            ITypedRegion iTypedRegion = startPartition = doc instanceof IDocumentExtension3 ? ((IDocumentExtension3)doc).getPartition("___java_partitioning", start, true) : doc.getPartition(start);
            if (startPartition != null && start > startPartition.getOffset()) {
                start = startPartition.getOffset();
            }
            ITypedRegion iTypedRegion2 = endPartition = doc instanceof IDocumentExtension3 ? ((IDocumentExtension3)doc).getPartition("___java_partitioning", end, false) : doc.getPartition(end);
            if (endPartition != null && end < endPartition.getOffset() + endPartition.getLength()) {
                end = endPartition.getOffset() + endPartition.getLength();
            }
        }
        catch (BadLocationException e) {
            LogHelper.logError((Plugin)CommonValidationPlugin.getDefault(), (Throwable)e);
        }
        catch (BadPartitioningException e) {
            LogHelper.logError((Plugin)CommonValidationPlugin.getDefault(), (Throwable)e);
        }
        this.fStartPartitionsToProcess = this.fStartPartitionsToProcess == -1 || this.fStartPartitionsToProcess > start ? start : this.fStartPartitionsToProcess;
        this.fEndPartitionsToProcess = this.fEndPartitionsToProcess == -1 || this.fEndPartitionsToProcess < end ? end : this.fEndPartitionsToProcess;
        ITypedRegion[] iTypedRegionArray = partitions = this.computePartitioning(start, end - start);
        int n = partitions.length;
        int n2 = 0;
        while (n2 < n) {
            String type;
            ITypedRegion partition = iTypedRegionArray[n2];
            if (partition != null && !this.fIsCanceled && ("__java_string".equals(type = partition.getType()) || "__java_character".equals(type) || "__java_singleline_comment".equals(type) || "__java_multiline_comment".equals(type) || "__java_javadoc".equals(type)) && !this.fPartitionsToProcess.contains(partition)) {
                this.fPartitionsToProcess.add(partition);
            }
            ++n2;
        }
    }

    protected void endProcessing() {
        if (this.fValidatorManager == null || this.fReporter == null || this.fStartPartitionsToProcess == -1 || this.fEndPartitionsToProcess == -1) {
            return;
        }
        this.fReporter.clearRegions();
        if (this.fPartitionsToProcess != null && !this.fPartitionsToProcess.isEmpty()) {
            List<IRegion> regions = Arrays.asList(this.fPartitionsToProcess.toArray(new IRegion[this.fPartitionsToProcess.size()]));
            this.fReporter.setRegions(regions);
            this.fValidatorManager.validateString(regions, this.fHelper, this.fReporter);
            this.fReporter.finishReporting();
        } else if (this.isJavaElementValidationRequired()) {
            this.fValidatorManager.validateJavaElement(Arrays.asList(new Region(this.fStartRegionToProcess, this.fEndRegionToProcess - this.fStartRegionToProcess)), this.fHelper, this.fReporter);
            this.fReporter.finishReporting();
        }
    }

    /*
     * Exception decompiling
     */
    private boolean isJavaElementValidationRequired() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[DOLOOP]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ITypedRegion findPartitionByOffset(ITypedRegion[] partitions, int offset) {
        if (partitions == null) {
            return null;
        }
        ITypedRegion[] iTypedRegionArray = partitions;
        int n = partitions.length;
        int n2 = 0;
        while (n2 < n) {
            ITypedRegion partition = iTypedRegionArray[n2];
            if (offset >= partition.getOffset() && offset < partition.getOffset() + partition.getLength()) {
                return partition;
            }
            ++n2;
        }
        return null;
    }

    private boolean isProcessingRequiredForPartition(ITypedRegion partition) {
        if (partition == null) {
            return false;
        }
        String type = partition.getType();
        return !"__java_string".equals(type) && !"__java_character".equals(type) && !"__java_singleline_comment".equals(type) && !"__java_multiline_comment".equals(type) && !"__java_javadoc".equals(type);
    }

    class DocumentRewriteSessionListener
    implements IDocumentRewriteSessionListener {
        DocumentRewriteSessionListener() {
        }

        public void documentRewriteSessionChanged(DocumentRewriteSessionEvent event) {
            JavaDirtyRegionProcessor.this.fInRewriteSession = event != null && event.getChangeType().equals(DocumentRewriteSessionEvent.SESSION_START);
        }
    }

    public final class JavaProblemReporter
    implements IReporter,
    ITypedReporter {
        private List<IMessage> messages = new ArrayList<IMessage>();
        private IFile fFile;
        private ICompilationUnit fCompilationUnit;
        private IAnnotationModel fAnnotationModel;
        private boolean fIsCanceled = false;
        Set<Annotation> fAnnotations = new HashSet<Annotation>();
        private List<String> fTypesForFileValidation = new ArrayList<String>();
        private List<String> fTypesForRegionValidatoin = new ArrayList<String>();
        private List<IRegion> fRegions;

        public void removeMessageSubset(IValidator validator, Object obj, String groupName) {
        }

        public void removeAllMessages(IValidator origin, Object object) {
        }

        public void removeAllMessages(IValidator origin) {
        }

        public void removeAllMessages() {
            this.messages.clear();
        }

        public void setCanceled(boolean set) {
            this.fIsCanceled = set;
        }

        public boolean isCancelled() {
            return this.fIsCanceled;
        }

        public List getMessages() {
            return this.messages;
        }

        public void displaySubtask(IValidator validator, IMessage message) {
        }

        public void update() {
            this.clearAllAnnotations();
            this.getAnnotationModel();
            this.fFile = JavaDirtyRegionProcessor.this.fEditor != null && JavaDirtyRegionProcessor.this.fEditor.getEditorInput() instanceof IFileEditorInput ? ((IFileEditorInput)JavaDirtyRegionProcessor.this.fEditor.getEditorInput()).getFile() : null;
            this.fCompilationUnit = this.fFile != null ? EclipseUtil.getCompilationUnit((IFile)this.fFile) : null;
        }

        protected IAnnotationModel getAnnotationModel() {
            IDocumentProvider documentProvider = JavaDirtyRegionProcessor.this.fEditor.getDocumentProvider();
            if (documentProvider == null) {
                return null;
            }
            IAnnotationModel newModel = documentProvider.getAnnotationModel((Object)JavaDirtyRegionProcessor.this.fEditor.getEditorInput());
            if (this.fAnnotationModel != newModel) {
                this.fAnnotationModel = newModel;
            }
            return this.fAnnotationModel;
        }

        public ICompilationUnit getCompilationUnit() {
            return this.fCompilationUnit;
        }

        public void clearAllAnnotations() {
            Annotation[] annotations;
            if (this.fAnnotations.isEmpty()) {
                return;
            }
            Annotation[] annotationArray = annotations = this.fAnnotations.toArray(new Annotation[0]);
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                this.fAnnotations.remove(annotation);
                if (this.fAnnotationModel != null) {
                    this.fAnnotationModel.removeAnnotation(annotation);
                }
                ++n2;
            }
        }

        public void addMessage(IValidator origin, IMessage message) {
            this.messages.add(message);
        }

        public void finishReporting() {
            if (this.isCancelled() || this.getAnnotationModel() == null || this.fCompilationUnit == null) {
                return;
            }
            IEditorInput editorInput = JavaDirtyRegionProcessor.this.fEditor.getEditorInput();
            if (editorInput == null) {
                return;
            }
            String editorInputName = editorInput.getName();
            Collection<String> regionTypes = this.getTypesForRegion();
            Collection<String> fileTypes = this.getTypesForFile();
            Annotation[] annotations = this.fAnnotations.toArray(new Annotation[0]);
            ArrayList<Annotation> annotationsToRemove = new ArrayList<Annotation>();
            HashSet<ValidationMessage> existingValidationMessages = new HashSet<ValidationMessage>();
            Annotation[] annotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (annotation instanceof TempJavaProblemAnnotation) {
                    TempJavaProblemAnnotation jpAnnotation = (TempJavaProblemAnnotation)annotation;
                    Position position = this.getAnnotationModel().getPosition((Annotation)jpAnnotation);
                    Map attributes = jpAnnotation.getAttributes();
                    Object typeOfAnnotation = attributes == null ? null : attributes.get("jbt.type");
                    boolean isRegionWideAnnotationType = regionTypes.contains(typeOfAnnotation);
                    boolean isFileWideAnnotationType = fileTypes.contains(typeOfAnnotation);
                    IRegion regionOfAnnotation = position == null ? null : this.findRegion(position.getOffset());
                    boolean existing = false;
                    for (IMessage m : this.messages) {
                        if (!(m instanceof ValidationMessage)) continue;
                        ValidationMessage valMessage = (ValidationMessage)m;
                        if (position == null || position.getOffset() != valMessage.getOffset() || position.getLength() != valMessage.getLength()) continue;
                        String text = valMessage.getText();
                        String string = text = text == null ? "" : text;
                        if (!text.equalsIgnoreCase(jpAnnotation.getText())) continue;
                        Object type = valMessage.getAttribute("jbt.type");
                        type = type == null ? "" : type;
                        Map jpAttributes = jpAnnotation.getAttributes();
                        if (jpAttributes == null || !type.equals(jpAttributes.get("jbt.type"))) continue;
                        existingValidationMessages.add(valMessage);
                        existing = true;
                        break;
                    }
                    if (!existing && (isFileWideAnnotationType || isRegionWideAnnotationType && regionOfAnnotation != null)) {
                        annotationsToRemove.add(annotation);
                    }
                }
                ++n2;
            }
            HashMap<TempJavaProblemAnnotation, Position> annotationsToAdd = new HashMap<TempJavaProblemAnnotation, Position>();
            for (IMessage message : this.messages) {
                if (!(message instanceof ValidationMessage) || existingValidationMessages.contains(message)) continue;
                ValidationMessage valMessage = (ValidationMessage)message;
                Position position = new Position(valMessage.getOffset(), valMessage.getLength());
                TempJavaProblem problem = new TempJavaProblem(valMessage, editorInputName);
                TempJavaProblemAnnotation problemAnnotation = new TempJavaProblemAnnotation(problem, this.fCompilationUnit);
                annotationsToAdd.put(problemAnnotation, position);
            }
            this.getAnnotationModel();
            for (Annotation a : annotationsToRemove) {
                this.fAnnotations.remove(a);
                this.fAnnotationModel.removeAnnotation(a);
            }
            for (Annotation a : annotationsToAdd.keySet()) {
                Position p = (Position)annotationsToAdd.get(a);
                this.fAnnotations.add(a);
                this.fAnnotationModel.addAnnotation(a, p);
            }
            this.removeAllMessages();
            this.clearRegions();
        }

        @Override
        public void addTypeForFile(String type) {
            if (!this.fTypesForFileValidation.contains(type)) {
                this.fTypesForFileValidation.add(type);
            }
        }

        @Override
        public Collection<String> getTypesForFile() {
            return Collections.unmodifiableList(this.fTypesForFileValidation);
        }

        @Override
        public void addTypeForRegion(String type) {
            if (!this.fTypesForRegionValidatoin.contains(type)) {
                this.fTypesForRegionValidatoin.add(type);
            }
        }

        @Override
        public Collection<String> getTypesForRegion() {
            return Collections.unmodifiableList(this.fTypesForRegionValidatoin);
        }

        public void setRegions(List<IRegion> regions) {
            this.fRegions = regions;
        }

        public void clearRegions() {
            this.fRegions = null;
        }

        private IRegion findRegion(int position) {
            if (this.fRegions != null) {
                for (IRegion region : this.fRegions) {
                    if (region.getOffset() > position || region.getOffset() + region.getLength() <= position) continue;
                    return region;
                }
            }
            return null;
        }
    }
}

