/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.validation;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.common.util.EclipseUIUtil;
import org.jboss.tools.common.validation.AbstractTemporaryAnnotation;
import org.jboss.tools.common.validation.ContextValidationHelper;
import org.jboss.tools.common.validation.DisabledAnnotation;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.ValidationErrorManager;
import org.jboss.tools.common.validation.ValidationMessage;

public abstract class TempMarkerManager
extends ValidationErrorManager {
    public static final String MESSAGE_TYPE_ATTRIBUTE_NAME = "jbt.type";
    protected boolean asYouTypeValidation;
    protected int messageCounter;
    private static final IMessage[] EMPTY_MESSAGE_ARRAY = new IMessage[0];
    public static final String AS_YOU_TYPE_VALIDATION_ANNOTATION_ATTRIBUTE = "org.jboss.tools.common.validation.asyoutype";
    public static final String CLEAN_ALL_ANNOTATIONS_ATTRIBUTE = "org.jboss.tools.common.validation.cleanAllAnnotaions";

    protected abstract String getMessageBundleName();

    @Override
    public void init(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext validationContext, IValidator manager, IReporter reporter, boolean asYouTypeValidation) {
        super.init(project, validationHelper, validationContext, manager, reporter, asYouTypeValidation);
        this.messageCounter = 0;
    }

    public boolean isAsYouTypeValidation() {
        return this.asYouTypeValidation;
    }

    public void setAsYouTypeValidation(boolean asYouTypeValidation) {
        this.asYouTypeValidation = asYouTypeValidation;
        this.dirtyFiles = asYouTypeValidation ? new HashSet() : EclipseUIUtil.getDirtyFiles();
    }

    public void addProblem(String message, String preferenceKey, ITextSourceReference location, IResource target) {
        if (this.asYouTypeValidation) {
            this.addMessage(target, location, preferenceKey, message);
        } else {
            this.addError(message, preferenceKey, location, target);
        }
    }

    public void addProblem(String message, String preferenceKey, String[] messageArguments, ITextSourceReference location, IResource target) {
        if (this.asYouTypeValidation) {
            this.addMessage(target, location, preferenceKey, message, messageArguments);
        } else {
            this.addError(message, preferenceKey, messageArguments, location, target);
        }
    }

    public void addProblem(String message, String preferenceKey, ITextSourceReference location, IResource target, Integer quickFixId) {
        if (this.asYouTypeValidation) {
            this.addMessage(target, location, preferenceKey, message, quickFixId);
        } else {
            this.addError(message, preferenceKey, location, target, quickFixId);
        }
    }

    public IMarker addProblem(String message, String preferenceKey, String[] messageArguments, int length, int offset, IResource target, Integer quickFixId) {
        if (this.asYouTypeValidation) {
            this.addMessage(target, offset, length, preferenceKey, message, messageArguments, quickFixId);
            return null;
        }
        return this.addError(message, preferenceKey, messageArguments, length, offset, target, quickFixId);
    }

    public IMarker addProblem(String message, String preferenceKey, String[] messageArguments, int length, int offset, IResource target) {
        if (this.asYouTypeValidation) {
            this.addMessage(target, offset, length, preferenceKey, message, messageArguments);
            return null;
        }
        return this.addError(message, preferenceKey, messageArguments, length, offset, target);
    }

    public IMessage addMessage(IResource target, ITextSourceReference location, String preferenceKey, String textMessage) {
        return this.addMessage(target, -1, location, preferenceKey, textMessage, null);
    }

    public IMessage addMessage(IResource target, ITextSourceReference location, String preferenceKey, String textMessage, String[] messageArguments) {
        return this.addMessage(target, -1, location, preferenceKey, textMessage, messageArguments);
    }

    public IMessage addMessage(IResource target, ITextSourceReference location, String preferenceKey, String textMessage, int quickFixId) {
        IMessage message = this.addMessage(target, -1, location, preferenceKey, textMessage, null);
        if (message != null && quickFixId != -1) {
            message.setAttribute("Message_id", (Object)quickFixId);
        }
        return message;
    }

    public IMessage addMessage(IResource target, int lineNumber, ITextSourceReference location, String preferenceKey, String textMessage, String[] messageArguments) {
        IMessage message = null;
        IResource actualTarget = location.getResource();
        if (target.equals((Object)actualTarget)) {
            int severity = this.getSeverity(preferenceKey, target);
            try {
                if (!(severity == -1 || severity == 2 && TempMarkerManager.hasSuppressWarningsAnnotation(preferenceKey, location))) {
                    message = this.addMesssage(target, lineNumber, location.getStartPosition(), location.getLength(), severity, preferenceKey, textMessage, messageArguments, -1);
                }
            }
            catch (JavaModelException e) {
                CommonPlugin.getDefault().logError((Throwable)e);
            }
        }
        return message;
    }

    public IMessage addMessage(IResource target, int offset, int length, String preferenceKey, String messageText, String[] messageArguments, int quickFixId) {
        return this.addMessage(target, -1, offset, length, preferenceKey, messageText, messageArguments, quickFixId);
    }

    public IMessage addMessage(IResource target, int offset, int length, String preferenceKey, String message, String[] messageArguments) {
        return this.addMessage(target, -1, offset, length, preferenceKey, message, messageArguments, -1);
    }

    public IMessage addMessage(IResource target, int lineNumber, int offset, int length, String preferenceKey, String message, String[] messageArguments, int quickFixId) {
        int severity = this.getSeverity(preferenceKey, target);
        return severity != -1 ? this.addMesssage(target, lineNumber, offset, length, severity, preferenceKey, message, messageArguments, quickFixId) : null;
    }

    private IMessage addMesssage(IResource target, int lineNumber, int offset, int length, int severity, String preferenceKey, String textMessage, String[] messageArguments, int quickFixId) {
        IMessage message = null;
        if (this.messageCounter <= this.getMaxNumberOfMarkersPerFile(target.getProject())) {
            String type;
            if (lineNumber < 0) {
                try {
                    lineNumber = this.document.getLineOfOffset(offset) + 1;
                }
                catch (BadLocationException e) {
                    CommonPlugin.getDefault().logError((Throwable)e);
                }
            }
            if ((message = TempMarkerManager.addMesssage(this.validationManager, this.shouldCleanAllAnnotations(), this.reporter, offset, length, target, lineNumber, severity, textMessage, messageArguments, this.getMessageBundleName())) != null && quickFixId != -1) {
                message.setAttribute("Message_id", (Object)quickFixId);
            }
            ++this.messageCounter;
            if (preferenceKey != null) {
                message.setAttribute("preference_key", (Object)preferenceKey);
            }
            if ((type = this.getProblemType()) != null) {
                message.setAttribute(MESSAGE_TYPE_ATTRIBUTE_NAME, (Object)type);
            }
        }
        return message;
    }

    protected boolean shouldCleanAllAnnotations() {
        return false;
    }

    private static IMessage addMesssage(IValidator validator, boolean cleanAllAnnotaions, IReporter reporter, int offset, int length, IResource target, int lineNumber, int severity, String textMessage, Object[] messageArguments, String bundleName) {
        if (messageArguments == null) {
            messageArguments = new String[]{};
        }
        ValidationMessage message = new ValidationMessage(severity, MessageFormat.format(textMessage, messageArguments), target);
        message.setOffset(offset);
        message.setLength(length);
        message.setLineNo(lineNumber);
        message.setBundleName(bundleName);
        message.setAttribute(AS_YOU_TYPE_VALIDATION_ANNOTATION_ATTRIBUTE, Boolean.TRUE);
        if (cleanAllAnnotaions) {
            message.setAttribute(CLEAN_ALL_ANNOTATIONS_ATTRIBUTE, Boolean.TRUE);
        }
        reporter.addMessage(validator, (IMessage)message);
        return message;
    }

    protected void disableProblemAnnotations(final IRegion region, IReporter reporter) {
        List messages = reporter.getMessages();
        IMessage[] msgs = EMPTY_MESSAGE_ARRAY;
        if (messages != null) {
            msgs = messages.toArray(new IMessage[messages.size()]);
        }
        final IMessage[] messageArray = msgs;
        UIJob job = new UIJob("As-you-type JBT validation. Disabling the marker annotations."){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInUIThread(IProgressMonitor monitor) {
                ITextEditor e;
                if (EclipseUIUtil.isActiveEditorDirty() && (e = EclipseUIUtil.getActiveEditor()) != null) {
                    IAnnotationModel model;
                    IEditorInput input = e.getEditorInput();
                    IDocumentProvider dp = e.getDocumentProvider();
                    if (TempMarkerManager.this.document == dp.getDocument((Object)input) && (model = dp.getAnnotationModel((Object)input)) instanceof AbstractMarkerAnnotationModel) {
                        AbstractMarkerAnnotationModel anModel = (AbstractMarkerAnnotationModel)model;
                        Object object = anModel.getLockObject();
                        synchronized (object) {
                            Iterator iterator = anModel.getAnnotationIterator(region.getOffset(), region.getLength(), true, true);
                            HashSet<Object> annotationsToRemove = new HashSet<Object>();
                            HashMap<Annotation, Position> newAnnotations = new HashMap<Annotation, Position>();
                            block5: while (iterator.hasNext()) {
                                Object annotation;
                                Object e2 = iterator.next();
                                if (e2 instanceof MarkerAnnotation) {
                                    annotation = (MarkerAnnotation)e2;
                                    IMarker marker = annotation.getMarker();
                                    try {
                                        String type = marker.getType();
                                        if (TempMarkerManager.this.getProblemType().equals(type)) {
                                            int offset = marker.getAttribute("charStart", 0);
                                            int originalMarkerEnd = marker.getAttribute("charEnd", -1);
                                            String markerMessage = marker.getAttribute("message", "");
                                            boolean removedProblem = true;
                                            IMessage[] iMessageArray = messageArray;
                                            int n = messageArray.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                IMessage object2 = iMessageArray[n2];
                                                IMessage message = object2;
                                                if (message.getOffset() == offset && message.getLength() == originalMarkerEnd - offset && markerMessage.equals(message.getText())) {
                                                    removedProblem = false;
                                                    break;
                                                }
                                                ++n2;
                                            }
                                            if (removedProblem) {
                                                DisabledAnnotation newAnnotation = new DisabledAnnotation((Annotation)annotation, type, marker.getAttribute("severity", 1) == 1);
                                                Position p = anModel.getPosition((Annotation)annotation);
                                                newAnnotations.put(newAnnotation, p);
                                                annotationsToRemove.add(annotation);
                                                continue;
                                            }
                                            annotation.markDeleted(true);
                                            continue;
                                        }
                                        if (!"org.jboss.tools.jst.jsp.jspeditor.JSPMultiPageEditor".equals(e.getClass().getName()) || !"org.eclipse.jst.jsf.facelet.ui.FaceletValidationMarker".equals(type)) continue;
                                        annotationsToRemove.add(annotation);
                                    }
                                    catch (CoreException ce) {
                                        CommonPlugin.getDefault().logError((Throwable)ce);
                                    }
                                    continue;
                                }
                                if (!(e2 instanceof DisabledAnnotation)) continue;
                                annotation = (DisabledAnnotation)((Object)e2);
                                Position p = anModel.getPosition((Annotation)annotation);
                                IMessage[] iMessageArray = messageArray;
                                int n = messageArray.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    IMessage object3;
                                    IMessage message = object3 = iMessageArray[n3];
                                    if (TempMarkerManager.this.getProblemType().equals(((AbstractTemporaryAnnotation)((Object)annotation)).getProblemType()) && message.getOffset() == p.getOffset() && annotation.getText().equals(message.getText())) {
                                        annotationsToRemove.add(annotation);
                                        Annotation markerAnnotation = ((DisabledAnnotation)((Object)annotation)).getOverlaidAnnotation();
                                        markerAnnotation.markDeleted(true);
                                        Position newPossition = new Position(message.getOffset(), message.getLength());
                                        newAnnotations.put(markerAnnotation, newPossition);
                                        continue block5;
                                    }
                                    ++n3;
                                }
                            }
                            for (Annotation annotation : annotationsToRemove) {
                                anModel.removeAnnotation(annotation);
                            }
                            for (Annotation annotation : newAnnotations.keySet()) {
                                anModel.addAnnotation(annotation, (Position)newAnnotations.get(annotation));
                            }
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    @Deprecated
    private static class SimpleReference
    implements ITextSourceReference {
        int start;
        int length;
        IResource resource;

        public SimpleReference(int start, int length, IResource resource) {
            this.start = start;
            this.length = length;
            this.resource = resource;
        }

        public int getStartPosition() {
            return this.start;
        }

        public int getLength() {
            return this.length;
        }

        public IResource getResource() {
            return this.resource;
        }
    }
}

