/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.util.EclipseUIUtil;
import org.jboss.tools.common.validation.DisabledAnnotation;
import org.jboss.tools.common.validation.EditorValidationContext;
import org.jboss.tools.common.validation.IAsYouTypeValidator;
import org.jboss.tools.common.validation.IValidatingProjectSet;
import org.jboss.tools.common.validation.IValidator;
import org.jboss.tools.common.validation.JBTValidationException;
import org.jboss.tools.common.validation.java.TempJavaProblemAnnotation;

public class AsYouTypeValidatorManager
implements ISourceValidator,
org.eclipse.wst.validation.internal.provisional.core.IValidator {
    private IDocument document;
    private IFile file;
    private EditorValidationContext context;
    private Map<IValidator, IProject> rootProjects;
    private int count;
    private static boolean disabled;
    private boolean disconnected = true;
    private static Set<IDocument> reporters;

    static {
        reporters = new HashSet<IDocument>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(IDocument document) {
        AsYouTypeValidatorManager asYouTypeValidatorManager = this;
        synchronized (asYouTypeValidatorManager) {
            this.disconnected = false;
            this.count = 0;
            this.document = document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(IDocument document) {
        AsYouTypeValidatorManager asYouTypeValidatorManager = this;
        synchronized (asYouTypeValidatorManager) {
            this.disconnected = true;
            this.context = null;
            Set<IDocument> set = reporters;
            synchronized (set) {
                reporters.remove(document);
            }
        }
    }

    static void removeMessages() {
        UIJob job = new UIJob("Removing as-you-type JBT validation problems"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInUIThread(IProgressMonitor monitor) {
                ITextEditor e;
                if (!EclipseUIUtil.isActiveEditorDirty() && (e = EclipseUIUtil.getActiveEditor()) != null) {
                    IAnnotationModel model;
                    IEditorInput input = e.getEditorInput();
                    IDocumentProvider dp = e.getDocumentProvider();
                    IDocument doc = dp.getDocument((Object)input);
                    boolean ok = false;
                    Set set = reporters;
                    synchronized (set) {
                        ok = reporters.contains(doc);
                    }
                    if (ok && (model = dp.getAnnotationModel((Object)input)) instanceof AbstractMarkerAnnotationModel) {
                        AbstractMarkerAnnotationModel anModel = (AbstractMarkerAnnotationModel)model;
                        Object object = anModel.getLockObject();
                        synchronized (object) {
                            Iterator iterator = anModel.getAnnotationIterator();
                            while (iterator.hasNext()) {
                                Object annotation;
                                Object o = iterator.next();
                                if (o instanceof TemporaryAnnotation) {
                                    annotation = (TemporaryAnnotation)o;
                                    Map attributes = annotation.getAttributes();
                                    if (attributes == null || attributes.get("org.jboss.tools.common.validation.asyoutype") == null) continue;
                                    anModel.removeAnnotation((Annotation)annotation);
                                    continue;
                                }
                                if (o instanceof DisabledAnnotation) {
                                    annotation = (DisabledAnnotation)((Object)o);
                                    anModel.removeAnnotation((Annotation)annotation);
                                    continue;
                                }
                                if (!(o instanceof TempJavaProblemAnnotation)) continue;
                                annotation = (TempJavaProblemAnnotation)((Object)o);
                                anModel.removeAnnotation((Annotation)annotation);
                            }
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean init(IValidationContext helper, IReporter reporter, boolean test) {
        if (!test && disabled) {
            return false;
        }
        if (this.context == null) {
            Set<IDocument> set = reporters;
            synchronized (set) {
                reporters.add(this.document);
            }
            String[] uris = helper.getURIs();
            if (uris.length == 0) {
                return false;
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            this.file = root.getFile((IPath)new Path(uris[0]));
            if (!this.file.isAccessible()) {
                return false;
            }
            this.context = new EditorValidationContext(this.file.getProject(), this.document);
            if (this.context.getValidators().isEmpty()) {
                return false;
            }
            this.rootProjects = new HashMap<IValidator, IProject>();
            for (IValidator validator : this.context.getValidators()) {
                Map<IProject, IValidatingProjectSet> projectTree = this.context.getValidatingProjectTree(validator).getBrunches();
                if (projectTree.isEmpty()) continue;
                IProject rootProject = projectTree.keySet().iterator().next();
                this.rootProjects.put(validator, rootProject);
            }
        }
        return true;
    }

    private void validate(Set<? extends IAsYouTypeValidator> validators, Collection<IRegion> dirtyRegions, IValidationContext helper, IReporter reporter) {
        ++this.count;
        for (IAsYouTypeValidator iAsYouTypeValidator : validators) {
            try {
                IProject rootProject = this.rootProjects.get(iAsYouTypeValidator);
                IValidatingProjectSet projectBrunch = this.context.getValidatingProjectTree(iAsYouTypeValidator).getBrunches().get(rootProject);
                if (projectBrunch == null) continue;
                iAsYouTypeValidator.validate(this, rootProject, dirtyRegions, helper, reporter, this.context, projectBrunch.getRootContext(), this.file);
            }
            catch (Exception e) {
                CommonPlugin.getDefault().logError((Throwable)new JBTValidationException(e.getMessage(), e));
            }
        }
    }

    public void validateString(Collection<IRegion> dirtyRegions, IValidationContext helper, IReporter reporter) {
        this.validateString(dirtyRegions, helper, reporter, false);
    }

    protected void validateString(Collection<IRegion> dirtyRegions, IValidationContext helper, IReporter reporter, boolean test) {
        if (this.shouldValidate(helper, reporter, test)) {
            this.validate(this.context.getStringValidators(), dirtyRegions, helper, reporter);
        }
    }

    public void validateJavaElement(Collection<IRegion> dirtyRegions, IValidationContext helper, IReporter reporter) {
        this.validateJavaElement(dirtyRegions, helper, reporter, false);
    }

    protected void validateJavaElement(Collection<IRegion> dirtyRegions, IValidationContext helper, IReporter reporter, boolean test) {
        if (this.shouldValidate(helper, reporter, test)) {
            this.validate(this.context.getJavaElementValidators(), dirtyRegions, helper, reporter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldValidate(IValidationContext helper, IReporter reporter, boolean test) {
        boolean ok = false;
        AsYouTypeValidatorManager asYouTypeValidatorManager = this;
        synchronized (asYouTypeValidatorManager) {
            ok = !this.disconnected && this.init(helper, reporter, test);
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(IRegion dirtyRegion, IValidationContext helper, IReporter reporter) {
        ArrayList<IRegion> regions = null;
        AsYouTypeValidatorManager asYouTypeValidatorManager = this;
        synchronized (asYouTypeValidatorManager) {
            if (!this.disconnected) {
                if (this.count == 0) {
                    this.init(helper, reporter, false);
                    ++this.count;
                } else {
                    regions = new ArrayList<IRegion>();
                    regions.add(dirtyRegion);
                }
            }
        }
        if (regions != null) {
            this.validateString(regions, helper, reporter);
        }
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
    }

    public static boolean isDisabled() {
        return disabled;
    }

    public static void setDisabled(boolean disabled) {
        AsYouTypeValidatorManager.disabled = disabled;
    }
}

