/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.ui.editor;

import org.eclipse.datatools.sqltools.data.internal.ui.DataUIPlugin;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.IExternalTableDataEditor;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.ITableDataEditor;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.TableDataTableCursor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TableDataTableCursorExternalEditingSupport
extends TableDataTableCursor {
    private ITableDataEditor editor;
    protected Button button;
    protected IExternalTableDataEditor[] cellEditors;

    public TableDataTableCursorExternalEditingSupport(TableViewer tableViewer, ITableDataEditor editor) {
        super(tableViewer);
        this.editor = editor;
        this.cellEditors = new IExternalTableDataEditor[editor.getTableData().getColumnCount()];
        int i = 0;
        while (i < this.cellEditors.length) {
            this.cellEditors[i] = DataUIPlugin.getDefault().newExternalTableDataCellEditor(editor, i);
            ++i;
        }
        GridLayout gd = new GridLayout();
        gd.marginHeight = 0;
        gd.marginWidth = 0;
        this.setLayout((Layout)gd);
        this.button = new Button((Composite)this, 0x800000);
        this.button.setText("...");
        this.button.setLayoutData((Object)new GridData(1680));
        this.button.setVisible(this.cellEditors[this.getColumn()] != null);
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableDataTableCursorExternalEditingSupport.this.editWithEditor();
                TableDataTableCursorExternalEditingSupport.this.setFocus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableDataTableCursorExternalEditingSupport.this.button.setVisible(TableDataTableCursorExternalEditingSupport.this.cellEditors[TableDataTableCursorExternalEditingSupport.this.getColumn()] != null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.setTabList(new Control[0]);
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.forceFocus();
    }

    public void editWithEditor() {
        try {
            IExternalTableDataEditor externalEditor = this.cellEditors[this.getColumn()];
            if (externalEditor != null) {
                externalEditor.externalEdit(this.editor);
            } else {
                super.edit();
            }
        }
        catch (Exception ex) {
            DataUIPlugin.getDefault().writeLog(4, 0, ex.getMessage(), ex);
            super.edit();
        }
    }

    protected void handleTraverse(TraverseEvent event) {
        if (event.detail == 4) {
            this.editWithEditor();
            event.doit = false;
        } else {
            super.handleTraverse(event);
        }
    }
}

