/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.ssh;

import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jboss.tools.common.ui.preferencevalue.StringPreferenceValue;
import org.jboss.tools.common.ui.preferencevalue.StringsPreferenceValue;

public class SshPrivateKeysPreferences {
    private static final String SSH_PREFERENCE_PAGE_ID = "org.eclipse.jsch.ui.SSHPreferences";
    private static final String JSCH_PLUGIN_ID = "org.eclipse.jsch.core";
    private static final String PRIVATEKEY = "PRIVATEKEY";
    private static final String SSH2HOME = "SSH2HOME";
    private static final String SSH_USERHOME = ".ssh";
    private static final String SSH_USERHOME_WIN32 = "ssh";
    private static StringsPreferenceValue sshPrivateKeyPreference = new StringsPreferenceValue(',', "PRIVATEKEY", "org.eclipse.jsch.core");
    private static StringPreferenceValue sshHome = new StringPreferenceValue("SSH2HOME", "org.eclipse.jsch.core");

    public static void add(String keyName) {
        sshPrivateKeyPreference.add(keyName);
    }

    public static String[] getKeys() {
        return sshPrivateKeyPreference.get();
    }

    public static void remove(String keyName) {
        sshPrivateKeyPreference.remove(keyName);
    }

    public static String getSshKeyDirectory() throws FileNotFoundException {
        String sshHomePath = sshHome.get();
        if (SshPrivateKeysPreferences.isEmpty(sshHomePath)) {
            sshHomePath = SshPrivateKeysPreferences.getSshSystemHome();
        }
        if (SshPrivateKeysPreferences.isEmpty(sshHomePath)) {
            throw new FileNotFoundException("Could not determine path to ssh keys directory.");
        }
        return sshHomePath;
    }

    private static String getSshSystemHome() {
        String userHomePath = System.getProperty("user.home");
        StringBuilder builder = new StringBuilder(userHomePath);
        builder.append(File.separatorChar);
        if (Platform.getOS().equals("win32")) {
            builder.append(SSH_USERHOME_WIN32);
        } else {
            builder.append(SSH_USERHOME);
        }
        return builder.toString();
    }

    public static File getKeyFile(String keyName) throws FileNotFoundException {
        if (SshPrivateKeysPreferences.isEmpty(keyName)) {
            return null;
        }
        if (keyName.startsWith(File.separator)) {
            return new File(keyName);
        }
        return new File(SshPrivateKeysPreferences.getSshKeyDirectory(), keyName);
    }

    private static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static void openPreferencesPage(Shell shell) {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)SSH_PREFERENCE_PAGE_ID, (String[])new String[0], null);
        dialog.open();
    }
}

