/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.marker;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.preferences.SeverityPreferences;
import org.jboss.tools.common.refactoring.MarkerResolutionUtils;
import org.jboss.tools.common.ui.CommonUIMessages;
import org.jboss.tools.common.ui.CommonUIPlugin;
import org.jboss.tools.common.validation.WarningNameManager;
import org.osgi.service.prefs.BackingStoreException;

public class AddSuppressWarningsMarkerResolution
implements IMarkerResolution2,
IJavaCompletionProposal {
    public static final String SUPPRESS_WARNINGS_ANNOTATION = "SuppressWarnings";
    public static final String SPACE = " ";
    public static final String DOT = ".";
    public static final String AT = "@";
    private static final String PROBLEM_ID = "org.eclipse.jdt.core.compiler.problem.unhandledWarningToken";
    private SP preferences = new SP();
    private IFile file;
    private IAnnotatable element;
    private String preferenceKey;
    private String label;
    private String description;
    private ICompilationUnit cu;

    public AddSuppressWarningsMarkerResolution(IFile file, IJavaElement element, String preferenceKey) {
        this.file = file;
        this.element = this.getAnnatatableElement(element);
        String[] names = WarningNameManager.getInstance().getWarningNames(preferenceKey);
        this.preferenceKey = names != null && names.length > 0 ? names[0] : null;
        this.label = NLS.bind((String)CommonUIMessages.ADD_SUPPRESS_WARNINGS_TITLE, (Object)this.preferenceKey, (Object)element.getElementName());
        if (element instanceof IMethod) {
            this.label = String.valueOf(this.label) + "()";
        }
        this.description = this.getPreview();
    }

    public AddSuppressWarningsMarkerResolution(IFile file, IJavaElement element, String preferenceKey, ICompilationUnit compilationUnit) {
        this(file, element, preferenceKey);
        this.cu = compilationUnit;
        this.description = this.getPreview();
    }

    private String getPreview() {
        TextChange previewChange = this.getPreviewChange();
        try {
            return MarkerResolutionUtils.getPreview((Change)previewChange);
        }
        catch (CoreException e) {
            CommonUIPlugin.getDefault().logError(e);
            return this.label;
        }
    }

    private IAnnotatable getAnnatatableElement(IJavaElement element) {
        IJavaElement elem = element;
        while (elem != null) {
            if (element instanceof IAnnotatable) {
                return (IAnnotatable)element;
            }
            elem = elem.getParent();
        }
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    private TextChange getPreviewChange() {
        if (this.element != null && this.preferenceKey != null) {
            ICompilationUnit original;
            block4: {
                ICompilationUnit iCompilationUnit = original = this.cu != null ? this.cu : EclipseUtil.getCompilationUnit((IFile)this.file);
                if (original != null) break block4;
                return null;
            }
            try {
                ICompilationUnit compilationUnit = original.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                CompilationUnitChange change = this.getChange(compilationUnit);
                compilationUnit.discardWorkingCopy();
                return change;
            }
            catch (JavaModelException e) {
                CommonUIPlugin.getDefault().logError(e);
            }
        }
        return null;
    }

    private CompilationUnitChange getChange(ICompilationUnit compilationUnit) throws JavaModelException {
        CompilationUnit cuNode = ASTTools.buildASTRoot((ICompilationUnit)compilationUnit);
        IJavaElement workingCopyElement = AddSuppressWarningsMarkerResolution.findWorkingCopy(compilationUnit, (IJavaElement)this.element);
        ASTNode elementNode = null;
        if (workingCopyElement instanceof JavaElement) {
            elementNode = ((JavaElement)workingCopyElement).findNode(cuNode);
        }
        IAnnotation annotation = this.findAnnotation(workingCopyElement);
        CompilationUnitChange change = null;
        change = annotation != null ? this.updateAnnotation(SUPPRESS_WARNINGS_ANNOTATION, this.preferenceKey, compilationUnit, annotation) : this.addAnnotation("SuppressWarnings(\"" + this.preferenceKey + "\")", compilationUnit, workingCopyElement, elementNode);
        return change;
    }

    public void run(IMarker marker) {
        ICompilationUnit original = EclipseUtil.getCompilationUnit((IFile)this.file);
        if (original != null) {
            this.do_run(original, false);
        }
    }

    private void do_run(ICompilationUnit original, boolean leaveDirty) {
        if (this.element != null && this.preferenceKey != null && original != null) {
            this.disablePreference();
            try {
                ICompilationUnit compilationUnit = original.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                CompilationUnitChange change = this.getChange(compilationUnit);
                if (change != null) {
                    if (leaveDirty) {
                        change.setSaveMode(4);
                    }
                    change.perform((IProgressMonitor)new NullProgressMonitor());
                    original.reconcile(0, false, null, (IProgressMonitor)new NullProgressMonitor());
                }
                compilationUnit.discardWorkingCopy();
            }
            catch (JavaModelException e) {
                CommonUIPlugin.getDefault().logError(e);
            }
            catch (CoreException e) {
                CommonUIPlugin.getDefault().logError(e);
            }
        }
    }

    private IAnnotation findAnnotation(IJavaElement workingCopyElement) throws JavaModelException {
        IAnnotation annotation = ((IAnnotatable)workingCopyElement).getAnnotation(SUPPRESS_WARNINGS_ANNOTATION);
        if (annotation != null && annotation.exists()) {
            return annotation;
        }
        return null;
    }

    public static String getShortName(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(DOT);
        String name = lastDot < 0 ? qualifiedName : qualifiedName.substring(lastDot + 1);
        return name;
    }

    private void disablePreference() {
        String value = this.preferences.getProjectPreference(this.file.getProject(), PROBLEM_ID);
        if (!"ignore".equals(value)) {
            IEclipsePreferences projectPreferences = this.preferences.getProjectPreferences(this.file.getProject());
            String projectValue = null;
            if (projectPreferences != null) {
                projectValue = projectPreferences.get(PROBLEM_ID, null);
            }
            if (projectValue != null) {
                MessageDialog dialog = new MessageDialog(AddSuppressWarningsMarkerResolution.getShell(), this.label, null, String.valueOf(CommonUIMessages.ADD_SUPPRESS_WARNINGS_MESSAGE) + CommonUIMessages.ADD_SUPPRESS_WARNINGS_QUESTION1, 6, new String[]{CommonUIMessages.ADD_SUPPRESS_WARNINGS_CANCEL, CommonUIMessages.ADD_SUPPRESS_WARNINGS_DISABLE}, 0);
                int result = dialog.open();
                if (result == 1) {
                    IEclipsePreferences ePrefs = this.preferences.getProjectPreferences(this.file.getProject());
                    ePrefs.put(PROBLEM_ID, "ignore");
                    try {
                        ePrefs.flush();
                    }
                    catch (BackingStoreException e) {
                        CommonUIPlugin.getDefault().logError(e);
                    }
                }
            } else {
                MessageDialog dialog = new MessageDialog(AddSuppressWarningsMarkerResolution.getShell(), this.label, null, String.valueOf(CommonUIMessages.ADD_SUPPRESS_WARNINGS_MESSAGE) + NLS.bind((String)CommonUIMessages.ADD_SUPPRESS_WARNINGS_QUESTION2, (Object)this.file.getProject().getName()), 6, new String[]{CommonUIMessages.ADD_SUPPRESS_WARNINGS_CANCEL, CommonUIMessages.ADD_SUPPRESS_WARNINGS_WORKSPACE, CommonUIMessages.ADD_SUPPRESS_WARNINGS_PROJECT}, 0);
                int result = dialog.open();
                if (result == 1) {
                    IEclipsePreferences ePrefs = this.preferences.getInstancePreferences();
                    ePrefs.put(PROBLEM_ID, "ignore");
                    try {
                        ePrefs.flush();
                    }
                    catch (BackingStoreException e) {
                        CommonUIPlugin.getDefault().logError(e);
                    }
                } else if (result == 2) {
                    IEclipsePreferences ePrefs = this.preferences.getProjectPreferences(this.file.getProject());
                    ePrefs.put(PROBLEM_ID, "ignore");
                    try {
                        ePrefs.flush();
                    }
                    catch (BackingStoreException e) {
                        CommonUIPlugin.getDefault().logError(e);
                    }
                }
            }
        }
    }

    private static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public Image getImage() {
        String key = "ADD_ANNOTATION";
        ImageRegistry registry = CommonUIPlugin.getDefault().getImageRegistry();
        Image image = registry.get(key);
        if (image == null) {
            try {
                image = ImageDescriptor.createFromURL((URL)new URL(CommonUIPlugin.getDefault().getBundle().getEntry("/"), "icons/add_annotation.png")).createImage();
                registry.put(key, image);
            }
            catch (MalformedURLException e) {
                CommonUIPlugin.getDefault().logError(e);
            }
        }
        return image;
    }

    private CompilationUnitChange updateAnnotation(String name, String parameter, ICompilationUnit compilationUnit, IAnnotation annotation) throws JavaModelException {
        String str = AT + name;
        str = String.valueOf(str) + "({";
        IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
        int n = iMemberValuePairArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object a;
            int n3;
            int n4;
            Object[] objectArray;
            Object[] array;
            Object value;
            IMemberValuePair pair = iMemberValuePairArray[n2];
            if (pair.getValueKind() == 9) {
                value = pair.getValue();
                if (value instanceof String) {
                    if (value.toString().equals(parameter)) {
                        return null;
                    }
                    str = String.valueOf(str) + "\"" + value + "\", ";
                } else if (value instanceof Object[]) {
                    objectArray = array = (Object[])value;
                    n4 = array.length;
                    n3 = 0;
                    while (n3 < n4) {
                        a = objectArray[n3];
                        if (a instanceof String) {
                            if (a.toString().equals(parameter)) {
                                return null;
                            }
                            str = String.valueOf(str) + "\"" + a + "\", ";
                        }
                        ++n3;
                    }
                }
            } else if (pair.getValueKind() == 12 || pair.getValueKind() == 13) {
                value = pair.getValue();
                if (value instanceof String) {
                    str = String.valueOf(str) + value + ", ";
                } else if (value instanceof Object[]) {
                    objectArray = array = (Object[])value;
                    n4 = array.length;
                    n3 = 0;
                    while (n3 < n4) {
                        a = objectArray[n3];
                        if (a instanceof String) {
                            str = String.valueOf(str) + a + ", ";
                        }
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        str = String.valueOf(str) + "\"" + parameter + "\"";
        str = String.valueOf(str) + "})";
        CompilationUnitChange change = new CompilationUnitChange("", compilationUnit);
        ReplaceEdit edit = new ReplaceEdit(annotation.getSourceRange().getOffset(), annotation.getSourceRange().getLength(), str);
        change.setEdit((TextEdit)edit);
        return change;
    }

    private CompilationUnitChange addAnnotation(String name, ICompilationUnit compilationUnit, IJavaElement element, ASTNode node) throws JavaModelException {
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        ISourceReference workingCopySourceReference = (ISourceReference)element;
        IBuffer buffer = compilationUnit.getBuffer();
        int position = workingCopySourceReference.getSourceRange().getOffset();
        if (node != null) {
            char c;
            position = node.getStartPosition();
            if (node instanceof BodyDeclaration && ((BodyDeclaration)node).getJavadoc() != null) {
                c = buffer.getChar(position += ((BodyDeclaration)node).getJavadoc().getLength());
                while ((c == '\r' || c == '\n') && position < buffer.getLength() - 2) {
                    c = buffer.getChar(++position);
                }
            }
            while (position < buffer.getLength() - 1) {
                c = buffer.getChar(position);
                if (c != '\r' && c != '\n' && c != ' ' && c != '\t') break;
                ++position;
            }
        }
        String str = AT + name;
        if (!(workingCopySourceReference instanceof ILocalVariable)) {
            str = String.valueOf(str) + compilationUnit.findRecommendedLineSeparator();
            int index = position;
            while (index >= 0) {
                char c = buffer.getChar(index);
                if (c == '\r' || c == '\n') break;
                --index;
            }
            if (++index < position) {
                String spaces = buffer.getText(index, position - index);
                str = String.valueOf(str) + spaces;
            }
        } else {
            str = String.valueOf(str) + SPACE;
        }
        CompilationUnitChange change = new CompilationUnitChange("", compilationUnit);
        InsertEdit edit = new InsertEdit(position, str);
        change.setEdit((TextEdit)edit);
        return change;
    }

    private static <T extends IJavaElement> T findWorkingCopy(ICompilationUnit compilationUnit, T element) throws JavaModelException {
        block8: {
            block9: {
                block7: {
                    if (!(element instanceof IAnnotation)) break block7;
                    IJavaElement parent = AddSuppressWarningsMarkerResolution.findWorkingCopy(compilationUnit, element.getParent());
                    if (!(parent instanceof IAnnotatable)) break block8;
                    IAnnotation[] iAnnotationArray = ((IAnnotatable)parent).getAnnotations();
                    int n = iAnnotationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IAnnotation a = iAnnotationArray[n2];
                        if (a.getElementName().equals(element.getElementName())) {
                            return (T)a;
                        }
                        ++n2;
                    }
                    break block8;
                }
                if (!(element instanceof ILocalVariable) || !((ILocalVariable)element).isParameter()) break block9;
                IJavaElement parent = AddSuppressWarningsMarkerResolution.findWorkingCopy(compilationUnit, element.getParent());
                if (!(parent instanceof IMethod)) break block8;
                ILocalVariable[] iLocalVariableArray = ((IMethod)parent).getParameters();
                int n = iLocalVariableArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ILocalVariable parameter = iLocalVariableArray[n3];
                    if (parameter.getElementName().equals(element.getElementName()) && parameter.getTypeSignature().equals(((ILocalVariable)element).getTypeSignature())) {
                        return (T)parameter;
                    }
                    ++n3;
                }
                break block8;
            }
            IJavaElement[] elements = compilationUnit.findElements(element);
            if (elements != null) {
                IJavaElement[] iJavaElementArray = elements;
                int n = elements.length;
                int n4 = 0;
                while (n4 < n) {
                    IJavaElement e = iJavaElementArray[n4];
                    if (e.getClass().equals(element.getClass())) {
                        return (T)e;
                    }
                    ++n4;
                }
            }
        }
        return null;
    }

    public void apply(IDocument document) {
        this.do_run(this.cu, true);
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return this.description;
    }

    public String getDisplayString() {
        return this.label;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public int getRelevance() {
        return 100;
    }

    static class SP
    extends SeverityPreferences {
        SP() {
        }

        protected Set<String> getSeverityOptionNames() {
            return null;
        }

        protected String createSeverityOption(String shortName) {
            return null;
        }

        protected String getPluginId() {
            return "org.eclipse.jdt.core";
        }
    }
}

