/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.mm.algorithms.styles;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum UnderlineStyle implements Enumerator
{
    UNDERLINE_SINGLE(0, "UNDERLINE_SINGLE", "UNDERLINE_SINGLE"),
    UNDERLINE_DOUBLE(1, "UNDERLINE_DOUBLE", "UNDERLINE_DOUBLE"),
    UNDERLINE_ERROR(2, "UNDERLINE_ERROR", "UNDERLINE_ERROR"),
    UNDERLINE_SQUIGGLE(3, "UNDERLINE_SQUIGGLE", "UNDERLINE_SQUIGGLE");

    public static final int UNDERLINE_SINGLE_VALUE = 0;
    public static final int UNDERLINE_DOUBLE_VALUE = 1;
    public static final int UNDERLINE_ERROR_VALUE = 2;
    public static final int UNDERLINE_SQUIGGLE_VALUE = 3;
    private static final UnderlineStyle[] VALUES_ARRAY;
    public static final List<UnderlineStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new UnderlineStyle[]{UNDERLINE_SINGLE, UNDERLINE_DOUBLE, UNDERLINE_ERROR, UNDERLINE_SQUIGGLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static UnderlineStyle get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnderlineStyle result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnderlineStyle getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnderlineStyle result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnderlineStyle get(int value) {
        switch (value) {
            case 0: {
                return UNDERLINE_SINGLE;
            }
            case 1: {
                return UNDERLINE_DOUBLE;
            }
            case 2: {
                return UNDERLINE_ERROR;
            }
            case 3: {
                return UNDERLINE_SQUIGGLE;
            }
        }
        return null;
    }

    private UnderlineStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

