/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.cxf;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.BindingConfiguration;
import org.apache.cxf.binding.soap.SoapBindingConfiguration;
import org.apache.cxf.databinding.AbstractDataBinding;
import org.apache.cxf.frontend.AbstractServiceFactory;
import org.apache.cxf.jaxws.support.JaxWsServiceConfiguration;
import org.apache.cxf.service.factory.AbstractServiceConfiguration;
import org.apache.cxf.service.factory.DefaultServiceConfiguration;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.java2wsdl.processor.internal.ServiceBuilderFactory;
import org.apache.cxf.wsdl11.ServiceWSDLBuilder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.switchyard.tools.cxf.Activator;
import org.switchyard.tools.cxf.Java2WSDLOptions;
import org.w3c.dom.Element;

public class Java2WSDLOperation
implements IRunnableWithProgress {
    private Java2WSDLOptions _options;
    private Definition _definition;
    private Map<String, Element> _imports = new HashMap<String, Element>();

    public Java2WSDLOperation(Java2WSDLOptions options) {
        this._options = options;
    }

    public Definition getGeneratedWSDL() {
        return this._definition;
    }

    public Map<String, Element> getGeneratedSchema() {
        return this._imports;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                ClassLoader loader = Activator.getProjectBuildClassLoader(this._options.getServiceInterface().getJavaProject());
                Thread.currentThread().setContextClassLoader(loader);
                ServiceBuilderFactory builderFactory = ServiceBuilderFactory.getInstance(null, (String)"jaxb");
                builderFactory.setServiceClass(loader.loadClass(this._options.getServiceInterface().getFullyQualifiedName()));
                builderFactory.setDatabindingName("jaxb");
                AbstractServiceFactory builder = (AbstractServiceFactory)builderFactory.newBuilder();
                builder.setServiceName(new QName(this._options.getTargetNamespace(), this._options.getServiceName()));
                builder.setAddress(this._options.getLocationURI());
                builder.setTransportId("http://schemas.xmlsoap.org/wsdl/soap/");
                builder.setBindingId("http://schemas.xmlsoap.org/wsdl/soap/");
                if (builder.getBindingConfig() == null) {
                    builder.setBindingConfig((BindingConfiguration)new SoapBindingConfiguration(){

                        public String getStyle() {
                            return Java2WSDLOperation.this._options.getStyle();
                        }

                        public String getUse() {
                            return Java2WSDLOperation.this._options.getUse();
                        }
                    });
                }
                ReflectionServiceFactoryBean serviceFactory = builder.getServiceFactory();
                this.addCustomConfigurations(serviceFactory);
                AbstractDataBinding dataBinding = (AbstractDataBinding)builder.getDataBinding();
                dataBinding.setNamespaceMap(this.createNamepsaceMap());
                ServiceInfo service = builder.createService();
                service.setTargetNamespace(this._options.getTargetNamespace());
                service.setName(new QName(this._options.getTargetNamespace(), this._options.getServiceName()));
                ServiceWSDLBuilder wsdlBuilder = new ServiceWSDLBuilder(builder.getBus(), new ServiceInfo[]{service});
                wsdlBuilder.setUseSchemaImports(this._options.isUseImportedSchema());
                wsdlBuilder.setBaseFileName(this._options.getServiceName());
                HashMap imports = new HashMap();
                this._definition = wsdlBuilder.build(imports);
                for (Map.Entry entry : imports.entrySet()) {
                    this._imports.put((String)entry.getKey(), ((SchemaInfo)entry.getValue()).getElement());
                }
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            BusFactory.setDefaultBus(null);
            BusFactory.setThreadDefaultBus(null);
        }
    }

    private void addCustomConfigurations(ReflectionServiceFactoryBean serviceFactory) {
        for (AbstractServiceConfiguration asc : serviceFactory.getConfigurations()) {
            if (!(asc instanceof JaxWsServiceConfiguration) && !(asc instanceof DefaultServiceConfiguration)) continue;
            serviceFactory.getServiceConfigurations().add(0, new CustomNameServiceConfiguration(asc));
            break;
        }
        serviceFactory.getConfigurations().add(0, new CustomSOAPServiceConfiguration());
    }

    private Map<String, String> createNamepsaceMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(this._options.getTargetNamespace(), this._options.getTargetNamespacePrefix());
        return map;
    }

    private final class CustomNameServiceConfiguration
    extends AbstractServiceConfiguration {
        private AbstractServiceConfiguration _default;

        private CustomNameServiceConfiguration(AbstractServiceConfiguration orig) {
            this._default = orig;
        }

        public Boolean hasOutMessage(Method m) {
            Boolean defaultValue = this._default.hasOutMessage(m);
            if ((defaultValue == null || defaultValue.booleanValue()) && !Void.TYPE.isAssignableFrom(m.getReturnType())) {
                return true;
            }
            return false;
        }

        public QName getInParameterName(OperationInfo op, Method method, int paramNumber) {
            QName name = this._default.getInParameterName(op, method, paramNumber);
            if (name == null || !name.getLocalPart().matches("arg\\d*")) {
                return name;
            }
            return this.replaceDefaultWithTypeName(method.getParameterTypes()[paramNumber], name);
        }

        public QName getOutParameterName(OperationInfo op, Method method, int paramNumber) {
            QName name = this._default.getOutParameterName(op, method, paramNumber);
            if (name == null || !name.getLocalPart().matches("return\\d*")) {
                return name;
            }
            return this.replaceDefaultWithTypeName(method.getReturnType(), name);
        }

        private QName replaceDefaultWithTypeName(Class<?> type, QName name) {
            if (type.isPrimitive()) {
                return name;
            }
            String local = type.getSimpleName();
            if (type.isArray()) {
                local = local.substring(0, local.length() - 2);
            }
            if (local.length() == 0) {
                return name;
            }
            return new QName(name.getNamespaceURI(), String.valueOf(local.substring(0, 1).toLowerCase()) + local.substring(1));
        }

        public String getServiceName() {
            if (this._default instanceof DefaultServiceConfiguration) {
                return Java2WSDLOperation.this._options.getServiceName();
            }
            return this._default.getServiceName();
        }

        public QName getInterfaceName() {
            if (this._default instanceof DefaultServiceConfiguration) {
                return new QName(Java2WSDLOperation.this._options.getTargetNamespace(), String.valueOf(this.getServiceName()) + "PortType");
            }
            return this._default.getInterfaceName();
        }

        public QName getEndpointName() {
            if (this._default instanceof DefaultServiceConfiguration) {
                return new QName(Java2WSDLOperation.this._options.getTargetNamespace(), String.valueOf(this.getServiceName()) + "Port");
            }
            return this._default.getEndpointName();
        }
    }

    private final class CustomSOAPServiceConfiguration
    extends AbstractServiceConfiguration {
        private CustomSOAPServiceConfiguration() {
        }

        public String getAction(OperationInfo op, Method method) {
            String action = super.getAction(op, method);
            if (action == null || action.length() == 0) {
                return op.getName().getLocalPart();
            }
            return action;
        }

        public Boolean isWrapped() {
            return Java2WSDLOperation.this._options.isWrapped();
        }
    }
}

