/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.ui.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;

public class BrowserUtility {
    public void checkedCreateInternalBrowser(String url, String browserId, String pluginId, ILog log) {
        try {
            this.openUrl(url, PlatformUI.getWorkbench().getBrowserSupport().createBrowser(6, browserId, null, null), pluginId, log);
        }
        catch (PartInitException e) {
            IStatus errorStatus = StatusFactory.errorStatus((String)pluginId, (String)NLS.bind((String)"Could not open browser for url \"{0}\".", (Object)url), (Throwable)e);
            log.log(errorStatus);
        }
    }

    public void checkedCreateExternalBrowser(String url, String pluginId, ILog log) {
        try {
            this.openUrl(url, PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser(), pluginId, log);
        }
        catch (PartInitException e) {
            IStatus errorStatus = StatusFactory.errorStatus((String)pluginId, (String)NLS.bind((String)"Could not open browser for url \"{0}\".", (Object)url), (Throwable)e);
            log.log(errorStatus);
        }
    }

    public void openUrl(String url, IWebBrowser browser, String pluginId, ILog log) {
        try {
            browser.openURL(new URL(url));
        }
        catch (PartInitException e) {
            IStatus errorStatus = StatusFactory.errorStatus((String)pluginId, (String)NLS.bind((String)"Could not open browser for url \"{0}\".", (Object)url), (Throwable)e);
            log.log(errorStatus);
        }
        catch (MalformedURLException e) {
            IStatus errorStatus = StatusFactory.errorStatus((String)pluginId, (String)NLS.bind((String)"Could not display malformed url \"{0}\".", (Object)url), (Throwable)e);
            log.log(errorStatus);
        }
    }
}

