/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.core.subsystems;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.Trace;
import org.jboss.ide.eclipse.as.core.util.ProgressMonitorUtil;
import org.jboss.ide.eclipse.as.rse.core.IFileServiceProvider;
import org.jboss.ide.eclipse.as.rse.core.RSEFrameworkUtils;
import org.jboss.ide.eclipse.as.rse.core.RSEUtils;
import org.jboss.ide.eclipse.as.rse.core.util.RemoteCallWrapperUtility;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IFilesystemController;

public class RSEFilesystemController
extends AbstractSubsystemController
implements IFilesystemController,
IFileServiceProvider {
    private ArrayList<IPath> createdFolders = new ArrayList();
    private IFileServiceSubSystem fileSubSystem = null;

    public IStatus copyFile(final File file, final IPath absolutePath, IProgressMonitor monitor) throws CoreException {
        RemoteCallWrapperUtility.NamedRunnableWithProgress run = new RemoteCallWrapperUtility.NamedRunnableWithProgress("Copy file to remote location: " + absolutePath.toOSString()){

            public Object run(IProgressMonitor monitor) throws CoreException, SystemMessageException, RuntimeException {
                RSEFilesystemController.this.getFileService().upload(file, absolutePath.removeLastSegments(1).toOSString(), absolutePath.lastSegment(), true, null, null, monitor);
                return Status.OK_STATUS;
            }
        };
        return RemoteCallWrapperUtility.wrapRemoteCall(this.getServer(), run, absolutePath.toOSString(), "failed to copy to {0} on host {1}", true, monitor);
    }

    public IStatus deleteResource(final IPath remotePath, IProgressMonitor monitor) throws CoreException {
        RemoteCallWrapperUtility.NamedRunnableWithProgress run = new RemoteCallWrapperUtility.NamedRunnableWithProgress("Delete remote file: " + remotePath.toOSString()){

            public Object run(IProgressMonitor monitor) throws CoreException, SystemMessageException, RuntimeException {
                RSEFilesystemController.this.getFileService().delete(remotePath.removeLastSegments(1).toOSString(), remotePath.lastSegment(), monitor);
                return Status.OK_STATUS;
            }
        };
        return RemoteCallWrapperUtility.wrapRemoteCall(this.getServer(), run, remotePath.toOSString(), "failed to delete {0} on host {1}", false, monitor);
    }

    public IStatus makeDirectoryIfRequired(final IPath absolutePath, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Make directory " + absolutePath.toOSString(), 100);
        if (absolutePath.segmentCount() > 0) {
            this.makeDirectoryIfRequired(absolutePath.removeLastSegments(1), ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)70));
        }
        if (this.createdFolders.contains(absolutePath)) {
            return Status.OK_STATUS;
        }
        RemoteCallWrapperUtility.NamedRunnableWithProgress run = new RemoteCallWrapperUtility.NamedRunnableWithProgress("Create Remote Directory: " + absolutePath.toString()){

            public Object run(IProgressMonitor monitor) throws CoreException, SystemMessageException, RuntimeException {
                if (absolutePath.segmentCount() > 0) {
                    RSEFilesystemController.this.getFileService().createFolder(absolutePath.removeLastSegments(1).toString(), absolutePath.lastSegment(), monitor);
                    RSEFilesystemController.this.createdFolders.add(absolutePath);
                }
                return Status.OK_STATUS;
            }
        };
        return RemoteCallWrapperUtility.wrapRemoteCall(this.getServer(), run, absolutePath.toString(), "failed to create folder {0} on host {1}", false, monitor);
    }

    public IStatus touchResource(final IPath absolutePath, IProgressMonitor monitor) {
        RemoteCallWrapperUtility.NamedRunnableWithProgress run = new RemoteCallWrapperUtility.NamedRunnableWithProgress("Touch remote resource" + absolutePath.toOSString()){

            public Object run(IProgressMonitor monitor) throws CoreException, SystemMessageException, RuntimeException {
                IRemoteFile rf = RSEFilesystemController.this.getFileServiceSubSystem().getRemoteFileObject(absolutePath.toOSString(), (IProgressMonitor)new NullProgressMonitor());
                if (!rf.exists()) {
                    RSEFilesystemController.this.getFileServiceSubSystem().createFile(rf, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    RSEFilesystemController.this.getFileServiceSubSystem().setLastModified(rf, new Date().getTime(), null);
                }
                return Status.OK_STATUS;
            }
        };
        try {
            return RemoteCallWrapperUtility.wrapRemoteCall(this.getServer(), run, absolutePath.toString(), "failed to touch resource {0} on host {1}", false, monitor);
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
    }

    public boolean isFile(final IPath absolutePath, IProgressMonitor monitor) throws CoreException {
        final Boolean[] boolRet = new Boolean[]{null};
        RemoteCallWrapperUtility.NamedRunnableWithProgress run = new RemoteCallWrapperUtility.NamedRunnableWithProgress("Verify remote file exists: " + absolutePath.toOSString()){

            public Object run(IProgressMonitor monitor) throws CoreException, SystemMessageException, RuntimeException {
                IRemoteFile rf = RSEFilesystemController.this.getFileServiceSubSystem().getRemoteFileObject(absolutePath.toOSString(), (IProgressMonitor)new NullProgressMonitor());
                boolRet[0] = rf.exists() && rf.isFile();
                return Status.OK_STATUS;
            }
        };
        RemoteCallWrapperUtility.wrapRemoteCall(this.getServer(), run, absolutePath.toOSString(), "failed to verify the existence of {0} on host {1}", true, monitor);
        return boolRet[0];
    }

    @Override
    public IFileServiceSubSystem getFileServiceSubSystem() throws CoreException {
        if (this.fileSubSystem == null) {
            Trace.trace((String)"/finer", (String)"Ensuring RSE is initialized");
            RSEFrameworkUtils.waitForFullInit();
            String connectionName = RSEUtils.getRSEConnectionName((IServerAttributes)this.getServer());
            IHost host = RSEFrameworkUtils.findHost(connectionName);
            if (host == null) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.rse.core", "RSE Host Not Found."));
            }
            this.fileSubSystem = RSEFrameworkUtils.findFileTransferSubSystem(host);
        }
        return this.fileSubSystem;
    }

    @Override
    public IFileService getFileService() throws CoreException {
        return this.getFileServiceSubSystem().getFileService();
    }
}

