/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.core.subsystems;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.services.shells.IHostShell;
import org.jboss.ide.eclipse.as.rse.core.RSECorePlugin;
import org.jboss.ide.eclipse.as.rse.core.RSEHostShellModel;
import org.jboss.ide.eclipse.as.rse.core.RSEUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IServerShutdownController;
import org.jboss.tools.as.core.server.controllable.subsystems.internal.CommandLineShutdownController;

public class RSECommandLineShutdownController
extends CommandLineShutdownController
implements IServerShutdownController {
    protected IStatus executeShutdownCommand(String shutdownCommand) throws CoreException {
        RSEHostShellModel.ServerShellModel model = RSEHostShellModel.getInstance().getModel(this.getServer());
        int ret = model.executeRemoteCommandGetStatus("/", shutdownCommand, new String[0], (IProgressMonitor)new NullProgressMonitor(), 10000, true);
        if (ret == -1 || ret == 0) {
            IHostShell shell = model.getStartupShell();
            if (RSEUtils.isActive(shell)) {
                shell.writeToShell("exit");
            }
            return Status.OK_STATUS;
        }
        return new Status(4, "org.jboss.ide.eclipse.as.rse.core", NLS.bind((String)"Remote shutdown command failed with status {0}", (Object)ret));
    }

    protected synchronized void forceStop() {
        if (this.getServer().getServerState() == 4) {
            return;
        }
        String localPid = this.getProcessId();
        ((ControllableServerBehavior)this.getControllableBehavior()).setServerStopped();
        if (localPid != null) {
            try {
                RSEHostShellModel.ServerShellModel model = RSEHostShellModel.getInstance().getModel(this.getServer());
                String cmd = "kill -9 " + localPid;
                model.executeRemoteCommand("/", cmd, new String[0], (IProgressMonitor)new NullProgressMonitor(), 2000, true);
            }
            catch (CoreException ce) {
                RSECorePlugin.pluginLog().logStatus((IStatus)new Status(4, "org.jboss.ide.eclipse.as.rse.core", "Unable to terminate remote process " + localPid, (Throwable)ce));
            }
        }
        this.clearProcessId();
        ((ControllableServerBehavior)this.getControllableBehavior()).putSharedData("DeployableServerBehavior.RequiresForceStop", (Object)false);
    }

    protected String getProcessId() {
        return (String)this.getControllableBehavior().getSharedData("DeployableServerBehavior.Process_ID");
    }

    protected void clearProcessId() {
        this.getControllableBehavior().putSharedData("DeployableServerBehavior.Process_ID", null);
    }
}

