/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.management.stats;

import org.apache.servicemix.nmr.management.stats.Statistic;

public class TimeStatistic
extends Statistic {
    private long maxTime;
    private long minTime;
    private long totalTime;
    private TimeStatistic parent;

    public TimeStatistic(String name, String description) {
        this(name, "millis", description);
    }

    public TimeStatistic(TimeStatistic parent, String name, String description) {
        this(name, description);
        this.parent = parent;
    }

    public TimeStatistic(String name, String unit, String description) {
        super(name, unit, description);
    }

    public synchronized void reset() {
        super.reset();
        this.maxTime = 0L;
        this.minTime = 0L;
        this.totalTime = 0L;
    }

    public synchronized void updateValue(long time) {
        this.updateSampleTime();
        this.updateUpdateCount();
        this.totalTime += time;
        if (time > this.maxTime) {
            this.maxTime = time;
        }
        if (time < this.minTime || this.minTime == 0L) {
            this.minTime = time;
        }
        if (this.parent != null) {
            this.parent.updateValue(time);
        }
    }

    public synchronized void increment() {
        long time = this.getLastSampleTime();
        this.updateSampleTime();
        this.updateUpdateCount();
        time = this.getLastSampleTime() - time;
        this.totalTime += time;
        if (time > this.maxTime) {
            this.maxTime = time;
        }
        if (time < this.minTime || this.minTime == 0L) {
            this.minTime = time;
        }
        if (this.parent != null) {
            this.parent.updateValue(time);
        }
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public synchronized long getMinTime() {
        return this.minTime;
    }

    public synchronized long getValue() {
        return this.totalTime;
    }

    public synchronized double getAverageTime() {
        if (this.updateCount.get() == 0L) {
            return 0.0;
        }
        double d = this.totalTime;
        return d / (double)this.updateCount.get();
    }

    public synchronized double getAverageTimeExcludingMinMax() {
        if (this.updateCount.get() <= 2L) {
            return 0.0;
        }
        double d = this.totalTime - this.minTime - this.maxTime;
        return d / (double)(this.updateCount.incrementAndGet() - 2L);
    }

    public double getAveragePerSecond() {
        double d = 1000.0;
        double averageTime = this.getAverageTime();
        if (averageTime == 0.0) {
            return 0.0;
        }
        return d / averageTime;
    }

    public double getAveragePerSecondExcludingMinMax() {
        double d = 1000.0;
        double average = this.getAverageTimeExcludingMinMax();
        if (average == 0.0) {
            return 0.0;
        }
        return d / average;
    }

    public TimeStatistic getParent() {
        return this.parent;
    }

    public void setParent(TimeStatistic parent) {
        this.parent = parent;
    }

    protected synchronized void appendFieldDescription(StringBuffer buffer) {
        buffer.append(" update count: ");
        buffer.append(Long.toString(this.updateCount.get()));
        buffer.append(" maxTime: ");
        buffer.append(Long.toString(this.maxTime));
        buffer.append(" minTime: ");
        buffer.append(Long.toString(this.minTime));
        buffer.append(" totalTime: ");
        buffer.append(Long.toString(this.totalTime));
        buffer.append(" averageTime: ");
        buffer.append(Double.toString(this.getAverageTime()));
        buffer.append(" averageTimeExMinMax: ");
        buffer.append(Double.toString(this.getAverageTimeExcludingMinMax()));
        buffer.append(" averagePerSecond: ");
        buffer.append(Double.toString(this.getAveragePerSecond()));
        buffer.append(" averagePerSecondExMinMax: ");
        buffer.append(Double.toString(this.getAveragePerSecondExcludingMinMax()));
        super.appendFieldDescription(buffer);
    }
}

