/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.management;

import java.util.Map;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.management.ManagedEndpointMBean;
import org.fusesource.commons.management.ManagementStrategy;
import org.fusesource.commons.management.Statistic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedEndpoint
extends StandardMBean
implements ManagedEndpointMBean {
    protected final InternalEndpoint endpoint;
    protected final Statistic inboundExchanges;
    protected final Statistic outboundExchanges;
    protected final Statistic inboundExchangeRate;
    protected final Statistic outboundExchangeRate;
    protected final ManagementStrategy managementStrategy;

    public ManagedEndpoint(InternalEndpoint endpoint, ManagementStrategy managementStrategy) throws NotCompliantMBeanException {
        super(ManagedEndpointMBean.class);
        this.endpoint = endpoint;
        this.managementStrategy = managementStrategy;
        this.inboundExchanges = managementStrategy.createStatistic("inboundExchanges", (Object)this, Statistic.UpdateMode.VALUE);
        this.inboundExchangeRate = managementStrategy.createStatistic("inboundExchangeRate", (Object)this, Statistic.UpdateMode.COUNTER);
        this.outboundExchanges = managementStrategy.createStatistic("outboundExchanges", (Object)this, Statistic.UpdateMode.VALUE);
        this.outboundExchangeRate = managementStrategy.createStatistic("outboundExchangeRate", (Object)this, Statistic.UpdateMode.COUNTER);
    }

    public InternalEndpoint getEndpoint() {
        return this.endpoint;
    }

    void incrementInbound() {
        this.inboundExchanges.increment();
        this.inboundExchangeRate.increment();
    }

    void incrementOutbound() {
        this.outboundExchanges.increment();
        this.outboundExchangeRate.increment();
    }

    @Override
    public String getName() {
        return (String)this.getProperties().get("NAME");
    }

    @Override
    public Map<String, ?> getProperties() {
        return this.endpoint.getMetaData();
    }

    @Override
    public long getInboundExchangeCount() {
        return this.inboundExchanges.getUpdateCount();
    }

    @Override
    public double getInboundExchangeRate() {
        return this.getRate(this.inboundExchangeRate);
    }

    @Override
    public long getOutboundExchangeCount() {
        return this.outboundExchanges.getUpdateCount();
    }

    @Override
    public double getOutboundExchangeRate() {
        return this.getRate(this.outboundExchangeRate);
    }

    @Override
    public void reset() {
        this.inboundExchanges.reset();
        this.outboundExchanges.reset();
        this.inboundExchangeRate.reset();
        this.outboundExchangeRate.reset();
    }

    private synchronized double getRate(Statistic stat) {
        if (stat.getUpdateCount() == 0L) {
            return 0.0;
        }
        double d = stat.getValue();
        return d / (double)stat.getUpdateCount();
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return "Managed Endpoint";
    }

    @Override
    protected String getDescription(MBeanFeatureInfo info) {
        if ("name".equalsIgnoreCase(info.getName())) {
            return "Name of the endpoint";
        }
        if ("properties".equalsIgnoreCase(info.getName())) {
            return "Properties associated to this endpoint";
        }
        if ("inboundExchangeCount".equalsIgnoreCase(info.getName())) {
            return "Number of exchanges received";
        }
        if ("inboundExchangeCount".equalsIgnoreCase(info.getName())) {
            return "Number of exchanges received";
        }
        if ("inboundExchangeRate".equalsIgnoreCase(info.getName())) {
            return "Exchanges received per second";
        }
        if ("outboundExchangeCount".equalsIgnoreCase(info.getName())) {
            return "Number of exchanges sent";
        }
        if ("outboundExchangeRate".equalsIgnoreCase(info.getName())) {
            return "Exchanges sent per second";
        }
        if ("reset".equalsIgnoreCase(info.getName())) {
            return "Reset statistics";
        }
        return null;
    }
}

