/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record.json;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.CollectionGroupingElementNodeValue;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.MediaType;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.record.AbstractUnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.SAXUnmarshallerHandler;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.XMLReaderAdapter;
import org.eclipse.persistence.internal.oxm.record.deferred.DeferredContentHandler;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.record.XMLRootRecord;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JsonStructureReader
extends XMLReaderAdapter {
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private String attributePrefix = null;
    private NamespaceResolver namespaces = null;
    private boolean includeRoot;
    private String textWrapper;
    private Class unmarshalClass;
    private boolean isInCollection;
    private JsonStructure jsonStructure;
    private JsonAttributes attributes = new JsonAttributes();

    public JsonStructureReader(Unmarshaller u) {
        this(u, null);
    }

    public JsonStructureReader(Unmarshaller u, Class clazz) {
        this(u.getAttributePrefix(), u.getNamespaceResolver(), u.getNamespaceResolver() != null, u.isIncludeRoot(), Character.valueOf(u.getNamespaceSeparator()), u.getErrorHandler(), u.getValueWrapper(), clazz);
    }

    private JsonStructureReader(String attrPrefix, NamespaceResolver nr, boolean namespaceAware, boolean includeRoot, Character namespaceSeparator, ErrorHandler errorHandler, String textWrapper, Class unmarshalClass) {
        this.attributePrefix = attrPrefix;
        if (this.attributePrefix == "") {
            this.attributePrefix = null;
        }
        this.namespaces = nr;
        this.namespaceAware = namespaceAware;
        this.namespaceSeparator = namespaceSeparator == null ? (char)46 : namespaceSeparator.charValue();
        this.includeRoot = includeRoot;
        this.setErrorHandler(errorHandler);
        this.textWrapper = textWrapper;
        this.unmarshalClass = unmarshalClass;
    }

    public void setJsonStructure(JsonStructure jsonStructure) {
        this.jsonStructure = jsonStructure;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException, JsonException {
        if (input == null) {
            if (this.jsonStructure != null) {
                this.parseRoot((JsonValue)this.jsonStructure);
            }
            return;
        }
        try {
            InputStream inputStream = null;
            JsonReader jsonReader = null;
            if (input.getByteStream() != null) {
                inputStream = input.getByteStream();
                jsonReader = Json.createReader((Reader)new InputStreamReader(inputStream));
            } else if (input.getCharacterStream() != null) {
                jsonReader = Json.createReader((Reader)input.getCharacterStream());
            } else {
                try {
                    URL url = new URL(input.getSystemId());
                    inputStream = url.openStream();
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        inputStream = new FileInputStream(input.getSystemId());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw malformedURLException;
                    }
                }
                jsonReader = Json.createReader((Reader)new InputStreamReader(inputStream));
            }
            if (jsonReader != null) {
                JsonStructure structure = jsonReader.read();
                this.parseRoot((JsonValue)structure);
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (JsonException je) {
            throw XMLMarshalException.unmarshalException((Exception)((Object)je));
        }
    }

    @Override
    public void parse(String systemId) {
        try {
            this.parse(new InputSource(systemId));
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    public void parseRoot(JsonValue jsonValue) throws SAXException {
        if (this.namespaces != null) {
            Map<String, String> namespacePairs = this.namespaces.getPrefixesToNamespaces();
            for (String nextKey : namespacePairs.keySet()) {
                this.contentHandler.startPrefixMapping(nextKey, namespacePairs.get(nextKey));
            }
        }
        if (jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
            this.contentHandler.startDocument();
            JsonObject jsonObject = (JsonObject)jsonValue;
            Set children = jsonObject.entrySet();
            if (children == null || children.size() == 0 && this.unmarshalClass == null) {
                return;
            }
            Iterator iter = children.iterator();
            if (this.includeRoot) {
                if (children.size() > 0) {
                    Map.Entry nextEntry = (Map.Entry)iter.next();
                    this.parsePair((String)nextEntry.getKey(), (JsonValue)nextEntry.getValue());
                }
            } else {
                this.contentHandler.startElement("", "", null, this.attributes.setValue(jsonValue, this.attributePrefix, this.namespaces, this.namespaceSeparator, this.namespaceAware));
                while (iter.hasNext()) {
                    Map.Entry nextEntry = (Map.Entry)iter.next();
                    this.parsePair((String)nextEntry.getKey(), (JsonValue)nextEntry.getValue());
                }
                this.contentHandler.endElement("", "", null);
            }
            this.contentHandler.endDocument();
        } else if (jsonValue.getValueType() == JsonValue.ValueType.ARRAY) {
            SAXUnmarshallerHandler rootContentHandler = null;
            if (this.getContentHandler() instanceof SAXUnmarshallerHandler) {
                rootContentHandler = (SAXUnmarshallerHandler)this.getContentHandler();
            }
            JsonArray jsonArray = (JsonArray)jsonValue;
            int size = jsonArray.size();
            ArrayList<Object> list = new ArrayList<Object>(size);
            int x = 0;
            while (x < size) {
                this.parseRoot((JsonValue)jsonArray.get(x));
                if (this.getContentHandler() instanceof SAXUnmarshallerHandler) {
                    SAXUnmarshallerHandler saxUnmarshallerHandler = (SAXUnmarshallerHandler)this.contentHandler;
                    list.add(saxUnmarshallerHandler.getObject());
                    saxUnmarshallerHandler.setObject(null);
                } else if (this.getContentHandler() instanceof UnmarshalRecord) {
                    UnmarshalRecord unmarshalRecord = (UnmarshalRecord)this.contentHandler;
                    Object unmarshalledObject = unmarshalRecord.getCurrentObject();
                    if (this.includeRoot && this.unmarshalClass != null && !(unmarshalledObject instanceof Root)) {
                        Root xmlRoot = unmarshalRecord.createRoot();
                        xmlRoot.setNamespaceURI(unmarshalRecord.getRootElementNamespaceUri());
                        xmlRoot.setLocalName(unmarshalRecord.getLocalName());
                        xmlRoot.setObject(unmarshalledObject);
                        unmarshalledObject = xmlRoot;
                    }
                    list.add(unmarshalledObject);
                    unmarshalRecord.setCurrentObject(null);
                    unmarshalRecord.setRootElementName(null);
                    unmarshalRecord.setLocalName(null);
                }
                ++x;
            }
            if (this.getContentHandler() instanceof SAXUnmarshallerHandler) {
                ((SAXUnmarshallerHandler)this.getContentHandler()).setObject(list);
            } else if (this.getContentHandler() instanceof UnmarshalRecord) {
                ((UnmarshalRecord)this.getContentHandler()).setCurrentObject(list);
                ((UnmarshalRecord)this.getContentHandler()).setRootElementName("");
                ((UnmarshalRecord)this.getContentHandler()).setLocalName("");
                if (rootContentHandler != null) {
                    rootContentHandler.setObject(list);
                }
            }
        }
    }

    private void parseValue(JsonValue jsonValue) throws SAXException {
        block3: {
            JsonValue.ValueType valueType;
            block7: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                valueType = jsonValue.getValueType();
                                if (valueType != JsonValue.ValueType.STRING) break block2;
                                String string = ((JsonString)jsonValue).getString();
                                this.contentHandler.characters(string);
                                break block3;
                            }
                            if (valueType != JsonValue.ValueType.FALSE) break block4;
                            this.contentHandler.characters(FALSE);
                            break block3;
                        }
                        if (valueType != JsonValue.ValueType.TRUE) break block5;
                        this.contentHandler.characters(TRUE);
                        break block3;
                    }
                    if (valueType == JsonValue.ValueType.NULL) break block3;
                    if (valueType != JsonValue.ValueType.NUMBER) break block6;
                    JsonNumber number = (JsonNumber)jsonValue;
                    this.contentHandler.characters(number.toString());
                    break block3;
                }
                if (valueType != JsonValue.ValueType.OBJECT) break block7;
                JsonObject childObject = (JsonObject)jsonValue;
                for (Map.Entry nextEntry : childObject.entrySet()) {
                    this.parsePair((String)nextEntry.getKey(), (JsonValue)nextEntry.getValue());
                }
                break block3;
            }
            if (valueType != JsonValue.ValueType.ARRAY) break block3;
            JsonArray childArray = (JsonArray)jsonValue;
            int size = childArray.size();
            new ArrayList(size);
            int x = 0;
            while (x < size) {
                JsonValue nextArrayValue = (JsonValue)childArray.get(x);
                this.parseValue(nextArrayValue);
                ++x;
            }
        }
    }

    private void parsePair(String name, JsonValue jsonValue) throws SAXException {
        if (jsonValue == null) {
            return;
        }
        JsonValue.ValueType valueType = jsonValue.getValueType();
        if (valueType == JsonValue.ValueType.ARRAY) {
            UnmarshalRecord ur;
            XPathNode node;
            JsonArray jsonArray = (JsonArray)jsonValue;
            String parentLocalName = name;
            if (this.attributePrefix != null && parentLocalName.startsWith(this.attributePrefix)) {
                return;
            }
            String uri = "";
            if (this.namespaceAware && this.namespaces != null) {
                if (parentLocalName.length() > 2) {
                    int nsIndex = parentLocalName.indexOf(this.namespaceSeparator, 1);
                    if (nsIndex > -1) {
                        String prefix = parentLocalName.substring(0, nsIndex);
                        uri = this.namespaces.resolveNamespacePrefix(prefix);
                    }
                    if (uri == null) {
                        uri = this.namespaces.getDefaultNamespaceURI();
                    } else {
                        parentLocalName = parentLocalName.substring(nsIndex + 1);
                    }
                } else {
                    uri = this.namespaces.getDefaultNamespaceURI();
                }
            }
            boolean isTextValue = this.isTextValue(parentLocalName);
            int arraySize = jsonArray.size();
            if (arraySize == 0 && this.contentHandler instanceof UnmarshalRecord && (node = (ur = (UnmarshalRecord)this.contentHandler).getNonAttributeXPathNode(uri, parentLocalName, parentLocalName, null)) != null) {
                NodeValue nv = node.getNodeValue();
                if (nv == null && node.getTextNode() != null) {
                    nv = node.getTextNode().getUnmarshalNodeValue();
                }
                if (nv != null && nv.isContainerValue()) {
                    ur.getContainerInstance((ContainerValue)((Object)nv));
                }
            }
            this.startCollection();
            XPathFragment groupingXPathFragment = null;
            XPathFragment itemXPathFragment = null;
            if (this.contentHandler instanceof UnmarshalRecord) {
                XPathNode unmarshalRecordXPathNode;
                UnmarshalRecord unmarshalRecord = (UnmarshalRecord)this.contentHandler;
                if (((Unmarshaller)unmarshalRecord.getUnmarshaller()).isWrapperAsCollectionName() && (unmarshalRecordXPathNode = unmarshalRecord.getXPathNode()) != null) {
                    XPathFragment currentFragment = new XPathFragment();
                    currentFragment.setLocalName(parentLocalName);
                    currentFragment.setNamespaceURI(uri);
                    currentFragment.setNamespaceAware(this.namespaceAware);
                    XPathNode groupingXPathNode = unmarshalRecordXPathNode.getNonAttributeChildrenMap().get(currentFragment);
                    if (groupingXPathNode != null) {
                        XPathNode itemXPathNode;
                        if (groupingXPathNode.getUnmarshalNodeValue() instanceof CollectionGroupingElementNodeValue) {
                            groupingXPathFragment = groupingXPathNode.getXPathFragment();
                            this.contentHandler.startElement(uri, parentLocalName, parentLocalName, new AttributesImpl());
                            itemXPathNode = groupingXPathNode.getNonAttributeChildren().get(0);
                            itemXPathFragment = itemXPathNode.getXPathFragment();
                        } else if (groupingXPathNode.getUnmarshalNodeValue() == null && (itemXPathNode = groupingXPathNode.getNonAttributeChildren().get(0)) != null && ((MappingNodeValue)itemXPathNode.getUnmarshalNodeValue()).isContainerValue()) {
                            groupingXPathFragment = groupingXPathNode.getXPathFragment();
                            this.contentHandler.startElement(uri, parentLocalName, parentLocalName, new AttributesImpl());
                            itemXPathFragment = itemXPathNode.getXPathFragment();
                        }
                    }
                }
                int i = 0;
                while (i < arraySize) {
                    JsonValue nextArrayValue = (JsonValue)jsonArray.get(i);
                    if (nextArrayValue.getValueType() == JsonValue.ValueType.NULL) {
                        ((UnmarshalRecord)this.contentHandler).setNil(true);
                    }
                    if (!isTextValue) {
                        if (itemXPathFragment != null) {
                            this.contentHandler.startElement(itemXPathFragment.getNamespaceURI(), itemXPathFragment.getLocalName(), itemXPathFragment.getLocalName(), this.attributes.setValue(nextArrayValue, this.attributePrefix, this.namespaces, this.namespaceSeparator, this.namespaceAware));
                        } else {
                            this.contentHandler.startElement(uri, parentLocalName, parentLocalName, this.attributes.setValue(nextArrayValue, this.attributePrefix, this.namespaces, this.namespaceSeparator, this.namespaceAware));
                        }
                    }
                    this.parseValue(nextArrayValue);
                    if (!isTextValue) {
                        if (itemXPathFragment != null) {
                            this.contentHandler.endElement(itemXPathFragment.getNamespaceURI(), itemXPathFragment.getLocalName(), itemXPathFragment.getLocalName());
                        } else {
                            this.contentHandler.endElement(uri, parentLocalName, parentLocalName);
                        }
                    }
                    ++i;
                }
            }
            if (groupingXPathFragment != null) {
                this.contentHandler.endElement(uri, groupingXPathFragment.getLocalName(), groupingXPathFragment.getLocalName());
            }
            this.endCollection();
        } else {
            String qualifiedName = name;
            if (this.attributePrefix != null && qualifiedName.startsWith(this.attributePrefix)) {
                return;
            }
            String localName = qualifiedName;
            String uri = "";
            if (this.namespaceAware && this.namespaces != null) {
                if (localName.length() > 2) {
                    int nsIndex = localName.indexOf(this.namespaceSeparator, 1);
                    String prefix = "";
                    if (nsIndex > -1) {
                        prefix = localName.substring(0, nsIndex);
                    }
                    if ((uri = this.namespaces.resolveNamespacePrefix(prefix)) == null) {
                        uri = this.namespaces.getDefaultNamespaceURI();
                    } else {
                        localName = localName.substring(nsIndex + 1);
                    }
                    if (localName.equals("type") && uri != null && uri.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                        return;
                    }
                } else {
                    uri = this.namespaces.getDefaultNamespaceURI();
                }
            }
            if (this.contentHandler instanceof XMLRootRecord || this.contentHandler instanceof DeferredContentHandler) {
                if (!this.namespaceAware && localName.equals("type")) {
                    return;
                }
                if (this.textWrapper != null && this.textWrapper.equals(localName)) {
                    this.parseValue(jsonValue);
                    return;
                }
            } else if (this.contentHandler instanceof UnmarshalRecord && ((UnmarshalRecord)this.contentHandler).getXPathNode() != null) {
                if (!this.namespaceAware && localName.equals("type") && !((UnmarshalRecord)this.contentHandler).getXPathNode().hasTypeChild()) {
                    return;
                }
                boolean isTextValue = this.isTextValue(localName);
                if (isTextValue) {
                    this.parseValue(jsonValue);
                    return;
                }
            }
            if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.NULL) {
                this.contentHandler.setNil(true);
            }
            this.contentHandler.startElement(uri, localName, localName, this.attributes.setValue(jsonValue, this.attributePrefix, this.namespaces, this.namespaceSeparator, this.namespaceAware));
            this.parseValue(jsonValue);
            this.contentHandler.endElement(uri, localName, localName);
        }
    }

    @Override
    public boolean isNullRepresentedByXsiNil(AbstractNullPolicy nullPolicy) {
        return true;
    }

    private void startCollection() {
        this.isInCollection = true;
    }

    private void endCollection() {
        this.isInCollection = false;
    }

    @Override
    public boolean isInCollection() {
        return this.isInCollection;
    }

    private boolean isTextValue(String localName) {
        XPathNode currentNode = ((UnmarshalRecord)this.contentHandler).getXPathNode();
        if (currentNode == null) {
            return this.textWrapper != null && this.textWrapper.equals(localName);
        }
        return (currentNode.getNonAttributeChildrenMap() == null || currentNode.getNonAttributeChildrenMap().size() == 0 || currentNode.getNonAttributeChildrenMap().size() == 1 && currentNode.getTextNode() != null) && this.textWrapper != null && this.textWrapper.equals(localName);
    }

    @Override
    public Object convertValueBasedOnSchemaType(Field xmlField, Object value, ConversionManager conversionManager, AbstractUnmarshalRecord record) {
        if (xmlField.getSchemaType() != null) {
            if (Constants.QNAME_QNAME.equals(xmlField.getSchemaType())) {
                String stringValue = (String)value;
                int indexOpen = stringValue.indexOf(123);
                int indexClose = stringValue.indexOf(125);
                String uri = null;
                String localName = null;
                if (indexOpen > -1 && indexClose > -1) {
                    uri = stringValue.substring(indexOpen + 1, indexClose);
                    localName = stringValue.substring(indexClose + 1);
                } else {
                    QName obj = (QName)xmlField.convertValueBasedOnSchemaType(stringValue, conversionManager, record);
                    localName = obj.getLocalPart();
                    uri = obj.getNamespaceURI();
                }
                if (uri != null) {
                    return new QName(uri, localName);
                }
                return new QName(localName);
            }
            Class fieldType = xmlField.getType();
            if (fieldType == null) {
                fieldType = xmlField.getJavaClass(xmlField.getSchemaType(), conversionManager);
            }
            return conversionManager.convertObject(value, fieldType, xmlField.getSchemaType());
        }
        return value;
    }

    @Override
    public MediaType getMediaType() {
        return Constants.APPLICATION_JSON;
    }

    private static class JsonAttributes
    extends XMLReaderAdapter.IndexedAttributeList {
        private JsonValue value;
        private String attributePrefix;
        private char namespaceSeparator;
        private NamespaceResolver namespaces;
        private boolean namespaceAware;

        private JsonAttributes() {
        }

        public JsonAttributes setValue(JsonValue value, String attributePrefix, NamespaceResolver nr, char namespaceSeparator, boolean namespaceAware) {
            this.reset();
            this.value = value;
            this.attributePrefix = attributePrefix;
            this.namespaces = nr;
            this.namespaceSeparator = namespaceSeparator;
            this.namespaceAware = namespaceAware;
            return this;
        }

        private void addSimpleAttribute(List attributes, String uri, String attributeLocalName, JsonValue childValue) {
            if (childValue.getValueType() == JsonValue.ValueType.STRING) {
                String stringValue = ((JsonString)childValue).getString();
                attributes.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, stringValue));
            } else if (childValue.getValueType() == JsonValue.ValueType.NUMBER) {
                attributes.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, ((JsonNumber)childValue).toString()));
            } else if (childValue.getValueType() == JsonValue.ValueType.NULL) {
                attributes.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, ""));
            } else if (childValue.getValueType() == JsonValue.ValueType.FALSE) {
                attributes.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, JsonStructureReader.FALSE));
            } else if (childValue.getValueType() == JsonValue.ValueType.TRUE) {
                attributes.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, JsonStructureReader.TRUE));
            }
        }

        @Override
        public int getIndex(String uri, String localName) {
            if (localName == null) {
                return -1;
            }
            int index = 0;
            XMLReaderAdapter.Attribute[] attributeArray = this.attributes();
            int n = attributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                XMLReaderAdapter.Attribute attribute = attributeArray[n2];
                if (this.namespaceAware) {
                    new QName(uri, localName);
                    if (localName.equals(attribute.getLocalName()) && uri.equals(attribute.getUri())) {
                        return index;
                    }
                } else if (attribute.getName().equals(localName)) {
                    return index;
                }
                ++index;
                ++n2;
            }
            return -1;
        }

        @Override
        protected XMLReaderAdapter.Attribute[] attributes() {
            if (this.attributes == null) {
                if (this.value.getValueType() == JsonValue.ValueType.NULL) {
                    return NO_ATTRIBUTES;
                }
                if (this.value.getValueType() == JsonValue.ValueType.OBJECT) {
                    JsonObject jsonObject = (JsonObject)this.value;
                    ArrayList<XMLReaderAdapter.Attribute> attributesList = new ArrayList<XMLReaderAdapter.Attribute>(jsonObject.values().size());
                    for (Map.Entry nextEntry : jsonObject.entrySet()) {
                        JsonValue nextValue = (JsonValue)nextEntry.getValue();
                        String attributeLocalName = (String)nextEntry.getKey();
                        if (this.attributePrefix != null) {
                            if (!attributeLocalName.startsWith(this.attributePrefix)) break;
                            attributeLocalName = attributeLocalName.substring(this.attributePrefix.length());
                        }
                        String uri = "";
                        if (this.namespaceAware && this.namespaces != null) {
                            if (attributeLocalName.length() > 2) {
                                String prefix = "";
                                int nsIndex = attributeLocalName.indexOf(this.namespaceSeparator, 1);
                                if (nsIndex > -1) {
                                    prefix = attributeLocalName.substring(0, nsIndex);
                                }
                                if ((uri = this.namespaces.resolveNamespacePrefix(prefix)) == null) {
                                    uri = this.namespaces.getDefaultNamespaceURI();
                                } else {
                                    attributeLocalName = attributeLocalName.substring(nsIndex + 1);
                                }
                            } else {
                                uri = this.namespaces.getDefaultNamespaceURI();
                            }
                        }
                        if (nextValue.getValueType() == JsonValue.ValueType.ARRAY) {
                            JsonArray jsonArray = (JsonArray)nextValue;
                            if (jsonArray.size() == 0) {
                                attributesList.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, ""));
                            }
                            int y = 0;
                            while (y < jsonArray.size()) {
                                JsonValue nextChildValue = (JsonValue)jsonArray.get(y);
                                this.addSimpleAttribute(attributesList, uri, attributeLocalName, nextChildValue);
                                ++y;
                            }
                            continue;
                        }
                        this.addSimpleAttribute(attributesList, uri, attributeLocalName, nextValue);
                    }
                    this.attributes = attributesList.toArray(new XMLReaderAdapter.Attribute[attributesList.size()]);
                } else {
                    this.attributes = NO_ATTRIBUTES;
                }
            }
            return this.attributes;
        }
    }
}

