/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.ide.eclipse.as.core.server.IJBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.rse.ui.DeployOnlyRSEPrefComposite;
import org.jboss.ide.eclipse.as.rse.ui.JBoss7RSEDeploymentPrefComposite;
import org.jboss.ide.eclipse.as.rse.ui.JBossRSEDeploymentPrefComposite;
import org.jboss.ide.eclipse.as.ui.JBossServerUISharedImages;
import org.jboss.ide.eclipse.as.ui.editor.DeploymentTypeUIUtil;
import org.jboss.ide.eclipse.as.ui.editor.IDeploymentTypeUI;

public class RSEWizardFragment
extends WizardFragment {
    private IWizardHandle handle;

    protected void initWizardHandle() {
        this.handle.setTitle("Remote System Integration");
        this.handle.setDescription("Please set the properties required for connecting to a remote system.");
        String imageKey = "jbossLogo";
        this.handle.setImageDescriptor(JBossServerUISharedImages.getImageDescriptor((String)imageKey));
    }

    public boolean hasComposite() {
        return true;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        this.initWizardHandle();
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new FillLayout());
        IServerWorkingCopy cServer = (IServerWorkingCopy)this.getTaskModel().getObject("server");
        IJBossServer jbs = cServer.getOriginal() == null ? ServerConverter.getJBossServer((IServerWorkingCopy)cServer) : ServerConverter.getJBossServer((IServer)cServer.getOriginal());
        ServerExtendedProperties sep = ExtendedServerPropertiesAdapterFactory.getServerExtendedProperties((IServerAttributes)cServer);
        IDeploymentTypeUI.IServerModeUICallback callback = this.createLegacyCallback(handle);
        if (jbs == null || sep == null) {
            new DeployOnlyRSEPrefComposite(main, 0, callback);
        } else if (sep.getFileStructure() == 1) {
            new JBossRSEDeploymentPrefComposite(main, 0, callback);
        } else if (sep.getFileStructure() == 2) {
            new JBoss7RSEDeploymentPrefComposite(main, 0, callback);
        }
        return main;
    }

    private IDeploymentTypeUI.IServerModeUICallback createLegacyCallback(IWizardHandle handle) {
        return DeploymentTypeUIUtil.getCallback((TaskModel)this.getTaskModel(), (IWizardHandle)handle, (DeploymentTypeUIUtil.ICompletable)new DeploymentTypeUIUtil.ICompletable(){

            public void setComplete(boolean complete) {
                RSEWizardFragment.this.setComplete(complete);
            }
        });
    }
}

