/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.jboss.ide.eclipse.as.core.server.internal.DeployableServer;
import org.jboss.ide.eclipse.as.core.util.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.UIUtil;
import org.jboss.ide.eclipse.as.wtp.ui.editor.ServerWorkingCopyPropertyButtonCommand;
import org.jboss.ide.eclipse.as.wtp.ui.editor.ServerWorkingCopyPropertyCommand;

public class ModuleRestartSection
extends ServerEditorSection {
    private Button customizePattern;
    private Text restartPatternText;
    private SelectionListener checkboxListener;
    private ModifyListener textListener;
    protected ServerAttributeHelper helper;

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.helper = new ServerAttributeHelper(this.server.getOriginal(), this.server);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        this.createUI(parent);
        DeployableServer ds = (DeployableServer)ServerConverter.getDeployableServer((IServerAttributes)this.server.getOriginal());
        String defaultPattern = ds.getDefaultModuleRestartPattern();
        String pattern = this.server.getAttribute("org.jboss.tools.as.restartFilePattern", defaultPattern);
        this.customizePattern.setSelection(!defaultPattern.equals(pattern));
        this.restartPatternText.setEnabled(!defaultPattern.equals(pattern));
        this.restartPatternText.setText(pattern == null ? defaultPattern : pattern);
        this.addListeners();
    }

    protected void createUI(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 322);
        section.setText("Application Reload Behavior");
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new FormLayout());
        this.customizePattern = toolkit.createButton(composite, "Customize application reload behavior on changes to project resources", 32);
        this.customizePattern.setLayoutData((Object)UIUtil.createFormData2((Object)0, (int)5, null, (int)0, (Object)0, (int)5, null, (int)0));
        Label l = toolkit.createLabel(composite, "Force module restart on following regex pattern: ");
        l.setLayoutData((Object)UIUtil.createFormData2((Object)this.customizePattern, (int)5, null, (int)0, (Object)0, (int)5, null, (int)0));
        this.restartPatternText = toolkit.createText(composite, "");
        this.restartPatternText.setLayoutData((Object)UIUtil.createFormData2((Object)l, (int)5, null, (int)0, (Object)0, (int)5, (Object)100, (int)-5));
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
    }

    protected void addListeners() {
        this.checkboxListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ModuleRestartSection.this.execute((IUndoableOperation)new SetCustomizePatternCommand(ModuleRestartSection.this.server));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.textListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModuleRestartSection.this.execute((IUndoableOperation)new SetCustomPatternCommand(ModuleRestartSection.this.server));
            }
        };
        this.customizePattern.addSelectionListener(this.checkboxListener);
        this.restartPatternText.addModifyListener(this.textListener);
    }

    public class SetCustomPatternCommand
    extends ServerWorkingCopyPropertyCommand {
        public SetCustomPatternCommand(IServerWorkingCopy server) {
            super(server, "Modify Module Restart Pattern", ModuleRestartSection.this.restartPatternText, ModuleRestartSection.this.restartPatternText.getText(), "org.jboss.tools.as.restartFilePattern", ModuleRestartSection.this.textListener);
        }

        public void undo() {
            super.undo();
            this.validate();
        }

        public void execute() {
            super.execute();
            this.validate();
        }

        protected void validate() {
            try {
                Pattern.compile(ModuleRestartSection.this.restartPatternText.getText(), 2);
                ModuleRestartSection.this.setErrorMessage(null);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                ModuleRestartSection.this.setErrorMessage("Invalid Restart Pattern: " + ModuleRestartSection.this.restartPatternText.getText());
            }
        }
    }

    public class SetCustomizePatternCommand
    extends ServerWorkingCopyPropertyButtonCommand {
        public SetCustomizePatternCommand(IServerWorkingCopy server) {
            super(server, Messages.EditorChangeStartPollerCommandName, ModuleRestartSection.this.customizePattern, ModuleRestartSection.this.customizePattern.getSelection(), null, ModuleRestartSection.this.checkboxListener);
        }

        public void execute() {
            super.execute();
            ModuleRestartSection.this.restartPatternText.setEnabled(ModuleRestartSection.this.customizePattern.getSelection());
        }

        public void undo() {
            super.undo();
            ModuleRestartSection.this.restartPatternText.setEnabled(ModuleRestartSection.this.customizePattern.getSelection());
        }
    }
}

