/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathCategory;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathFileResult;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathModel;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathQuery;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.dialogs.XPathDialogs;

public class ChangePortDialog
extends TitleAreaDialog {
    private static final int RESTORE_DEFAULT = 35;
    private boolean modified = false;
    private ChangePortDialogInfo info;
    private String selected;
    private XPathQuery currentQuery;
    private XPathQuery[] allQueries;
    private boolean queriesLoaded = false;
    private List listWidget;
    private Label currentValue;
    private Text currentValueText;
    private Button editXPathButton;

    public ChangePortDialog(Shell parentShell, ChangePortDialogInfo info) {
        super(parentShell);
        this.info = info;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        Composite main = new Composite(c, 2048);
        main.setLayoutData((Object)new GridData(1808));
        main.setLayout((Layout)new FormLayout());
        this.createUI(main);
        this.fillWidgets();
        this.addListeners();
        this.setTitle(this.info.port);
        this.setMessage(this.info.description != null ? this.info.description : Messages.EditorCPD_DefaultDescription);
        this.getShell().setText(this.info.shellTitle != null ? this.info.shellTitle : Messages.EditorCPD_DefaultShellTitle);
        this.selectionChanged();
        return c;
    }

    protected void createUI(Composite main) {
        this.listWidget = new List(main, -1);
        FormData d = new FormData();
        d.top = new FormAttachment(0, 5);
        d.left = new FormAttachment(0, 5);
        d.bottom = new FormAttachment(100, -5);
        d.right = new FormAttachment(0, 150);
        this.listWidget.setLayoutData((Object)d);
        this.currentValue = new Label(main, 0);
        d = new FormData();
        d.left = new FormAttachment((Control)this.listWidget, 5);
        d.top = new FormAttachment(0, 7);
        this.currentValue.setLayoutData((Object)d);
        this.currentValue.setText(Messages.EditorCPD_Value);
        this.editXPathButton = new Button(main, 0);
        d = new FormData();
        d.right = new FormAttachment(100, -5);
        d.top = new FormAttachment((Control)this.currentValue, 5);
        this.editXPathButton.setLayoutData((Object)d);
        this.editXPathButton.setText(Messages.DescriptorXPathEditXPath);
        this.currentValueText = new Text(main, -1);
        d = new FormData();
        d.left = new FormAttachment((Control)this.listWidget, 5);
        d.right = new FormAttachment((Control)this.editXPathButton, -5);
        d.top = new FormAttachment((Control)this.currentValue, 5);
        this.currentValueText.setLayoutData((Object)d);
        this.currentValueText.setEnabled(false);
    }

    protected void fillWidgets() {
        ArrayList<String> list = new ArrayList<String>();
        XPathCategory[] categories = XPathModel.getDefault().getCategories(this.info.server);
        int i = 0;
        while (i < categories.length) {
            this.allQueries = categories[i].getQueries();
            int j = 0;
            while (j < this.allQueries.length) {
                list.add(String.valueOf(categories[i].getName()) + '/' + this.allQueries[j].getName());
                ++j;
            }
            ++i;
        }
        String[] stuff = list.toArray(new String[list.size()]);
        this.listWidget.setItems(stuff);
        int i2 = 0;
        while (i2 < stuff.length) {
            if (stuff[i2].equals(this.info.currentXPath)) {
                this.listWidget.select(i2);
            }
            ++i2;
        }
    }

    protected void addListeners() {
        this.listWidget.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ChangePortDialog.this.selectionChanged();
            }
        });
        this.editXPathButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ChangePortDialog.this.editPressed();
            }
        });
    }

    protected void editPressed() {
        if (this.currentQuery != null) {
            XPathCategory category = this.currentQuery.getCategory();
            XPathDialogs.XPathDialog d = new XPathDialogs.XPathDialog(Display.getCurrent().getActiveShell(), this.info.server, this.currentQuery);
            if (d.open() == 0) {
                this.currentQuery.setAttribute(d.getAttribute());
                this.currentQuery.setXpathPattern(d.getXpath());
                this.currentQuery.setName(d.getName());
                this.currentQuery.clearCache();
                this.modified = true;
                category.save();
                this.fillWidgets();
                this.selectionChanged();
            }
        }
    }

    protected synchronized void selectionChanged() {
        if (!this.queriesLoaded) {
            try {
                final String[] items = this.listWidget.getItems();
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
                dialog.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.ChangePortDialog_LoadingTaskName, items.length);
                        int i = 0;
                        while (i < items.length) {
                            ChangePortDialog.this.countMatches(ChangePortDialog.this.allQueries[i]);
                            monitor.worked(1);
                            ++i;
                        }
                        monitor.done();
                        ChangePortDialog.this.queriesLoaded = true;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ChangePortDialog.this.selectionChanged2();
                            }
                        });
                    }
                });
            }
            catch (InvocationTargetException ite) {
                Status status = new Status(4, "org.jboss.ide.eclipse.as.ui", Messages.ChangePortDialog_could_not_determine_port, (Throwable)ite);
                JBossServerUIPlugin.getDefault().getLog().log((IStatus)status);
            }
            catch (InterruptedException ie) {
                Status status = new Status(4, "org.jboss.ide.eclipse.as.ui", Messages.ChangePortDialog_could_not_change_port_interrupted, (Throwable)ie);
                JBossServerUIPlugin.getDefault().getLog().log((IStatus)status);
            }
        } else {
            this.selectionChanged2();
        }
    }

    private void selectionChanged2() {
        this.currentQuery = null;
        int s = this.listWidget.getSelectionIndex();
        if (s != -1) {
            this.selected = this.listWidget.getItem(s);
            this.currentQuery = XPathModel.getDefault().getQuery(this.info.server, (IPath)new Path(this.selected));
        }
        if (this.currentQuery != null) {
            this.editXPathButton.setEnabled(true);
            String result = this.currentQuery.getFirstResult();
            this.currentValueText.setText(result == null ? "" : result);
        }
    }

    private String countMatches(XPathQuery query) {
        if (query == null) {
            return String.valueOf(-1);
        }
        query.clearCache();
        int count = 0;
        XPathFileResult[] fResults = query.getResults();
        int i = 0;
        while (i < fResults.length) {
            count += fResults[i].getChildren().length;
            ++i;
        }
        return String.valueOf(count);
    }

    private String safeString(String s) {
        return s == null ? "" : s;
    }

    public String getSelection() {
        return this.selected;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 35, Messages.EditorCPD_RestoreDefault, false);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (35 == buttonId) {
            String[] items = this.listWidget.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].equals(this.info.defaultValue)) {
                    this.listWidget.select(i);
                    return;
                }
                ++i;
            }
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public static class ChangePortDialogInfo {
        public String port;
        public String defaultValue;
        public String shellTitle;
        public String description;
        public IServer server;
        public String currentXPath;
    }
}

