/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.console;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.jboss.ide.eclipse.as.ui.Messages;

public class ELExceptionsMatcher
implements IPatternMatchListenerDelegate {
    private TextConsole console;
    static final Pattern resourceLocationPattern = Pattern.compile("Exception: (.*) @(\\d+),(\\d+)");

    public void connect(TextConsole console) {
        this.console = console;
    }

    public void disconnect() {
        this.console = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void matchFound(PatternMatchEvent event) {
        Matcher matcher;
        String line = null;
        try {
            line = this.console.getDocument().get(event.getOffset(), event.getLength());
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        Pattern pattern = resourceLocationPattern;
        synchronized (pattern) {
            matcher = resourceLocationPattern.matcher(line);
        }
        String resource = null;
        int resourceStart = -1;
        int resourceEnd = -1;
        int columnEnd = -1;
        if (matcher.find()) {
            resource = matcher.group(1);
            resourceStart = matcher.start(1);
            resourceEnd = matcher.end(1);
            String lineNum = matcher.group(2);
            matcher.group(3);
            columnEnd = matcher.end(3);
            int space = resource.lastIndexOf(32);
            if (space != -1) {
                resource = resource.substring(space).trim();
                resourceStart = resourceEnd - resource.length();
            }
            CustomFileLink customFileLink = new CustomFileLink(this.console, resource, lineNum);
            try {
                this.console.addHyperlink((IHyperlink)customFileLink, event.getOffset() + resourceStart, columnEnd - resourceStart);
            }
            catch (BadLocationException badLocationException) {
                return;
            }
        }
    }

    static class CustomFileLink
    implements IHyperlink {
        private TextConsole console;
        private final String resource;
        private final String lineNum;

        CustomFileLink(TextConsole console, String resourceName, String lineNum) {
            this.console = console;
            this.resource = resourceName;
            this.lineNum = lineNum;
        }

        private ILaunch getLaunch() {
            IProcess process = (IProcess)this.console.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_PROCESS");
            if (process != null) {
                return process.getLaunch();
            }
            return null;
        }

        public void linkActivated() {
            ILaunch launch = this.getLaunch();
            if (launch != null) {
                FileLink launchSpecificFile = this.getLaunchSpecificFile(launch);
                if (launchSpecificFile != null) {
                    launchSpecificFile.linkActivated();
                    return;
                }
            } else {
                FileLink launchSpecificFile = this.findFileInWorkspace();
                if (launchSpecificFile != null) {
                    launchSpecificFile.linkActivated();
                    return;
                }
            }
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ConsoleResourceNotFound, (String)NLS.bind((String)Messages.ConsoleCouldNotLocateInWorkspace, (Object)this.resource));
        }

        private FileLink findFileInWorkspace() {
            IFile file;
            final String simpleName = this.resource.substring(this.resource.lastIndexOf("/") + 1);
            new Path(this.resource);
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            final String finalResource = this.resource;
            final ArrayList files = new ArrayList();
            int i = 0;
            while (i < projects.length && files.isEmpty()) {
                IProject project = projects[i];
                try {
                    project.accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) {
                            IPath requestFullPath;
                            if (proxy.requestResource().getType() != 1) {
                                return true;
                            }
                            String n = proxy.getName();
                            if (n.equals(simpleName) && (requestFullPath = proxy.requestFullPath()).toOSString().endsWith(finalResource)) {
                                files.add((IFile)proxy.requestResource());
                            }
                            return true;
                        }
                    }, 0);
                }
                catch (CoreException coreException) {}
                ++i;
            }
            if (files.size() != 0 && (file = (IFile)files.get(0)) != null && file.exists()) {
                FileLink link = new FileLink(file, null, -1, -1, Integer.parseInt(this.lineNum));
                return link;
            }
            return null;
        }

        private FileLink getLaunchSpecificFile(ILaunch launch) {
            try {
                Object resolveSourceElement = CustomFileLink.resolveSourceElement(this.resource, launch);
                if (resolveSourceElement != null && resolveSourceElement instanceof IFile) {
                    IFile file = (IFile)resolveSourceElement;
                    FileLink link = new FileLink(file, null, -1, -1, Integer.parseInt(this.lineNum));
                    return link;
                }
            }
            catch (CoreException coreException) {}
            return null;
        }

        private static Object resolveSourceElement(Object object, ILaunch launch) throws CoreException {
            ISourceLookupDirector director;
            Object[] objects;
            ISourceLocator sourceLocator = launch.getSourceLocator();
            if (sourceLocator instanceof ISourceLookupDirector && (objects = (director = (ISourceLookupDirector)sourceLocator).findSourceElements(object)).length > 0) {
                return objects[0];
            }
            return null;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }
    }
}

