/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.jdt.internal.markers;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.jboss.tools.maven.jdt.MavenJdtActivator;
import org.jboss.tools.maven.jdt.internal.markers.ExecuteDependencyCopyMarkerResolution;

public class MissingEndorsedLibMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private static Set<String> INTERESTING_PHASES = new LinkedHashSet<String>(Arrays.asList("validate", "initialize", "generate-sources", "process-sources", "generate-resources", "process-resources", "compile", "process-classes", "generate-test-sources", "process-test-sources", "generate-test-resources", "process-test-resources", "test-compile", "process-test-classes"));

    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            String phase = this.getPhaseToExecute(marker, (IProgressMonitor)monitor);
            if (phase != null) {
                IMavenProjectFacade facade = this.getMavenProjectFacade(marker, (IProgressMonitor)monitor);
                return new IMarkerResolution[]{new ExecuteDependencyCopyMarkerResolution(facade, phase)};
            }
        }
        catch (CoreException e) {
            MavenJdtActivator.log(e);
        }
        return new IMarkerResolution[0];
    }

    public boolean hasResolutions(IMarker marker) {
        try {
            return this.getPhaseToExecute(marker, (IProgressMonitor)new NullProgressMonitor()) != null;
        }
        catch (CoreException e) {
            MavenJdtActivator.log(e);
            return false;
        }
    }

    private String getPhaseToExecute(IMavenProjectFacade facade, String absolutePath, IProgressMonitor monitor) throws CoreException {
        Plugin p = facade.getMavenProject(monitor).getPlugin("org.apache.maven.plugins:maven-dependency-plugin");
        if (p != null) {
            for (PluginExecution pe : p.getExecutions()) {
                String phase = pe.getPhase();
                if (phase == null) {
                    phase = "process-sources";
                }
                if (!INTERESTING_PHASES.contains(phase) || !pe.getGoals().contains("copy")) continue;
                return phase;
            }
        }
        return null;
    }

    private String getPhaseToExecute(IMarker marker, IProgressMonitor monitor) throws CoreException {
        String phase = null;
        IMavenProjectFacade facade = this.getMavenProjectFacade(marker, monitor);
        if (facade != null) {
            String path = (String)marker.getAttribute("outputDirectory");
            phase = this.getPhaseToExecute(facade, path, monitor);
        }
        return phase;
    }

    private IMavenProjectFacade getMavenProjectFacade(IMarker marker, IProgressMonitor monitor) {
        IProject project = marker.getResource() == null ? null : marker.getResource().getProject();
        try {
            if (project != null && project.isAccessible() && project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(project, monitor);
                return facade;
            }
        }
        catch (CoreException e) {
            MavenJdtActivator.log("Can't access the project facade from marker", e);
        }
        return null;
    }
}

