/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.validation;

import java.util.HashSet;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.preferences.SeverityPreferences;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.IValidatingProjectSet;
import org.jboss.tools.common.validation.IValidatingProjectTree;
import org.jboss.tools.common.validation.IValidator;
import org.jboss.tools.common.validation.TempMarkerManager;
import org.jboss.tools.common.validation.internal.SimpleValidatingProjectTree;
import org.jboss.tools.common.validation.internal.ValidatingProjectSet;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.KbMessages;
import org.jboss.tools.jst.web.kb.KbProjectFactory;

public abstract class KBValidator
extends TempMarkerManager
implements IValidator {
    public static final String ORDER_PROBLEM_MARKER_TYPE = "org.jboss.tools.jst.web.kb.builderOrderProblem";
    private static String ATTR_BUILDER = "builder";
    private static String ATTR_VALIDATOR = "validator";

    protected boolean notValidatedYet(IResource resource) {
        IProject pr = resource.getProject();
        return this.coreHelper == null || !this.coreHelper.getValidationContextManager().projectHasBeenValidated((IValidator)this, pr);
    }

    public static IValidatingProjectTree createSimpleValidatingProjectTree(IProject project) {
        HashSet<IProject> projects = new HashSet<IProject>();
        projects.add(project);
        IKbProject kbProject = KbProjectFactory.getKbProject(project, false);
        if (kbProject != null) {
            IProjectValidationContext rootContext = kbProject.getValidationContext();
            ValidatingProjectSet projectSet = new ValidatingProjectSet(project, projects, rootContext);
            return new SimpleValidatingProjectTree((IValidatingProjectSet)projectSet);
        }
        return new SimpleValidatingProjectTree(project);
    }

    public static boolean validateBuilderOrder(IProject project, String builderId, String validatorId, SeverityPreferences preferences) throws CoreException {
        int severity = KBValidator.getSeverity(preferences.getBuilderOrderPreference(project));
        boolean isCorrect = KBValidator.isCorrectOrder(project, builderId);
        IMarker marker = KBValidator.findBuilderOrderMarker(project, builderId, validatorId);
        if (isCorrect || severity <= 0) {
            if (marker != null) {
                ResourcesPlugin.getWorkspace().deleteMarkers(new IMarker[]{marker});
            }
        } else if (marker != null) {
            if (marker.getAttribute("severity", -1) != severity) {
                marker.setAttribute("severity", severity);
            }
        } else {
            marker = project.createMarker(ORDER_PROBLEM_MARKER_TYPE);
            marker.setAttribute(ATTR_BUILDER, (Object)builderId);
            marker.setAttribute("severity", severity);
            String message = NLS.bind((String)KbMessages.WRONG_BUILDER_ORDER, (Object[])new String[]{project.getName(), KBValidator.findValidatorName(validatorId), KBValidator.findBuilderName(builderId)});
            marker.setAttribute("message", (Object)message);
            marker.setAttribute(ATTR_VALIDATOR, (Object)validatorId);
        }
        return isCorrect || severity <= 0;
    }

    private static boolean isCorrectOrder(IProject project, String builderId) throws CoreException {
        if (project.isAccessible()) {
            ICommand[] cs = project.getDescription().getBuildSpec();
            boolean validationFound = false;
            ICommand[] iCommandArray = cs;
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                ICommand c = iCommandArray[n2];
                String name = c.getBuilderName();
                if ("org.eclipse.wst.validation.validationbuilder".equals(name)) {
                    validationFound = true;
                } else if (builderId.equals(name)) {
                    return !validationFound;
                }
                ++n2;
            }
        }
        return true;
    }

    private static IMarker findBuilderOrderMarker(IProject project, String builderId, String validatorId) throws CoreException {
        IMarker[] ms;
        IMarker result = null;
        IMarker[] iMarkerArray = ms = project.findMarkers(ORDER_PROBLEM_MARKER_TYPE, false, 0);
        int n = ms.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker m = iMarkerArray[n2];
            if (builderId.equals(m.getAttribute(ATTR_BUILDER, null)) && validatorId.equals(m.getAttribute(ATTR_VALIDATOR))) {
                result = m;
            }
            ++n2;
        }
        return result;
    }

    private static String findBuilderName(String builderId) {
        IExtension ext = Platform.getExtensionRegistry().getExtension(builderId);
        return ext != null && ext.getLabel() != null ? ext.getLabel() : builderId;
    }

    private static String findValidatorName(String validatorId) {
        String name;
        IConfigurationElement[] es;
        IExtension ext = Platform.getExtensionRegistry().getExtension(validatorId);
        if (ext != null && (es = ext.getConfigurationElements()).length > 0 && (name = es[0].getAttribute("name")) != null) {
            return name;
        }
        return validatorId;
    }

    private static int getSeverity(String severityPreferenceValue) {
        return "ignore".equals(severityPreferenceValue) ? 0 : ("warning".equals(severityPreferenceValue) ? 1 : 2);
    }
}

