/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.taglib.html.jq;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.taglib.CustomTagLibAttribute;
import org.jboss.tools.jst.web.kb.internal.taglib.html.HtmlAttribute;
import org.jboss.tools.jst.web.kb.internal.taglib.html.jq.JQueryMobileAttrConstants;
import org.jboss.tools.jst.web.kb.internal.taglib.html.jq.JQueryMobileAttrProvider;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LinkAttributeProvider
extends JQueryMobileAttrProvider {
    private static final ImageDescriptor IMAGE = WebKbPlugin.getImageDescriptor(WebKbPlugin.class, "EnumerationProposal.gif");
    static final HtmlAttribute[] DATA_ATTRIBUTES = new HtmlAttribute[]{JQueryMobileAttrConstants.DATA_AJAX_ATTRIBUTE, JQueryMobileAttrConstants.DATA_DIRECTION_ATTRIBUTE, JQueryMobileAttrConstants.DATA_DOM_CACHE_ATTRIBUTE, JQueryMobileAttrConstants.DATA_PREFETCH_ATTRIBUTE, JQueryMobileAttrConstants.DATA_REL_ATTRIBUTE, JQueryMobileAttrConstants.LINK_DATA_TRANSITION_ATTRIBUTE, JQueryMobileAttrConstants.DATA_POSITION_TO_ATTRIBUTE};
    static final CustomTagLibAttribute[] ATTRIBUTES = new CustomTagLibAttribute[]{JQueryMobileAttrConstants.DATA_AJAX_ATTRIBUTE, JQueryMobileAttrConstants.DATA_DIRECTION_ATTRIBUTE, JQueryMobileAttrConstants.DATA_DOM_CACHE_ATTRIBUTE, JQueryMobileAttrConstants.DATA_PREFETCH_ATTRIBUTE, JQueryMobileAttrConstants.DATA_REL_ATTRIBUTE, JQueryMobileAttrConstants.LINK_DATA_TRANSITION_ATTRIBUTE, JQueryMobileAttrConstants.DATA_POSITION_TO_ATTRIBUTE, new HrefAttribute()};

    @Override
    protected boolean checkComponent() {
        return false;
    }

    @Override
    protected CustomTagLibAttribute[] getConditionalAttributes() {
        return EMPTY;
    }

    @Override
    protected CustomTagLibAttribute[] getRequiredAttributes() {
        return ATTRIBUTES;
    }

    public static List<ElementID> findAllIds(IPageContext context, String mask) {
        IFile file = context.getResource();
        if (file == null) {
            return Collections.emptyList();
        }
        return LinkAttributeProvider.findAllIds(file, mask, true);
    }

    public static List<ElementID> findAllIds(IFile file, boolean escapeHTML) {
        return LinkAttributeProvider.findAllIds(file, "", escapeHTML);
    }

    public static List<ElementID> findAllIds(IFile file, final String mask, final boolean escapeHTML) {
        final ArrayList ids = new ArrayList();
        StructuredModelWrapper.execute((IFile)file, (StructuredModelWrapper.ICommand)new StructuredModelWrapper.ICommand(){

            public void execute(IDOMDocument xmlDocument) {
                try {
                    NodeList list = (NodeList)XPathFactory.newInstance().newXPath().compile("//*/@id[starts-with(.,'" + mask + "')]").evaluate(xmlDocument, XPathConstants.NODESET);
                    int i = 0;
                    while (i < list.getLength()) {
                        IDOMAttr attr = (IDOMAttr)list.item(i);
                        Element element = attr.getOwnerElement();
                        String dataRole = element.getAttribute("data-role");
                        if ("page".equalsIgnoreCase(dataRole) || "dialog".equalsIgnoreCase(dataRole) || "popup".equalsIgnoreCase(dataRole) || "panel".equalsIgnoreCase(dataRole)) {
                            IStructuredDocumentRegion s = ((IDOMNode)element).getStartStructuredDocumentRegion();
                            String id = attr.getNodeValue();
                            int offset = attr.getValueRegionStartOffset() + 1;
                            String nodeString = s.getText();
                            ids.add(new ElementID(id, offset, nodeString, escapeHTML));
                        }
                        ++i;
                    }
                }
                catch (XPathExpressionException e) {
                    WebKbPlugin.getDefault().logError(e);
                }
            }
        });
        return Collections.unmodifiableList(ids);
    }

    public static class ElementID {
        private String id;
        private int offset;
        private String description;

        public ElementID(String id, int offset, String description, boolean escapeHTML) {
            this.id = id;
            this.offset = offset;
            if (escapeHTML && description != null) {
                description = description.replace("<", "&lt;").replace(">", "&gt;");
            }
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public String getId() {
            return this.id;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    static class HrefAttribute
    extends CustomTagLibAttribute {
        public HrefAttribute() {
            this.setName("href");
        }

        @Override
        public TextProposal[] getProposals(KbQuery query, IPageContext context) {
            ArrayList<TextProposal> proposals = new ArrayList<TextProposal>();
            if (query.getType() == KbQuery.Type.ATTRIBUTE_VALUE) {
                String mask = query.getValue();
                String idMask = null;
                if (mask.startsWith("#")) {
                    idMask = mask.substring(1);
                } else if (mask.length() == 0) {
                    idMask = mask;
                }
                if (idMask != null) {
                    List<ElementID> ids = LinkAttributeProvider.findAllIds(context, idMask);
                    for (ElementID id : ids) {
                        String idText = id.getId();
                        String proposaltext = "#" + idText;
                        TextProposal proposal = new TextProposal();
                        proposal.setLabel(proposaltext);
                        proposal.setReplacementString(proposaltext);
                        proposal.setPosition(proposaltext.length());
                        proposal.setImageDescriptor(IMAGE);
                        proposal.setContextInfo(id.getDescription());
                        proposals.add(proposal);
                    }
                }
            }
            return proposals.toArray(new TextProposal[proposals.size()]);
        }
    }
}

