/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.taglib.html;

import org.jboss.tools.jst.web.kb.internal.proposal.CustomProposalType;
import org.jboss.tools.jst.web.kb.internal.proposal.EnumerationProposalType;
import org.jboss.tools.jst.web.kb.internal.taglib.CustomTagLibAttribute;

public class HtmlAttribute
extends CustomTagLibAttribute {
    protected String[] values;

    public HtmlAttribute(String name, String description) {
        this(name, description, new String[0]);
    }

    public HtmlAttribute(String name, String description, String[] values) {
        this(name, description, values, null);
    }

    public HtmlAttribute(String name, String description, String[] values, String[] valueDescriptions) {
        this.values = values;
        this.setDescription(description);
        this.setExtended(false);
        this.setIgnoreCase(true);
        this.setName(name);
        this.setRequired(false);
        this.initProposalTypes(valueDescriptions);
    }

    protected void initProposalTypes(String[] valueDescriptions) {
        CustomProposalType proposal = this.createProposalType();
        proposal.setType("enumeration");
        CustomProposalType[] proposals = new CustomProposalType[]{proposal};
        CustomProposalType.Param[] params = new CustomProposalType.Param[this.values.length];
        int i = 0;
        while (i < this.values.length) {
            CustomProposalType.Param param = new CustomProposalType.Param();
            param.setValue(this.values[i]);
            if (valueDescriptions != null) {
                param.setDescription(valueDescriptions[i]);
            }
            params[i] = param;
            ++i;
        }
        proposal.setParams(params);
        this.setProposals(proposals);
    }

    protected CustomProposalType createProposalType() {
        return new EnumerationProposalType();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("{Name: ").append(this.name).append("; Values: ");
        int i = 0;
        while (i < this.values.length) {
            if (i > 0) {
                sb.append('|');
            }
            sb.append(this.values[i]);
            ++i;
        }
        return sb.append('}').toString();
    }
}

