/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.scanner;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.internal.scanner.IFileScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.LibraryScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.LoadedDeclarations;
import org.jboss.tools.jst.web.kb.internal.scanner.ScannerException;
import org.jboss.tools.jst.web.kb.internal.taglib.AbstractTagLib;
import org.jboss.tools.jst.web.kb.internal.taglib.ELFunction;
import org.jboss.tools.jst.web.kb.internal.taglib.FaceletAttribute;
import org.jboss.tools.jst.web.kb.internal.taglib.FaceletTag;
import org.jboss.tools.jst.web.kb.internal.taglib.FaceletTagLibrary;
import org.jboss.tools.jst.web.kb.internal.taglib.FacesConfigAttribute;
import org.jboss.tools.jst.web.kb.internal.taglib.FacesConfigComponent;
import org.jboss.tools.jst.web.kb.internal.taglib.FacesConfigTagLibrary;
import org.jboss.tools.jst.web.kb.internal.taglib.TLDAttribute;
import org.jboss.tools.jst.web.kb.internal.taglib.TLDLibrary;
import org.jboss.tools.jst.web.kb.internal.taglib.TLDTag;
import org.jboss.tools.jst.web.kb.taglib.Facet;
import org.jboss.tools.jst.web.model.helpers.InnerModelHelper;
import org.jboss.tools.jst.web.model.project.ext.store.XMLValueInfo;

public class XMLScanner
implements IFileScanner {
    public static final String ATTR_SHORTNAME = "shortname";
    public static final String ATTR_TAGCLASS = "tagclass";
    public static final String ATTR_TAG_NAME = "tag-name";
    public static final String ATTR_BODY_CONTENT = "bodycontent";
    public static final String ATTR_FACET_NAME = "facet-name";
    public static final String ATTR_ATTRIBUTE_NAME = "attribute-name";
    public static final String ATTR_FUNC_SIGN = "function-signature";
    public static final String ATTR_FUNC_NAME = "function-name";
    public static final String ATTR_COMPONENT_TYPE = "component-type";
    public static final String XML_SUFFIX = ".xml";
    public static final String TLD_SUFFIX = ".tld";

    @Override
    public boolean isRelevant(IFile resource) {
        String name = resource.getName().toLowerCase();
        return name.endsWith(XML_SUFFIX) || name.endsWith(TLD_SUFFIX);
    }

    @Override
    public boolean isLikelyComponentSource(IFile f) {
        if (!f.isSynchronized(0) || !f.exists()) {
            return false;
        }
        XModel model = InnerModelHelper.createXModel((IProject)f.getProject());
        if (model == null) {
            return false;
        }
        XModelObject o = EclipseResourceUtil.getObjectByResource((XModel)model, (IResource)f);
        return o != null && (LibraryScanner.isTLDFile(o) || LibraryScanner.isFaceletTaglibFile(o) || LibraryScanner.isFacesConfigFile(o));
    }

    @Override
    public LoadedDeclarations parse(IFile f, IKbProject sp) throws ScannerException {
        XModel model = InnerModelHelper.createXModel((IProject)f.getProject());
        if (model == null) {
            return null;
        }
        XModelObject o = EclipseResourceUtil.getObjectByResource((XModel)model, (IResource)f);
        return this.parse(o, f.getFullPath(), sp);
    }

    public LoadedDeclarations parse(XModelObject o, IPath source, IKbProject sp) {
        IFile f;
        if (o == null) {
            return null;
        }
        if (o.getParent() instanceof FolderImpl && (f = ResourcesPlugin.getWorkspace().getRoot().getFile(source)) != null && f.exists()) {
            try {
                ((FolderImpl)o.getParent()).updateChildFile(o, f.getLocation().toFile());
            }
            catch (XModelException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
            }
            if (o.getParent() == null) {
                boolean b = this.isLikelyComponentSource(f);
                if (!b) {
                    return null;
                }
                if ((o = EclipseResourceUtil.getObjectByResource((XModel)o.getModel(), (IResource)f)) == null) {
                    return null;
                }
            }
        }
        LoadedDeclarations ds = new LoadedDeclarations();
        if (LibraryScanner.isTLDFile(o)) {
            this.parseTLD(o, source, ds);
        } else if (LibraryScanner.isFaceletTaglibFile(o)) {
            this.parseFaceletTaglib(o, source, ds);
        } else if (LibraryScanner.isFacesConfigFile(o)) {
            this.parseFacesConfig(o, source, ds);
        }
        return ds;
    }

    private void parseTLD(XModelObject o, IPath source, LoadedDeclarations ds) {
        XModelObject[] ts;
        TLDLibrary library = new TLDLibrary();
        library.setId(o);
        library.setURI((IValueInfo)new XMLValueInfo(o, AbstractTagLib.URI));
        library.setDisplayName((IValueInfo)new XMLValueInfo(o, "display-name"));
        library.setShortName((IValueInfo)new XMLValueInfo(o, ATTR_SHORTNAME));
        String version = o.getAttributeValue("version");
        if (version == null) {
            version = "FileTLD_1_2".equals(o.getModelEntity().getName()) ? "1.2" : "1.1";
            library.setVersion(version);
        } else {
            library.setVersion((IValueInfo)new XMLValueInfo(o, "version"));
        }
        ds.getLibraries().add(library);
        XModelObject[] xModelObjectArray = ts = o.getChildren();
        int n = ts.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject t = xModelObjectArray[n2];
            if (t.getModelEntity().getName().startsWith("TLDTag")) {
                XModelObject[] as;
                TLDTag tag = new TLDTag();
                tag.setId(t);
                tag.setName((IValueInfo)new XMLValueInfo(t, "name"));
                tag.setDescription((IValueInfo)new XMLValueInfo(t, "description"));
                tag.setComponentClass((IValueInfo)new XMLValueInfo(t, ATTR_TAGCLASS));
                tag.setCanHaveBody((IValueInfo)new XMLValueInfo(t, ATTR_BODY_CONTENT));
                XModelObject[] xModelObjectArray2 = as = t.getChildren();
                int n3 = as.length;
                int n4 = 0;
                while (n4 < n3) {
                    XModelObject a = xModelObjectArray2[n4];
                    if (a.getModelEntity().getName().startsWith("TLDAttribute")) {
                        TLDAttribute attr = new TLDAttribute();
                        attr.setId(a);
                        attr.setName((IValueInfo)new XMLValueInfo(a, "name"));
                        attr.setDescription((IValueInfo)new XMLValueInfo(a, "description"));
                        attr.setRequired((IValueInfo)new XMLValueInfo(a, "required"));
                        tag.addAttribute(attr);
                    }
                    ++n4;
                }
                library.addComponent(tag);
            }
            ++n2;
        }
        XModelObject functions = o.getChildByPath("Functions");
        if (functions != null) {
            XModelObject[] xModelObjectArray3 = ts = functions.getChildren();
            int n5 = ts.length;
            n = 0;
            while (n < n5) {
                XModelObject t = xModelObjectArray3[n];
                ELFunction f = new ELFunction();
                f.setId(t);
                f.setName((IValueInfo)new XMLValueInfo(t, "name"));
                f.setSignature((IValueInfo)new XMLValueInfo(t, ATTR_FUNC_SIGN));
                f.setFunctionClass((IValueInfo)new XMLValueInfo(t, "function-class"));
                library.addFunction(f);
                ++n;
            }
        }
    }

    private void parseFaceletTaglib(XModelObject o, IPath source, LoadedDeclarations ds) {
        XModelObject[] os;
        FaceletTagLibrary library = new FaceletTagLibrary();
        library.setId(o);
        library.setURI((IValueInfo)new XMLValueInfo(o, AbstractTagLib.URI));
        library.setCompositeLibraryName((IValueInfo)new XMLValueInfo(o, "composite-library-name"));
        ds.getLibraries().add(library);
        XModelObject[] xModelObjectArray = os = o.getChildren();
        int n = os.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject t = xModelObjectArray[n2];
            String entity = t.getModelEntity().getName();
            if (entity.startsWith("FaceletTaglibTag")) {
                XModelObject[] as;
                String componentType;
                FaceletTag tag = new FaceletTag();
                tag.setId(t);
                tag.setName((IValueInfo)new XMLValueInfo(t, ATTR_TAG_NAME));
                tag.setDescription((IValueInfo)new XMLValueInfo(t, "description"));
                XModelObject d = t.getChildByPath("declaration");
                if (d != null && d.getModelEntity().getName().startsWith("FaceletTaglibComponent") && (componentType = d.getAttributeValue(ATTR_COMPONENT_TYPE)) != null && componentType.length() > 0) {
                    tag.setComponentType((IValueInfo)new XMLValueInfo(d, ATTR_COMPONENT_TYPE));
                }
                XModelObject[] xModelObjectArray2 = as = t.getChildren();
                int n3 = as.length;
                int n4 = 0;
                while (n4 < n3) {
                    XModelObject a = xModelObjectArray2[n4];
                    String entity2 = a.getModelEntity().getName();
                    if (entity2.startsWith("FaceletTaglibAttribute")) {
                        FaceletAttribute attr = new FaceletAttribute();
                        attr.setId(a);
                        attr.setName((IValueInfo)new XMLValueInfo(a, "name"));
                        attr.setDescription((IValueInfo)new XMLValueInfo(a, "description"));
                        attr.setRequired((IValueInfo)new XMLValueInfo(a, "required"));
                        tag.addAttribute(attr);
                    }
                    ++n4;
                }
                library.addComponent(tag);
            } else if (entity.startsWith("FaceletTaglibFunction")) {
                ELFunction f = new ELFunction();
                f.setId(t);
                f.setName((IValueInfo)new XMLValueInfo(t, ATTR_FUNC_NAME));
                f.setSignature((IValueInfo)new XMLValueInfo(t, ATTR_FUNC_SIGN));
                f.setFunctionClass((IValueInfo)new XMLValueInfo(t, "function-class"));
                library.addFunction(f);
            }
            ++n2;
        }
    }

    private void parseFacesConfig(XModelObject o, IPath source, LoadedDeclarations ds) {
        XModelObject[] os;
        FacesConfigTagLibrary library = new FacesConfigTagLibrary();
        library.setId(o);
        library.setURI("TODO");
        ds.getLibraries().add(library);
        XModelObject componentFolder = o.getChildByPath("Components");
        if (componentFolder == null) {
            return;
        }
        XModelObject[] xModelObjectArray = os = componentFolder.getChildren();
        int n = os.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject[] as;
            XModelObject c = xModelObjectArray[n2];
            FacesConfigComponent component = new FacesConfigComponent();
            component.setId(c);
            component.setName((IValueInfo)new XMLValueInfo(c, ATTR_COMPONENT_TYPE));
            component.setComponentClass((IValueInfo)new XMLValueInfo(c, "component-class"));
            component.setComponentType((IValueInfo)new XMLValueInfo(c, ATTR_COMPONENT_TYPE));
            component.setDescription((IValueInfo)new XMLValueInfo(c, "description"));
            XModelObject[] xModelObjectArray2 = as = c.getChildren();
            int n3 = as.length;
            int n4 = 0;
            while (n4 < n3) {
                XModelObject child = xModelObjectArray2[n4];
                String entity = child.getModelEntity().getName();
                if (entity.startsWith("JSFAttribute")) {
                    FacesConfigAttribute attr = new FacesConfigAttribute();
                    attr.setId(child);
                    attr.setName((IValueInfo)new XMLValueInfo(child, ATTR_ATTRIBUTE_NAME));
                    component.addAttribute(attr);
                } else if (entity.startsWith("JSFFacet")) {
                    Facet f = new Facet();
                    f.setId(child);
                    f.setName((IValueInfo)new XMLValueInfo(child, ATTR_FACET_NAME));
                    f.setDescription((IValueInfo)new XMLValueInfo(child, "description"));
                    component.addFacet(f);
                }
                ++n4;
            }
            library.addComponent(component);
            ++n2;
        }
    }
}

