/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.scanner;

import java.util.Properties;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jst.web.kb.internal.KbObject;
import org.jboss.tools.jst.web.kb.internal.scanner.LoadedDeclarations;
import org.jboss.tools.jst.web.kb.internal.scanner.XMLScanner;
import org.jboss.tools.jst.web.kb.internal.taglib.AbstractTagLib;
import org.w3c.dom.Element;

public class LibraryProxy
extends KbObject {
    AbstractTagLib library;

    public LibraryProxy(AbstractTagLib library) {
        this.library = library;
        this.setSourcePath(library.getSourcePath());
        this.setId(library.getId());
    }

    public AbstractTagLib getLibrary() {
        return this.library;
    }

    @Override
    public String getXMLName() {
        return this.library.getXMLName();
    }

    @Override
    public String getXMLClass() {
        return this.library.getXMLClass();
    }

    @Override
    public void loadXML(Element element, Properties context) {
        super.loadXML(element, context);
        if (this.getId() instanceof XModelObject) {
            XModelObject o = (XModelObject)this.getId();
            LoadedDeclarations ds = new XMLScanner().parse(o, this.getSourcePath(), this.library.getKbProject());
            this.library = ds != null && !ds.getLibraries().isEmpty() ? (AbstractTagLib)ds.getLibraries().get(0) : null;
        } else {
            this.library.loadXML(element, context);
        }
    }
}

