/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.proposal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.PageProcessor;
import org.jboss.tools.jst.web.kb.internal.proposal.CustomProposalType;
import org.jboss.tools.jst.web.kb.taglib.IComponent;
import org.jboss.tools.jst.web.kb.taglib.INameSpace;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;

public class FaceletsJsfCProposalType
extends CustomProposalType {
    private static ImageDescriptor ICON;

    @Override
    public TextProposal[] getProposals(KbQuery query) {
        String value = query.getValue();
        while (value.startsWith(" ")) {
            value = value.substring(1);
        }
        KbQuery kbQuery = new KbQuery();
        kbQuery.setMask(query.isMask());
        kbQuery.setType(KbQuery.Type.TAG_NAME);
        kbQuery.setValue(query.getValue());
        kbQuery.setOffset(query.getOffset());
        IComponent[] components = null;
        ArrayList<TextProposal> proposals = null;
        components = PageProcessor.getInstance().getComponents(kbQuery, this.context);
        if (components.length == 0) {
            return EMPTY_PROPOSAL_LIST;
        }
        proposals = new ArrayList<TextProposal>();
        HashMap<String, List<String>> prefixes = new HashMap<String, List<String>>();
        int i = 0;
        while (i < components.length) {
            ITagLibrary lib = components[i].getTagLib();
            if (!this.ignoreTagLib(lib)) {
                List<String> pfx = (List<String>)prefixes.get(lib.getURI());
                if (pfx == null) {
                    pfx = this.getPrefixes(this.context, components[i], kbQuery);
                    prefixes.put(lib.getURI(), pfx);
                }
                for (String prefix : pfx) {
                    TextProposal proposal = this.getProposal(prefix, components[i]);
                    proposals.add(proposal);
                }
            }
            ++i;
        }
        return proposals.toArray(new TextProposal[0]);
    }

    private boolean ignoreTagLib(ITagLibrary lib) {
        return "http://java.sun.com/jsf/facelets".equals(lib.getURI()) || "http://xmlns.jcp.org/jsf/facelets".equals(lib.getURI()) || "http://www.w3.org/1999/xhtml/facelets".equals(lib.getURI());
    }

    private TextProposal getProposal(String prefix, IComponent component) {
        TextProposal proposal = new TextProposal();
        proposal.setContextInfo(component.getDescription());
        proposal.setSource((Object)component);
        StringBuffer label = new StringBuffer();
        label.append(String.valueOf(prefix) + ":");
        label.append(component.getName());
        proposal.setLabel(label.toString());
        proposal.setReplacementString(proposal.getLabel());
        int position = proposal.getReplacementString().length();
        proposal.setPosition(position);
        if (ICON == null) {
            ICON = XMLEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/tag-generic.gif");
        }
        proposal.setImageDescriptor(ICON);
        return proposal;
    }

    private List<String> getPrefixes(IPageContext context, IComponent component, KbQuery query) {
        List<INameSpace> nameSpace;
        ArrayList<String> prefixes = new ArrayList<String>();
        Map<String, List<INameSpace>> nameSpaces = context.getNameSpaces(query.getOffset());
        if (nameSpaces != null && (nameSpace = nameSpaces.get(component.getTagLib().getURI())) != null) {
            for (INameSpace n : nameSpace) {
                prefixes.add(n.getPrefix());
            }
        }
        return prefixes;
    }

    @Override
    protected void init(IPageContext context) {
    }
}

