/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.ui.view.server.editor;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;
import org.fusesource.ide.server.karaf.ui.KarafUIPlugin;
import org.fusesource.ide.server.karaf.ui.SshConnector;
import org.fusesource.ide.server.karaf.ui.view.server.editor.CommonActionProviderUtils;

public class ShowInShellActionProvider
extends CommonActionProvider {
    private ICommonActionExtensionSite actionSite;
    private ShowInShellAction showInShellAction;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.actionSite = aSite;
        this.createActions(aSite);
    }

    protected void createActions(ICommonActionExtensionSite aSite) {
        ICommonViewerWorkbenchSite commonViewerWorkbenchSite = CommonActionProviderUtils.getCommonViewerWorkbenchSite(aSite);
        if (commonViewerWorkbenchSite != null) {
            this.showInShellAction = new ShowInShellAction(commonViewerWorkbenchSite.getSelectionProvider());
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        CommonActionProviderUtils.addToShowInQuickSubMenu((IAction)this.showInShellAction, menu, this.actionSite);
    }

    public class ShowInShellAction
    extends AbstractServerAction {
        public ShowInShellAction(ISelectionProvider sp) {
            super(sp, null);
            IViewRegistry reg = PlatformUI.getWorkbench().getViewRegistry();
            IViewDescriptor desc = reg.find("org.fusesource.ide.server.view.TerminalView");
            this.setText(desc.getLabel());
            this.setImageDescriptor(desc.getImageDescriptor());
        }

        public boolean accept(IServer server) {
            return server != null && server.getServerState() == 2 && KarafUIPlugin.getDefault().isKarafServer(server);
        }

        public void perform(IServer server) {
            SshConnector c = SshConnector.getConnectorForServer(server);
            if (c == null) {
                c = new SshConnector(server);
            } else {
                c.onDisconnect();
            }
            c.start();
        }
    }
}

