/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.ui.runtime.v2x;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.TaskModel;
import org.fusesource.ide.server.karaf.core.runtime.IKarafRuntime;
import org.fusesource.ide.server.karaf.core.runtime.IKarafRuntimeWorkingCopy;
import org.fusesource.ide.server.karaf.core.runtime.KarafRuntimeDelegate;
import org.fusesource.ide.server.karaf.ui.KarafSharedImages;
import org.fusesource.ide.server.karaf.ui.Messages;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanLoader;
import org.jboss.ide.eclipse.as.wtp.ui.composites.AbstractJREComposite;
import org.jboss.ide.eclipse.as.wtp.ui.composites.RuntimeHomeComposite;
import org.jboss.ide.eclipse.as.wtp.ui.wizard.RuntimeWizardFragment;
import org.jboss.tools.as.runtimes.integration.ui.composites.DownloadRuntimeHomeComposite;

public class KarafRuntimeFragment
extends RuntimeWizardFragment {
    protected void updateWizardHandle(Composite parent) {
        IRuntime r = this.getRuntimeFromTaskModel();
        this.handle.setTitle(Messages.AbstractKarafRuntimeComposite_wizard_tite);
        String descript = r.getRuntimeType().getDescription();
        this.handle.setDescription(descript);
        this.handle.setImageDescriptor(this.getImageDescriptor());
        this.initiateHelp(parent);
    }

    protected ImageDescriptor getImageDescriptor() {
        String imageKey = "karaf-logo_lg.png";
        return KarafSharedImages.getImageDescriptor(imageKey);
    }

    protected AbstractJREComposite createJRECompositeWidget(Composite main) {
        return new KarafJREComposite(main, 0, this.getTaskModel());
    }

    protected String getExplanationText() {
        return "Please point to a karaf installation.";
    }

    protected void initiateHelp(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.jboss.ide.eclipse.as.doc.user.new_server_runtime");
    }

    protected String getHomeVersionWarning() {
        String homeDir = this.homeDirComposite.getHomeDirectory();
        File loc = new File(homeDir);
        String serverId = new ServerBeanLoader(loc).getServerAdapterId();
        String rtId = serverId == null ? null : ServerCore.findServerType((String)serverId).getRuntimeType().getId();
        IRuntime adapterRt = this.getRuntimeFromTaskModel();
        String adapterRuntimeId = adapterRt.getRuntimeType().getId();
        if (!adapterRuntimeId.equals(rtId)) {
            return NLS.bind((String)"Incorrect Version Error{0} {1}", (Object)adapterRt.getRuntimeType().getVersion(), (Object)this.getVersionString(loc));
        }
        return null;
    }

    protected void saveJreInRuntime(IRuntimeWorkingCopy wc) {
        IKarafRuntimeWorkingCopy srt = (IKarafRuntimeWorkingCopy)wc.loadAdapter(IKarafRuntimeWorkingCopy.class, (IProgressMonitor)new NullProgressMonitor());
        if (srt != null) {
            IExecutionEnvironment selectedEnv = this.jreComposite.getSelectedExecutionEnvironment();
            IVMInstall selectedVM = this.jreComposite.getSelectedVM();
            srt.setVM(selectedVM);
            srt.setExecutionEnvironment(selectedEnv);
        }
    }

    protected RuntimeHomeComposite createHomeCompositeWidget(Composite main) {
        return new DownloadRuntimeHomeComposite(main, 0, this.handle, this.getTaskModel());
    }

    protected void saveRuntimeLocationInPreferences(IRuntime runtime) {
    }

    protected class KarafJREComposite
    extends AbstractJREComposite {
        public KarafJREComposite(Composite parent, int style, TaskModel tm) {
            super(parent, style, tm);
        }

        protected boolean isUsingDefaultJRE(IRuntime rt) {
            IRuntime r = this.getRuntimeFromTaskModel();
            IKarafRuntime jbsrt = (IKarafRuntime)r.loadAdapter(IKarafRuntime.class, null);
            return jbsrt.isUsingDefaultJRE();
        }

        protected IVMInstall getStoredJRE(IRuntime rt) {
            IRuntime r = this.getRuntimeFromTaskModel();
            IKarafRuntime jbsrt = (IKarafRuntime)r.loadAdapter(IKarafRuntime.class, null);
            return jbsrt.isUsingDefaultJRE() ? null : jbsrt.getVM();
        }

        public List<IVMInstall> getValidJREs() {
            IRuntime r = this.getRuntimeFromTaskModel();
            IKarafRuntime jbsrt = (IKarafRuntime)r.loadAdapter(IKarafRuntime.class, null);
            return Arrays.asList(jbsrt.getValidJREs());
        }

        protected IRuntime getRuntimeFromTaskModel() {
            return (IRuntime)this.getTaskModel().getObject("runtime");
        }

        protected boolean isUsingDefaultJRE() {
            IRuntime r = this.getRuntimeFromTaskModel();
            IKarafRuntime jbsrt = (IKarafRuntime)r.loadAdapter(IKarafRuntime.class, null);
            return jbsrt.isUsingDefaultJRE();
        }

        protected IVMInstall getStoredJRE() {
            IRuntime r = this.getRuntimeFromTaskModel();
            IKarafRuntime jbsrt = (IKarafRuntime)r.loadAdapter(IKarafRuntime.class, null);
            return ((KarafRuntimeDelegate)jbsrt).getHardVM();
        }

        public IExecutionEnvironment getMinimumExecutionEnvironment() {
            IRuntime r = this.getRuntimeFromTaskModel();
            IKarafRuntime jbsrt = (IKarafRuntime)r.loadAdapter(IKarafRuntime.class, null);
            return jbsrt.getMinimumExecutionEnvironment();
        }

        public IExecutionEnvironment getStoredExecutionEnvironment() {
            IRuntime r = this.getRuntimeFromTaskModel();
            IKarafRuntime jbsrt = (IKarafRuntime)r.loadAdapter(IKarafRuntime.class, null);
            return jbsrt.getExecutionEnvironment();
        }
    }
}

