/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.ui.runtime;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.runtime.IKarafRuntime;
import org.fusesource.ide.server.karaf.core.runtime.IKarafRuntimeWorkingCopy;
import org.fusesource.ide.server.karaf.ui.runtime.AbstractKarafRuntimeComposite;
import org.fusesource.ide.server.karaf.ui.runtime.KarafWizardDataModel;

public abstract class AbstractKarafRuntimeWizardFragment
extends WizardFragment {
    protected AbstractKarafRuntimeComposite composite = null;
    protected final KarafWizardDataModel model = new KarafWizardDataModel();

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.getTaskModel().putObject("karaf-model", (Object)this.model);
        this.populateModel();
        this.composite = this.getRuntimeComposite(parent, handle, this.model);
        this.composite.createContents();
        return this.composite;
    }

    public boolean hasComposite() {
        return true;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        super.performFinish(monitor);
        if (this.composite != null) {
            this.composite.performFinish();
        }
        this.updateRuntime();
    }

    public void performCancel(IProgressMonitor monitor) throws CoreException {
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.cancel();
        }
        super.performCancel(monitor);
    }

    protected IRuntimeWorkingCopy getRuntimeWorkingCopy() {
        return (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
    }

    protected void populateModel() {
        IKarafRuntime karafRuntime;
        IRuntimeWorkingCopy workingCopy = this.getRuntimeWorkingCopy();
        if (workingCopy != null && (karafRuntime = (IKarafRuntime)workingCopy.loadAdapter(IKarafRuntime.class, (IProgressMonitor)new NullProgressMonitor())) != null) {
            IPath loc = karafRuntime.getLocation();
            this.model.setKarafInstallDir(loc == null ? null : loc.toOSString());
        }
    }

    private void updateRuntime() {
        IKarafRuntimeWorkingCopy karafRuntimeWorkingCopy;
        IRuntimeWorkingCopy workingCopy = this.getRuntimeWorkingCopy();
        if (workingCopy != null && (karafRuntimeWorkingCopy = (IKarafRuntimeWorkingCopy)workingCopy.loadAdapter(IKarafRuntimeWorkingCopy.class, (IProgressMonitor)new NullProgressMonitor())) != null) {
            String installDir = this.model.getKarafInstallDir();
            Path path = new Path(installDir);
            workingCopy.setLocation((IPath)path);
        }
        try {
            workingCopy.save(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.getLogger().error((Throwable)e);
        }
    }

    protected abstract AbstractKarafRuntimeComposite getRuntimeComposite(Composite var1, IWizardHandle var2, KarafWizardDataModel var3);

    public boolean isComplete() {
        return this.composite != null ? this.composite.isValid() : true;
    }

    public void enter() {
        if (this.composite != null && !this.composite.isDisposed()) {
            IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
            this.composite.setRuntime(runtime);
        }
    }
}

