/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.ui;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.server.core.IServer;
import org.fusesource.ide.server.karaf.core.Messages;
import org.fusesource.ide.server.karaf.core.server.IKarafServerDelegate;
import org.fusesource.ide.server.karaf.ui.KarafUIPlugin;
import org.fusesource.ide.server.view.ITerminalConnectionListener;
import org.fusesource.ide.server.view.SshView;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;

public class SshConnector
implements ITerminalConnectionListener {
    private static HashMap<IServer, SshConnector> connectors = new HashMap();
    private int port;
    private String host;
    private String userName;
    private String passwd;
    private IServer server;
    private IControllableServerBehavior behaviorDelegate;
    private static final String TERMINAL_VIEW_LABEL = Messages.shellViewLabel;

    public SshConnector(IServer server) {
        this.server = server;
        this.behaviorDelegate = (IControllableServerBehavior)server.loadAdapter(IControllableServerBehavior.class, (IProgressMonitor)new NullProgressMonitor());
        IKarafServerDelegate config = (IKarafServerDelegate)server.loadAdapter(IKarafServerDelegate.class, (IProgressMonitor)new NullProgressMonitor());
        this.host = server.getHost();
        this.port = config.getPortNumber();
        this.userName = config.getUserName();
        this.passwd = config.getPassword();
    }

    public SshConnector(IServer server, IControllableServerBehavior behaviorDelegate, String host, int port, String user, String pass) {
        this.server = server;
        this.behaviorDelegate = behaviorDelegate;
        this.host = host;
        this.port = port;
        this.userName = user;
        this.passwd = pass;
    }

    public void start() {
        IViewPart vp = KarafUIPlugin.openTerminalView();
        if (vp == null || !(vp instanceof SshView)) {
            KarafUIPlugin.getLogger().error("Unable to open the terminal view!");
            return;
        }
        SshView connectorView = (SshView)vp;
        connectorView.setPartName(this.server.getName());
        connectorView.addConnectionListener((ITerminalConnectionListener)this);
        try {
            connectorView.createConnectionIfNotExists(this.host, this.port, this.userName, this.passwd);
        }
        catch (Exception ex) {
            KarafUIPlugin.getLogger().error("Unable to connect via SSH", (Throwable)ex);
        }
    }

    public void onConnect() {
        connectors.put(this.server, this);
        KarafUIPlugin.openTerminalView().setFocus();
    }

    public void onDisconnect() {
        IViewPart vp = KarafUIPlugin.openTerminalView();
        if (vp == null || !(vp instanceof SshView)) {
            KarafUIPlugin.getLogger().error("Unable to open the terminal view!");
            return;
        }
        SshView connectorView = (SshView)vp;
        connectorView.addConnectionListener((ITerminalConnectionListener)this);
        connectorView.setPartName(TERMINAL_VIEW_LABEL);
        connectorView.onTerminalDisconnect();
        connectors.remove(this.server);
    }

    public static SshConnector getConnectorForServer(IServer server) {
        return connectors.get(server);
    }
}

