/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerEvent;
import org.fusesource.ide.commons.logging.RiderLogFacade;
import org.fusesource.ide.server.karaf.core.server.IKarafServerDelegate;
import org.fusesource.ide.server.karaf.ui.KarafSharedImages;
import org.fusesource.ide.server.karaf.ui.SshConnector;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListener;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListenerManager;
import org.osgi.framework.BundleContext;

public class KarafUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.fusesource.ide.server.karaf.ui";
    public static final String TERMINAL_VIEW_ID = "org.fusesource.ide.server.view.TerminalView";
    private static KarafUIPlugin plugin;
    private UnitedServerListener serverListener;

    public static KarafUIPlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.serverListener = this.getServerListener();
        UnitedServerListenerManager.getDefault().addListener(this.serverListener);
    }

    public boolean isKarafServer(IServer server) {
        return (IKarafServerDelegate)server.loadAdapter(IKarafServerDelegate.class, (IProgressMonitor)new NullProgressMonitor()) != null;
    }

    private UnitedServerListener getServerListener() {
        return new UnitedServerListener(){

            public boolean canHandleServer(IServer server) {
                return KarafUIPlugin.this.isKarafServer(server);
            }

            public void serverChanged(ServerEvent event) {
                if (1.serverSwitchesToState((ServerEvent)event, (int)2)) {
                    IServer s = event.getServer();
                    this.fireConnectorJob(s);
                }
            }

            private void fireConnectorJob(final IServer server) {
                new Job("Connecting to " + server.getName()){

                    protected IStatus run(IProgressMonitor arg0) {
                        if (server.getServerState() == 2) {
                            SshConnector c = new SshConnector(server);
                            c.start();
                            return Status.OK_STATUS;
                        }
                        return Status.CANCEL_STATUS;
                    }
                }.schedule();
            }
        };
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        KarafSharedImages.instance().cleanup();
        if (this.serverListener != null) {
            UnitedServerListenerManager.getDefault().removeListener(this.serverListener);
        }
    }

    public static IViewPart openTerminalView() {
        final IViewPart[] ret = new IViewPart[]{null};
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage activePage;
                IWorkbenchWindow activeWindow;
                IWorkbench wb = PlatformUI.getWorkbench();
                if (wb != null && (activeWindow = wb.getActiveWorkbenchWindow()) != null && (activePage = activeWindow.getActivePage()) != null) {
                    try {
                        ret[0] = activePage.showView(KarafUIPlugin.TERMINAL_VIEW_ID);
                    }
                    catch (CoreException ex) {
                        KarafUIPlugin.getLogger().error("Unable to create the terminal view!", (Throwable)ex);
                    }
                }
            }
        });
        return ret[0];
    }

    public static RiderLogFacade getLogger() {
        return RiderLogFacade.getLog((ILog)KarafUIPlugin.getDefault().getLog());
    }
}

