/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.ui;

import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.server.karaf.ui.KarafUIPlugin;
import org.osgi.framework.Bundle;

public class KarafSharedImages {
    public static final String IMG_KARAF_LOGO_LARGE = "karaf-logo_lg.png";
    private static KarafSharedImages instance;
    private Hashtable<String, Object> images;
    private Hashtable<String, Object> descriptors;

    private KarafSharedImages() {
        instance = this;
        this.images = new Hashtable();
        this.descriptors = new Hashtable();
        if (KarafUIPlugin.getDefault() == null || KarafUIPlugin.getDefault().getBundle() == null) {
            return;
        }
        Bundle pluginBundle = KarafUIPlugin.getDefault().getBundle();
        this.descriptors.put(IMG_KARAF_LOGO_LARGE, this.createImageDescriptor(pluginBundle, "/icons/karaf-logo_lg.png"));
        for (String key : this.descriptors.keySet()) {
            ImageDescriptor descriptor = this.descriptor(key);
            this.images.put(key, descriptor.createImage());
        }
    }

    private ImageDescriptor createImageDescriptor(Bundle pluginBundle, String relativePath) {
        return ImageDescriptor.createFromURL((URL)pluginBundle.getEntry(relativePath));
    }

    public static KarafSharedImages instance() {
        if (instance == null) {
            instance = new KarafSharedImages();
        }
        return instance;
    }

    public static Image getImage(String key) {
        return KarafSharedImages.instance().image(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return KarafSharedImages.instance().descriptor(key);
    }

    public Image image(String key) {
        return (Image)this.images.get(key);
    }

    public ImageDescriptor descriptor(String key) {
        return (ImageDescriptor)this.descriptors.get(key);
    }

    public void cleanup() {
        Iterator<String> iter = this.images.keySet().iterator();
        while (iter.hasNext()) {
            Image image = (Image)this.images.get(iter.next());
            image.dispose();
        }
        this.images = null;
        this.descriptors = null;
        instance = null;
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }
}

